/* Trivial slicing of a {salamic_mesh_t}. */
/* Last edited on 2015-10-09 19:50:38 by stolfilocal */

#ifndef salamic_slicer_trivial_H
#define salamic_slicer_trivial_H

#define _GNU_SOURCE
#include <stdint.h>

#include <bool.h>
#include <vec.h>

#include <stmesh.h>
#include <salamic_slicer.h>
#include <salamic_stats.h>

void salamic_slicer_trivial_slice 
  ( stmesh_t mesh,
    int_vec_t *planeZ, 
    char *closer, 
    char *outPrefix, 
    salamic_stats_t *st
  );
  /* Slices the mesh {mesh} by a list of horizontal planes, defined
    by their Z-coordinates {planeZ.e[0..np-1]} where {np = planeZ.ne}.
    Uses the trivial algorithm (check each plane against each face).
    See {salamic_slicer.h} for additional requirements and 
    for the meaning of other parameters. */

#endif
