#! /bin/bash
# Last edited on 2015-11-16 03:04:55 by stolfilocal

# echo "args = ${*}"

set -u

sourceDir="$1"; shift;   # Directory containing the model file.
modelName="$1"; shift;   # Model STL file name (without ".stl" extension).
slicer="$1"; shift;      # Slicing method ("TRIVIAL" or "MINETTO"). 
closer="$1"; shift;      # Loop closing method ("TRIVIAL" or "STOLFI"). 

planes=( "$@" )

for pz in "${planes[@]}" ; do 
  cp -av ${sourceDir}/${modelName}-${slicer}-${closer}${pz}.txt ${modelName}/slice${pz}.txt
done

