# Generic Makefile to run tests of one or more programs
# Last edited on 2016-04-03 13:24:36 by stolfilocal

######################################################################
# To be included by the top-level Makefile in the program's directory.
# The caller must define
#
#   ${PROGDIR}           dir containing the executable program to be tested and its sources
#   ${PROG} or ${PROGS}  names of test programs (WITHOUT dir or extension)
#   
# The client must define the "all", "run", and "clean" targets.

include GENERIC.make

ifeq "/${PROGS}" "/"
PROGS := ${PROG}
endif

ifneq "/${PROGS}" "/"
ifneq "/${PROGDIR}" "/"

# ----------------------------------------------------------------------
# Locations of imported packages

# Location of Stolfi's headers and libraries:
JS_PUB_DIR := ./
JS_LIB_DIR := ./
JS_INC_DIR := ./

#---------------------------------------------------------------------
# Default target for "make" with no target: 

all: check

#---------------------------------------------------------------------
# "make actions" performs the ${ACTIONS} locally:

actions:
ifeq "/${ACTIONS}" "/"
	@echo '$${ACTIONS} is empty'
else
	${MAKE} ${ACTIONS}
endif

#---------------------------------------------------------------------
# "make build" and "make build-progs" make sure that the
# executables in ${PROGDIR} are up to date:

build: build-progs
build-tests: build-progs
  
PROG_XFILES := ${addprefix ${PROGDIR}/, ${PROGS}}

build-progs: ${PROG_XFILES}

${PROG_XFILES}: \
          ${wildcard ${PROGDIR}/*.h ${PROGDIR}/*.c} \
          ${wildcard ${JS_INC_DIR}/*.ho} \
          ${wildcard ${JS_LIB_DIR}/*.a ${JS_LIB_DIR}/*.so}
	@echo "rebuilding ${PROG_XFILES} ..."
	cd ${PROGDIR}/. && ${MAKE} ${PROGS}

#---------------------------------------------------------------------
# "make install" is a no-op:

install: 

#---------------------------------------------------------------------
# "make uninstall" is a no-op:

uninstall: 

#---------------------------------------------------------------------
# "make clean" deletes all derived files.
# It is a double-colon rule so that clients may add more actions.

clean::
        
endif
endif
# End of ${PROG} ${PROGDIR} section.
######################################################################

#---------------------------------------------------------------------
# "make debug" prints some debugging info:
debug:
	@echo "PROG = ${PROG}"
	@echo "PROGS = ${PROGS}"
	@echo "PROG_DIR = ${PROG_DIR}"
