# Generic statements for most program makefiles.
# Last edited on 2012-07-28 12:54:04 by stolfilocal

######################################################################
# Usually included by "GENERIC-*.make" files
# The caller must define 
#
#   ${STOLFIHOME} directory with stolfi's bin, lib, include, etc.
# 
# The caller may also define 
# 
#   ${ACTIONS} a list of make actions to be performed in turn
#

SHELL := /bin/bash

# Where to install scripts and programs:
INST_PUB_DIR := ${STOLFIHOME}
INST_BIN_DIR := ${INST_PUB_DIR}/bin
INST_LIB_DIR := ${INST_PUB_DIR}/lib
INST_MAN_DIR := ${INST_PUB_DIR}/man
INST_CAT_DIR := ${INST_PUB_DIR}/cat

#---------------------------------------------------------------------
# Phony "make" targets:

.PHONY:: \
  default-action \
  all actions debug \
  depend \
  uninstall uninstall-lib uninstall-libs uninstall-prog uninstall-progs uninstall-man \
  build \
  depend-lib depend-libs build-lib build-libs do-build-lib \
  depend-prog depend-progs build-prog build-progs do-build-progs \
  depend-tests build-tests do-build-tests check \
  install install-libs install-lib install-prog install-progs install-man \
  tar-export tar-save find-all-sources \
  clean clean-lib clean-libs clean-prog clean-progs clean-tests

# ----------------------------------------------------------------------
# This will usually be the first action encountered by "make". 
# Defined so that "make" with no action does "make all" which must be defined by user:
default-action: all

# ----------------------------------------------------------------------
# "make find-all-sources" creates lists of source files, makefiles, 
# C files, etc.  the current directory:

find-all-sources: 
	  make-sources-cprogs-makefiles-lists -notheses        

# ----------------------------------------------------------------------
# "make find-all-files" creates a list of all files with size and mod-date:

find-all-files: 
	  find-all-files-size-date ./ > .all-files.sdf       
