/* jspng_image.h - routines to read and write PNG files. */
/* Last edited on 2012-06-09 21:56:09 by stolfilocal */

/* Created by R. Minetto (IC-UNICAMP) as {ipng.h} sometime in 2008--2009. */
/* Adapted by J. Stolfi (IC-UNICMP) on 2011-05-14. */

#ifndef jspng_image_H
#define jspng_image_H

#define _GNU_SOURCE
#include <stdio.h>
#include "jspnm_image.h" 

/* These procedures read/write a PNG file into/from the {pnm_image_t} 
  memory format defined in {jspnm_image.h}. */

pnm_image_t *jspng_image_read (char *name, double *gammaP, bool_t verbose);
  /* Reads an image from the named PNG file. The resulting {pnm_image_t} may
    have 1 to 4 channels:
    
      1: PNG type was grayscale image.
      
      2: PNG type was grayscale + alpha.
      
      3: PNG type was RGB.
      
      4: PNG type was RGB + alpha.
      
    If an alpha channel is present, it will be the last one.
  
    The {maxval} will be 1, 3, 15, 255 or 65535.  Returns in {*gammaP} the 
    gamma exponent specified in the file, if present; otherwise
    sets {*gammaP} to NAN.
    
    If the {name} is "-", reads from {stdin}. If {verbose} is TRUE,
    prints a notice to {stderr}. */

void jspng_image_write (char *name, pnm_image_t *img, double gamma, bool_t verbose);
  /* Writes image {img} to the specified file in PNG format.  The 
    image may have 1 to 4 channels:
    
      1: PNG type will be grayscale image.
      
      2: PNG type will be grayscale + alpha.
      
      3: PNG type will be RGB.
      
      4: PNG type will be RGB + alpha.
    
    The {gamma} parameter is merely written to the file as the 'gAMA' chunk;
    the pixels are not modified.  If {gamma} is NAN, zero, or negative,
    the chunk is omitted.
    
    If {maxval} is 1,3,5,7,15,17,31,51,63,85,127, or 255, uses 8 bits
    per sample, else uses 16 bits. If maxval is either 255 nor 65535, the samples will be
    written unchanged. Otherwise, the samples will be linearly scaled
    so that {maxval} is mapped to {2^m-1}, for some {m} in 1..16.
    If {maxval} is {2^k-1}, or 5,17,51,85,
    257,771,1285,3855,4639,13107,21845, the scaling will be exact. In
    particular, Otherwise, the scaling may have hiccups due to
    rounding.
    
    If {name} is "-", writes to {stdout}. If {verbose} is TRUE, prints
    a notice to {stderr}. */

pnm_image_t *jspng_image_fread (FILE *rd, double *gammaP, bool_t verbose);
void jspng_image_fwrite (FILE *wr, pnm_image_t *img, double gamma, bool_t verbose);
  /* Same as {jspng_image_read} and {jspng_image_write}, 
    but from/to a previously opened file handle. */

#endif
