/* mtv_cup.h --- splats a cup at the end of the Tesla valve. */
/* Last edited on 2016-04-03 23:13:44 by stolfilocal */

#ifndef mtv_cup_H
#define mtv_cup_H

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>
#include <r3.h>
#include <ppv_array.h>

void mtv_cup_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    double cupbotZ, 
    double cuptopZ, 
    double cupR, 
    double cupT, 
    double fuzzR
  );
  /* Splat into {a} a cylindrical cup with bottom at {cupbotZ}, top at {cuptopZ},
    outer radius {cupR}, and walls of thickness {cupT}. */

void mtv_cup_plain_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    double cupbotZ, 
    double cuptopZ, 
    double cupR, 
    double cupT, 
    double cupF,
    double fuzzR
  );
  /* Splat into {a} a cylindrical cup with bottom at {cupbotZ}, top at {cuptopZ},
    outer radius {cupR}, fillet radius {cupF}, and walls of thickness {cupT}. */

void mtv_cup_threaded_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    double cupbotZ, 
    double cuptopZ,
    double cupT,
    double fuzzR,
    double vsz
  );
  /* Splat into {a} a PET bottle screw-on cap with vertical axis through
    the point {ctr}, bottom at {cupbotZ}, top pointing towards
    {cuptopZ}, thickness {cupT}, and fuzziness radius {fuzzR}. All these
    coordinates are in voxels. The other dimesions are automatically
    chosen so that the cap will fit a standard PET sft-drink bottle,
    assuming that the voxels have size {vsz}. */
  
void mtv_cup_thread_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    double thrbotZ, 
    int dirZ,
    double thrR,
    double thrH,
    double thrN,
    double fuzzR
  );
  /* Splats a thread with vertical axis going through {ctr}.
    The thread's helical midline has radius {thrR},
    starts at {thrbotZ}, rises {thrH} voxels per turn,
    and has {thrN} turns. */

#endif
