/* See mtv_valve_helical_tubing_make.h */
/* Last edited on 2016-04-22 18:53:21 by stolfilocal */

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>

#include <bool.h>
#include <r3.h>
#include <r3_path.h>
#include <affirm.h>
#include <ppv_array.h>

#include <mtv_valve_helical_body_make.h>
#include <mtv_valve_helical_connector_make.h>

#include <mtv_valve_helical_tubing_make.h>

void mtv_valve_helical_tubing_make
  ( ppv_array_t *a, 
    r3_t *ctr, 
    double tbbotZ, 
    double tbtopZ, 
    double helixN,  /* Number of turns of the helical part of main channel. */
    double helixR,  /* Radius of midline of helical part of main channel (vx). */
    int32_t stageN, /* Number of stages. */
    double mcA,     /* Nominal angular extent of each stage (rad). */
    double bfD,     /* Angular distance between ends of backflow loop (rad). */
    double bfR,     /* Radius of of final part (the turn) of the backflow loop (vx). */ 
    double bmW,     /* Torsion angle of backflow loop at beginning of the turn (rad). */
    double beW,     /* Torsion angle of backflow loop at end of the turn (rad). */
    double inR, 
    double otR, 
    double fuzzR, 
    bool_t sub,
    r3_path_state_t *tbS0, /* (OUT) State at beginning of helical tube. */
    r3_path_state_t *tbS1  /* (OUT) State at end of helical tube. */
  )
  {
    /* Allow space for top and bottom connectors: */
    double tbextZ = tbtopZ - tbbotZ;      /* Total height of tubes, signed. */
    double hxtopZ = tbtopZ - 0.25*tbextZ; /* Top of helix proper. */
    double hxbotZ = tbbotZ + 0.25*tbextZ; /* Bottom of helix proper. */
    
    /* Make the helical tube with backflow loops: */
    r3_path_state_t vbS0, vbS1;
    mtv_valve_helical_body_make
      ( a, ctr, hxbotZ, hxtopZ, helixN, helixR, 
        stageN, mcA, bfD, bfR, bmW, beW,
        inR, otR, fuzzR, sub,
        &vbS0, &vbS1
      );
    
    /* Make the end conencting tubes: */
    mtv_valve_helical_connector_make(a, ctr, &vbS0, -1, tbbotZ, inR,otR, fuzzR, sub, tbS0);
    mtv_valve_helical_connector_make(a, ctr, &vbS1, +1, tbtopZ, inR,otR, fuzzR, sub, tbS1);
  }

