/* Definitions for generic slicer algorithms. */
/* Last edited on 2016-04-21 19:02:38 by stolfilocal */

#ifndef raspol_slicer_H
#define raspol_slicer_H

#define _GNU_SOURCE
#include <stdint.h>

#include <bool.h>
#include <vec.h>

#include <stpoly.h>
#include <raspol_stats.h>

typedef void raspol_slice_proc_t(int32_t Y, uint32_t na, stpoly_edge_t a[]);
  /* Type of a procedure that is called by {raspol_slicer_slice} to 
    process one horizontal slice of a polygonal figure. 
    The slice is at the horizontal line with quantized 
    ordinate {Y}.  It has {na} crossing edges {a[0..na-1]}. */

void raspol_slicer_slice
  ( stpoly_t poly,
    uint32_t nl, 
    int32_t startY, 
    int32_t stepY, 
    raspol_slice_proc_t proc
  );
  /* Slices the polygonal figure {poly} with {nl} horizontal lines at
    {Y}-coordinates {startY + k*step}, for {k} in {0..nl-1}.
    
    For each raster line, calls {proc(Y,na,a)} with the edges that
    intersect that line, in arbitrary order. Gathers runtime statistics
    in {st}.
    
    The procedure assumes that no vertex of the polygonal figure lies on
    a slicing line, and that every edge of the figure has two distinct
    vertices.
    
    !!! Should sort the edges by {X} of intersection before calling {proc}. !!!
    
  */

#endif
