/* rmxn.h --- m by n matrices and operations on them (TRIMMED) */
/* Last edited on 2016-03-14 11:13:46 by stolfi */

#ifndef rmxn_H
#define rmxn_H

#include <stdio.h>
#include <rn.h>

/* Matrices are assumed to be stored linearized by rows, without gaps;
  so, in a matrix {A} with {m} rows and {n} columns, the logical 
  element {A[i,j]} is actually {A[n*i + j]}.
  
  Unless said otherwise, all output matrices and vectors must be 
  disjoint from each other from all the input ones. */

/* MATRIX FORMATTING */

void rmxn_print (FILE *f, int m, int n, double *A);
  /* Prints the {m x n} matrix {A} to file {f}, with default format. */

void rmxn_gen_print 
  ( FILE *f, int m, int n, double *A,
    char *fmt, 
    char *olp, char *osep, char *orp, /* Outer delimiters. */
    char *ilp, char *isep, char *irp  /* Inner delimiters. */
  );
  /* Prints the {m x n} matrix {A} to file {f}, using {fmt} for each
    element. The matrix is bounded by {olp} and {orp}, and rows are
    separated by {osep}. Each row is bounded by {ilp} and {irp}, and
    elements are separated by {isep}. Defaults are provided for any of
    these strings which are NULL. */

#endif

