/* rn.h --- operations on points and vectors of R^n (TRIMMED) */
/*
  Last edited on 2016-03-14 11:03:31 by stolfi
  Based on VectorN.mg, created  95-02-27 by J. Stolfi.
  Last edited by stolfi 
*/

#ifndef rn_H
#define rn_H

#include <stdio.h>

void rn_print (FILE *f, int n, double *a);
  /* Prints {a} on file {f}, with some default format. */

void rn_gen_print
  ( FILE *f, int n, double *a, 
    char *fmt, 
    char *lp, char *sep, char *rp
  );
  /* Prints {a} on file {f}, formatting each coordinate with {fmt}. 
    The strings {lp}, {sep}, and {rp} are printed respectively before,
    between, and after all the coordinates of {a}.  When NULL, they default 
    to "%16.8e", "(", " ", and ")", respectively. */

#endif
