/* Definitions for generic slicer algorithms. */
/* Last edited on 2016-04-21 16:15:02 by stolfilocal */

#ifndef salamic_slicer_H
#define salamic_slicer_H

#define _GNU_SOURCE
#include <stdint.h>

#include <bool.h>
#include <vec.h>

#include <stmesh.h>
#include <salamic_stats.h>

void salamic_slicer_slice
  ( stmesh_t mesh,
    bool_t preSorted, 
    int_vec_t *planeZ, 
    bool_t uniform,
    char *slicer, 
    char *closer, 
    char *outPrefix, 
    salamic_stats_t *st
  );
  /* Slices the mesh {mesh} with planes at {Z}-coordinates {planeZ.e[0..np-1]*mesh.eps},
    where {np = planeZ.ne}.  Uses the algorithms specified by {slicer} and {closer}.
    
    Allowed values of {slicer} are
    
      | "TRIVIAL" - Trivial slicing: every plane against ever triangle
      | "MINETTO" - Minetto's incremental algorithm
      
    ??? Maybe add "SANG" and "TATA". ???
     
    If the {closer} argument is not "NONE", calls
    {salamic_closer_close(mesh,pZ,mf,f,closer,outPrefix,st)} for each
    slicing plane, where {pZ} is the quantized {Z}-corodinate of the
    plane, and {f[0..mf-1]} are the mesh faces that intercept that
    plane. The faces are listed in arbitrary order. For the allowed
    values of {closer}, see {salamic_closer.h}.
    
    The procedure assumes that no vertex of the mesh lies on a slicing plane,
    and that every face of the mesh has three distinct vertices
    (even if they are collinear). 
    
    ??? Assumes circular sorting of faces ???
    
    The {preSorted} and {uniform} flags are relevant to some slicing
    algorithms. If {preSorted} is true, assumes that the mesh triangles
    are sorted by non-decreasing {.minZ} field. if {uniform} is true,
    assumes that the planes are uniformly spaced.
    
    Writes output files to {outPrefix}. Gathers runtime statistics in {st}. */

#endif
