#ifndef stmesh_view_paint_H
#define stmesh_view_paint_H

/* General painting tools for {stmesh_t} elements. */
/* Last edited on 2015-11-16 01:04:32 by stolfilocal */

#define _GNU_SOURCE

#include <r3.h>
#include <bool.h>
#include <frgb.h>

#include <stmesh.h>
#include <stmesh_section.h>

#define stmesh_view_debug_GL FALSE
  /* If TRUE, report calls to the GL event methods. */

#define stmesh_view_debug_paint FALSE
  /* If TRUE, report calls to internal painting routines. */

/* MEDIUM-LEVEL PAINTING */

void stmesh_view_paint_mesh(stmesh_t mesh, bool_t showFaces, bool_t showEdges);
  /* Paints the given {mesh}. If {showFaces}, paints the triangle interiors.
    if {showEdges}, draws the line segments. */

void stmesh_view_paint_mesh_edges(stmesh_t mesh);
  /* Draws the edges of the {mesh}, color-coded according to their degrees. */

void stmesh_view_paint_mesh_faces(stmesh_t mesh);
  /* Paints the faces of the {mesh}. */

void stmesh_view_paint_slices(stmesh_t mesh, int np, stmesh_section_t *slice[]);
  /* Paints the cross-sections {slice[0..np-1]}. */

void stmesh_view_paint_slice(stmesh_section_t *sec, frgb_t *clr, float lwd);
  /* Paints the cross-section {sec} with lines of color {clr} and width {lwd}. */

void stmesh_view_paint_reference_plane(r3_t *minP, r3_t *maxP, double z);
  /* Paints a horizontal rectangle at height {z}
    (without any scaling). */

/* LOW-LEVEL PAINTING */

void stmesh_view_paint_line(r3_t v[]);
  /* Paints the line segment whose endpoints are {v[0..1]}. Assumes that
    the color has been set. Should be called between {glBegin(GL_LINES} 
    and {glEnd()}. */

void stmesh_view_compute_normal(r3_t *u, r3_t *v, r3_t *n);
  /* Computes the normal {*n} to a plane parallel to the two vectors {u} and {v}. */
   
void stmesh_view_paint_triangle(r3_t v[]);
  /* Paints the triangle whose corners are {v[0..2]}. Assumes that
    the color has been set, and that the triangle is CCW as seen from above.
    Should be called between {glBegin(GL_TRIANGLES)} and {glEnd()}. */
   
void stmesh_view_paint_quad(r3_t v[]);
  /* Paints the quadrilateral whose corners are {v[0..3]}.
    Assumes that the color has been set.  Should be called between {glBegin(GL_QUADS)} 
    and {glEnd()}. */

#endif
