#! /bin/bash
# Last edited on 2015-11-16 14:42:15 by stolfilocal

# Runs {salamic_slice} on given arguments

# echo "args = ${*}"

set -u

modelDir="$1"; shift;    # Directory containing the model file.
modelName="$1"; shift;   # Model STL file name (without ".stl" extension).
modelFormat="$1"; shift; # Model STL file format ("ascii" or "binary")
nfGuess="$1"; shift;     # Guessed number of triangles. 
eps="$1"; shift;         # Quantization length unit (mm). 
planeZFile="$1"; shift;  # Name of file with sling plane {Z}-coords (mm). 
slicer="$1"; shift;      # Slicing method ("TRIVIAL" or "MINETTO"). 
closer="$1"; shift;      # Loop closing method ("TRIVIAL" or "STOLFI"). 

PROGDIR="../.."
PROG="salamic"

echo "modelDir = ${modelDir}" 1>&2
echo "modelName = ${modelName}" 1>&2
echo "modelFormat = ${modelFormat}" 1>&2
echo "nfGuess = ${nfGuess}" 1>&2
echo "eps = ${eps}" 1>&2
echo "planeZFile = ${planeZFile}" 1>&2
echo "slicer = ${slicer}" 1>&2
echo "closer = ${closer}" 1>&2

outPrefix="out/${modelName}-${slicer}-${closer}"

rm -f ${outPrefix}*.txt

set -x

${PROGDIR}/${PROG} \
    -eps ${eps} \
    -planeZFile ${planeZFile}.txt \
    -modelFile ${modelDir}/${modelName}.stl \
    -format ${modelFormat} \
    -nfGuess ${nfGuess} \
    -slicer ${slicer} \
    -closer ${closer} \
    -outPrefix ${outPrefix} \
  2>&1 | tee ${outPrefix}.log
 
set +x
   
# Get the slice files, if any:
shopt -s nullglob
slice=( out/${modelName}-${slicer}-${closer}*.txt )
shopt -u nullglob
printf "found %d slice files\n" "${#slice[@]}" 1>&2
sliceOps=()
for s in "${slice[@]}" ; do 
  sliceOps+=( -sliceFile "${s}" )
done


stmesh_view \
  -title "${modelName}" \
  -eps ${eps} \
  -format ${modelFormat} \
  -nfGuess ${nfGuess} \
  ${sliceOps[@]} \
  ${modelDir}/${modelName}.stl
  
