#! /bin/bash
# Last edited on 2015-11-16 02:57:47 by stolfilocal

# Runs {salamic_slice} on given arguments

# echo "args = ${*}"

modelDir="$1"; shift;    # Directory containing the model file.
modelName="$1"; shift;   # Model STL file name (without ".stl" extension).
modelFormat="$1"; shift; # Model STL file format ("ascii" or "binary")
nfGuess="$1"; shift;     # Guessed number of triangles. 
eps="$1"; shift;         # Quantization length unit (mm). 
startZ="$1"; shift;      # Z-coord of initial slicing plane (mm). 
deltaZ="$1"; shift;      # Z-spacing of slicing planes (mm). 
slicer="$1"; shift;      # Slicing method ("TRIVIAL" or "MINETTO"). 
closer="$1"; shift;      # Loop closing method ("TRIVIAL" or "STOLFI"). 

PROGDIR="../.."
PROG="salamic"

echo "modelDir = ${modelDir}" 1>&2
echo "modelName = ${modelName}" 1>&2
echo "modelFormat = ${modelFormat}" 1>&2
echo "nfGuess = ${nfGuess}" 1>&2
echo "eps = ${eps}" 1>&2
echo "startZ = ${startZ}" 1>&2
echo "deltaZ = ${deltaZ}" 1>&2
echo "slicer = ${slicer}" 1>&2
echo "closer = ${closer}" 1>&2

outPrefix="out/${modelName}-${slicer}-${closer}"

rm -f ${outPrefix}*.txt

${PROGDIR}/${PROG} \
    -eps ${eps} \
    -startZ ${startZ} -deltaZ ${deltaZ} \
    -modelFile ${modelDir}/${modelName}.stl \
    -format ${modelFormat} \
    -nfGuess ${nfGuess} \
    -slicer ${slicer} \
    -closer ${closer} \
    -outPrefix ${outPrefix} \
  2>&1 | tee ${outPrefix}.log
    
    
