#ifndef ER_LEAST_SQUARES_H
#define ER_LEAST_SQUARES_H

#include <er_ECLES_exact_ls.h>

    void determineLSSystem(int n, int m, fmpz_mat_t M, fmpz_mat_t U, int Pc[], int fac[]);

    void determineLSMatrix(int m, int r, int n, fmpz_mat_t W, fmpz_mat_t L, fmpz_mat_t DG, fmpz_mat_t U, int Pc[], fmpq_mat_t M1, fmpq_mat_t M2, fmpq_mat_t M3, fmpq_mat_t M4);
    /** ******************************************************************************************************
        Função que determina a matrix de mínimos quadrados, recebe as matrizes W, U, Pc.

        Retorna as matrizes {M1 = 2 * W}, {M2 = L * D-1 * U * Pc}, {M3 = } {M4 = U * M^{-1} * U^{T}}.
    ******************************************************************************************************** */


    void determineWeightMatrix(int n, fmpz_mat_t W);
    /** *******************************************************************************************************
        Função para calcular a matriz de minimos quadrados M, recebe como entrada uma matriz de pesos W.

        Retorna a matriz W atualizada para 2 * W. (Função interna)
    ******************************************************************************************************** */


    void solveLSSystem(int r, int n, fmpq_mat_t M1, fmpq_mat_t M2, fmpq_mat_t M3, fmpq_mat_t M4, fmpz_mat_t B_pr, int p, fmpq_mat_t P1, fmpq_mat_t P2);
    /** *******************************************************************************************************
        Resolve o sistema de mínimos quadrados em duas partes. Recebe as matrizes M1, M2, M3 e M4 que formam a
        matrix de mínimos quadrados e a matriz Y, que é parte do lado direito do sistema, que será resolvido.

        Retorna a matriz X, resultado da resolução do sistema.
    ******************************************************************************************************** */


    void solveFirstPart(int m, fmpq_mat_t M2, fmpq_mat_t M4, fmpz_mat_t B_pr, int p, fmpq_mat_t P1, fmpq_mat_t G);
    /** *******************************************************************************************************
        Função que resolve Gama, recebe as matrizes M1, M2, M3 e M4, anteriores e o vetor P'(D).

        Retorna a matriz de Gama (G).
    ******************************************************************************************************** */


    void solveSecondPart(int n, fmpq_mat_t M1, fmpq_mat_t M3, fmpq_mat_t P1, fmpq_mat_t G, int p, fmpq_mat_t P2);
    /** *******************************************************************************************************
        Função que resolve P''(D), recebe as matrizes M1, M3 e Gama(G), anteriores e o vetor P'(D).

        Retorna a matriz de P''(D).
    ******************************************************************************************************** */


    bool verifySolution(int m, int n, int p, fmpz_mat_t A, fmpz_mat_t B, fmpq_mat_t P2, double *Xd);
    /** *******************************************************************************************************

    ******************************************************************************************************** */


#endif // ER_LEAST_SQUARES_H
