#include "MultiIndex.h"
#include<stdlib.h>

MultiIndex::MultiIndex(int dim)
{
	this->dim = dim;
	this->mIdx = (int* )calloc(dim+1,sizeof(int));
}

MultiIndex::MultiIndex(int dim,int set_all_values_to)
{
	this->dim = dim;
	this->mIdx = (int* )calloc(dim+1,sizeof(int));
	int i;
	for(i=0;i<=dim;i++)
		this->mIdx[i] = set_all_values_to;
}


MultiIndex::~MultiIndex()
{
}

bool MultiIndex::equals(MultiIndex* op)
{
	if(this->dim!=op->dim)
		return false;
	
	int i;
	for(i=0;i<=this->dim;i++)
		if(this->mIdx[i]!=op->mIdx[i])
			return false;
	
	return true;
}

MultiIndex* MultiIndex::getSubIndex(int subDim,int* subIdx)
{
	MultiIndex* subIndex = new MultiIndex(subDim);
		
	int i;
	
	for(i=0;i<=subDim;i++)
		subIndex->mIdx[i]=this->mIdx[subIdx[i]];
	
	return subIndex;
}
MultiIndex* MultiIndex::insertElement(int pos,int el)
{
	MultiIndex* newm = new MultiIndex(this->dim+1);
	
	int i;
	for(i=0;i<pos;i++)
		newm->mIdx[i] = this->mIdx[i];
	newm->mIdx[pos] = el;
	
	for(i=pos+1;i<this->dim+2;i++)
		newm->mIdx[i] = this->mIdx[i-1];
	
	return newm;
	
}

MultiIndex* MultiIndex::clone()
{
	MultiIndex* newm = new MultiIndex(this->dim);
	
	int i;
	for(i=0;i<=this->dim;i++)
		newm->mIdx[i] = this->mIdx[i];
		
	return newm;
	
}

void MultiIndex::print(FILE* fp)
{
	int i;
	fprintf(fp,"\n[");
	for(i=0;i<=this->dim;i++)
		fprintf(fp,"%d,",this->mIdx[i]);
	fprintf(fp,"]\n");
}

