#include "DomainMapping.h"

DomainMapping::DomainMapping()
{

}


void DomainMapping::buildIM_matrices()
{
	int destOrder,origOrder;
	origOrder = this->origDomain->dim+1;
	destOrder = this->destDomain->dim+1;
	
	Number *f = new Number(1.f/origOrder);
	
	int i,j,k,l;
	for(i=0;i< destOrder;i++)
		for(j=0;j<= this->destDomain->mIdx[i];j++)
		{
			IM[i][j] = new IrregularMatrix(this->origDomain);
			IM[i][j]->allocate();
			for(k=0;k<=this->origDomain->dim;k++)
				for(l=0;l<=this->origDomain->mIdx[k];l++)
					IM[i][j]->data[k][l] = f->times(this->M[k][i]->data[l][j]);
		}
	
	delete(f);
			
	
	
}

DomainMapping* DomainMapping::example01()
{
	DomainMapping* DM = new DomainMapping();
	DM->origDomain = new MultiIndex(0,2);
	DM->destDomain = new MultiIndex(0,2);
	DM->allocateM();
	DomainPoint** cImgs = new DomainPoint*[3];
	cImgs[0] = new DomainPoint(DM->destDomain);
	cImgs[1] = new DomainPoint(DM->destDomain);
	cImgs[2] = new DomainPoint(DM->destDomain);
	
	cImgs[0]->allocate();
	cImgs[1]->allocate();
	cImgs[2]->allocate();
	
	cImgs[0]->data[0][0] = new Number(0.5);
	cImgs[0]->data[0][1] = new Number(0.5);
	cImgs[0]->data[0][2] = new Number(0);
	
	cImgs[1]->data[0][0] = new Number(0);
	cImgs[1]->data[0][1] = new Number(0.5);
	cImgs[1]->data[0][2] = new Number(0.5);
	
	cImgs[2]->data[0][0] = new Number(0.5);
	cImgs[2]->data[0][1] = new Number(0);
	cImgs[2]->data[0][2] = new Number(0.5);
	
	
	DM->M[0][0] =DomainMapping::buildAffineTransf_Ak_to_Ad(2,2,cImgs);
	
	return DM;
}


DomainMapping* DomainMapping::example02()
{
	DomainMapping* DM = new DomainMapping();
	DM->origDomain = new MultiIndex(0,2);
	DM->destDomain = new MultiIndex(1,1);
	DM->allocateM();
	DomainPoint** cImgs = new DomainPoint*[3];
	cImgs[0] = new DomainPoint(DM->destDomain);
	cImgs[1] = new DomainPoint(DM->destDomain);
	cImgs[2] = new DomainPoint(DM->destDomain);
	
	cImgs[0]->allocate();
	cImgs[1]->allocate();
	cImgs[2]->allocate();
	
	cImgs[0]->data[0][0] = new Number(0.5);
	cImgs[0]->data[0][1] = new Number(0.5);
	
		
	cImgs[1]->data[0][0] = new Number(0.2);
	cImgs[1]->data[0][1] = new Number(0.8);
	
	cImgs[2]->data[0][0] = new Number(0.2);
	cImgs[2]->data[0][1] = new Number(0.8);
	
		
	DM->M[0][0] =DomainMapping::buildAffineTransf_Ak_to_Ad(2,1,cImgs);
	
	cImgs[0]->data[0][0] = new Number(0.5);
	cImgs[0]->data[0][1] = new Number(0.5);
		
			
	cImgs[1]->data[0][0] = new Number(0);
	cImgs[1]->data[0][1] = new Number(1);
		
	cImgs[2]->data[0][0] = new Number(1);
	cImgs[2]->data[0][1] = new Number(0);
		
			
	DM->M[0][1] =DomainMapping::buildAffineTransf_Ak_to_Ad(2,1,cImgs);
	
	
	return DM;
}

DomainMapping* DomainMapping::example03()
{
	DomainMapping* DM = new DomainMapping();
	DM->origDomain = new MultiIndex(1,1);
	DM->destDomain = new MultiIndex(0,2);
	DM->allocateM();
	DomainPoint** cImgs = new DomainPoint*[2];
	cImgs[0] = new DomainPoint(DM->destDomain);
	cImgs[1] = new DomainPoint(DM->destDomain);
	
	
	cImgs[0]->allocate();
	cImgs[1]->allocate();
	
	
	cImgs[0]->data[0][0] = new Number(0);
	cImgs[0]->data[0][1] = new Number(0);
	cImgs[0]->data[0][2] = new Number(1);
		
	cImgs[1]->data[0][0] = new Number(1);
	cImgs[1]->data[0][1] = new Number(0);
	cImgs[1]->data[0][2] = new Number(0);
	
	
		
	DM->M[0][0] =DomainMapping::buildAffineTransf_Ak_to_Ad(1,2,cImgs);
	
	cImgs[0]->data[0][0] = new Number(0);
	cImgs[0]->data[0][1] = new Number(1);
	cImgs[0]->data[0][2] = new Number(0);
		
	cImgs[1]->data[0][0] = new Number(0);
	cImgs[1]->data[0][1] = new Number(0);
	cImgs[1]->data[0][2] = new Number(1);
		
		
			
	DM->M[1][0] =DomainMapping::buildAffineTransf_Ak_to_Ad(1,2,cImgs);	
	
	return DM;
}


Matrix* DomainMapping::buildAffineTransf_Ak_to_Ad(int k,int d,DomainPoint** canonicalImg)
{
	Matrix *M = new Matrix(k+1,d+1);
	M->allocate();
	int i,j;
	for(i=0;i<=k;i++)
		for(j=0;j<=d;j++)
			M->data[i][j] = canonicalImg[i]->data[0][j];
	
	return M;
}

DomainPoint* DomainMapping::map_A_delta_to_A_epsilon(DomainPoint* u)
{
	DomainPoint* v;
	
	//u->print(stderr);
	
	int j,i;
	DomainPoint* accum;
	DomainPoint* tmp01P;
	DomainPoint* tmp02P;
	
	accum = this->map_A_delta_to_Ad(u,0);
	
	for(j=1;j<=this->destDomain->dim;j++)
	{
		tmp01P = this->map_A_delta_to_Ad((DomainPoint*)u,j);
		tmp02P = accum;
		accum = (DomainPoint*) ((IrregularMatrix*)tmp02P)->insertRow(j,(IrregularMatrix*)tmp01P);
		delete tmp01P;
		delete tmp02P;
	}
	
	return accum;
	
}

DomainPoint* DomainMapping::map_A_delta_to_A_epsilon_usingIM(DomainPoint* u)
{
	DomainPoint* v;
	
	//u->print(stderr);
	
	int j,i;
	DomainPoint* accum;
	DomainPoint* tmp01P;
	DomainPoint* tmp02P;
	
	accum = this->map_A_delta_to_Ad_usingIM(u,0);
	
	for(j=1;j<=this->destDomain->dim;j++)
	{
		tmp01P = this->map_A_delta_to_Ad_usingIM((DomainPoint*)u,j);
		tmp02P = accum;
		accum = (DomainPoint*) ((IrregularMatrix*)tmp02P)->insertRow(j,(IrregularMatrix*)tmp01P);
		delete tmp01P;
		delete tmp02P;
	}
	
	return accum;
	
}

DomainPoint* DomainMapping::map_A_delta_to_Ad(DomainPoint* u,  int d_idx)
{
	
	
	MultiIndex* dmDim = new MultiIndex(0,this->destDomain->mIdx[d_idx]);
	DomainPoint* v;
	
	int j,i;
	DomainPoint* accum;
	DomainPoint* tmp01P;
	DomainPoint* tmp02P;
	
	Number* tmp01N = new Number(1.f/(this->origDomain->dim+1));
	Number* tmp02N = Number::getUnitary();
	
	accum = this->map_Ak_to_Ad((DomainPoint*)u->getRow(0),0,d_idx);
	//accum->print(stderr);
	for(j=1;j<=this->origDomain->dim;j++)
	{
		tmp01P = this->map_Ak_to_Ad((DomainPoint*)u->getRow(j),j,d_idx);
		tmp02P = accum;
		accum = (DomainPoint*)tmp02P->add(tmp01P);
		//accum->print(stderr);
		delete tmp01P;
		delete tmp02P;
	}
	if(!tmp01N->equals(tmp02N))
	{
		v = (DomainPoint*) accum->multiply_by_scalar(tmp01N);
		delete accum;
	}
	else
		v = accum;
	
	
	delete tmp01N;
	delete tmp02N;
	
	//v->print(stderr);
	
	return v;
	
}


DomainPoint* DomainMapping::map_A_delta_to_Ad_usingIM(DomainPoint* u,  int d_idx)
{
	
	
	MultiIndex* dmDim = new MultiIndex(0,this->destDomain->mIdx[d_idx]);
	DomainPoint* v = new DomainPoint(dmDim);
	v->allocate();
	
	int i;
	for(i=0;i<=this->destDomain->mIdx[d_idx];i++)
	{
		//this->IM[d_idx][i]->print(stderr);
		v->data[0][i] = this->IM[d_idx][i]->dotProduct(u);
		
	}
	
	//v->print(stderr);
	
	return v;
	
}



DomainPoint* DomainMapping::map_Ak_to_Ad(DomainPoint* u, int k_idx, int d_idx)
{
	
	MultiIndex* kmDim = new MultiIndex(0,this->origDomain->mIdx[k_idx]);
	MultiIndex* dmDim = new MultiIndex(0,this->destDomain->mIdx[d_idx]);
	DomainPoint* v = new DomainPoint(dmDim);
	v->allocate();
	
	int j,i;
	Number* accum;
	Number* tmp01N;
	Number* tmp02N;
	for(j=0;j<=dmDim->mIdx[0];j++)
	{
		accum = Number::getNULL();
		for(i=0;i<=kmDim->mIdx[0];i++)
		{
			tmp01N = u->data[0][i]->times(this->M[k_idx][d_idx]->get(i,j));
			tmp02N = accum;
			accum = tmp02N->add(tmp01N);
			delete tmp01N;
			delete tmp02N;
		}
		v->data[0][j] = accum;
	}
	
	
	return v;
	
}

	
void DomainMapping::allocateM()
{
	int origOrder, destOrder;
	origOrder = this->origDomain->dim+1;
	destOrder = this->destDomain->dim+1;
	
	this->M = (Matrix***)calloc(origOrder,sizeof(Matrix**));
	int i;
	for(i=0;i< origOrder;i++)
		this->M[i] = (Matrix**)calloc(destOrder,sizeof(Matrix*));
	
}

void DomainMapping::allocateIM()
{
	int destOrder;
	
	destOrder = this->destDomain->dim+1;
	
	this->IM = (IrregularMatrix***)calloc(destOrder,sizeof(IrregularMatrix**));
	int i;
	for(i=0;i< destOrder;i++)
		this->IM[i] = (IrregularMatrix**)calloc(this->destDomain->mIdx[i]+1,sizeof(IrregularMatrix*));
	
}


DomainMapping::~DomainMapping()
{
	
}

