#include "DomainPoint.h"

DomainPoint::DomainPoint(MultiIndex* d) : IrregularMatrix(d)
{
	
}

DomainPoint::~DomainPoint()
{
}

std::vector<DomainPoint*> DomainPoint::insertElement(int i,int j, Number* n, std::vector<DomainPoint*> v, std::vector<DomainPoint*> accum)
{
	std::vector<DomainPoint*>::iterator iter;
	DomainPoint* tmp01M;
	DomainPoint* tmp02M;
	Number* tmp01N;
	Number* tmp02N;
	Number* tmp03N;
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		tmp01M = (DomainPoint*)(*iter);
		//tmp01M->print(stderr);
		
		tmp01N = tmp01M->rowSum(j);
		tmp02N = n->add(tmp01N);
		delete(tmp01N);
		tmp01N = Number::getUnitary();
		tmp03N = tmp01N->sub(tmp02N);
		delete(tmp01N);
		
		
		// n + sum of row j <=1
		if(tmp03N->isNotNegative())
		{
			//fprintf(stderr,"1-(n+sum) = %g (not negative)\n",tmp03N->val);
			tmp02M = (DomainPoint*) ((IrregularMatrix*)tmp01M)->insertElement(i,j,n);
			accum.push_back(tmp02M);
		}
		else
			//fprintf(stderr,"1-(n+sum) = %g (negative)\n",tmp03N->val);
		
		delete(tmp03N);
		
	}
		
	return accum;
	
}



std::vector<DomainPoint*> DomainPoint::insertRow(int i,DomainPoint* row, std::vector<DomainPoint*> v, std::vector<DomainPoint*> accum)
{
	std::vector<DomainPoint*>::iterator iter;
	DomainPoint* tmp01M;
	DomainPoint* tmp02M;
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		tmp01M = (DomainPoint*)(*iter);
		tmp02M = (DomainPoint*) ((IrregularMatrix*)tmp01M)->insertRow(i,(IrregularMatrix*)row);
		accum.push_back(tmp02M);
	}
		
	return accum;
}


std::vector<DomainPoint*> DomainPoint::domainPoints(int dim,int n)
{
	int i,j;
	std::vector<DomainPoint*> v,acum;
	std::vector<DomainPoint*>::iterator iter;
	Number** tmp01NV;
	Number* tmp01N;
	DomainPoint* dp01;
	
	
	tmp01NV = (Number**) calloc(1,sizeof(Number*));
	for(j=0;j <= n ;j++)
	{
		tmp01NV[0] = new Number(((double)j)/n);
		dp01 = (DomainPoint*)IrregularMatrix::fromNumber1DVector(1,tmp01NV);
		//dp01->print(stderr);
		v.push_back(dp01);
		
	}
	
	//for(iter=v.begin();iter!= v.end();iter++)
	//	(*iter)->print();
	
	for(i=dim-1;  i>0 ;i--)
	{
		for(j=0; j <= n ;j++)
		{
			tmp01N = new Number(((double)j)/n);
			acum = DomainPoint::insertElement(0,0,tmp01N,v,acum);
			delete tmp01N;
		}
		v = acum;
		acum.clear();
		
	}
	
	for(iter=v.begin();iter!= v.end();iter++)
		acum.push_back((*iter)->extendPoint2Simplex(0));
	
	return acum;
}




std::vector<DomainPoint*> DomainPoint::domainPoints(MultiIndex* mDim, int n)
{
	int i;
	std::vector<DomainPoint*> v,acum;
	std::vector<DomainPoint*>::iterator iter;	
	
	std::vector<DomainPoint*> v2;
	std::vector<DomainPoint*>::iterator iter2;
	
	
	v = ( DomainPoint::domainPoints(mDim->mIdx[0],n)  );
	
	
	//for(iter=v.begin();iter!= v.end();iter++)
	//	(*iter)->print(stderr);
	
	for(i=1;  i<= mDim->dim ;i++)
	{
		v2.clear();
		
		v2 = DomainPoint::domainPoints(mDim->mIdx[i],n);
		
		for(iter2=v2.begin();iter2!=v2.end();iter2++)
		{
			acum = DomainPoint::insertRow(0,(*iter2),v,acum);
		}
		v = acum;
		acum.clear();
		
	}
	
	//for(iter=v.begin();iter!= v.end();iter++)
	//	acum.push_back((*iter)->extendPoint2Simplex());
	
	return v;
}







DomainPoint* DomainPoint::extendPoint2Simplex(int i)
{
	DomainPoint* newp;
	Number* n;
	Number* tmp01N;
	Number* tmp02N;
	tmp01N = this->rowSum(i);
	tmp02N = Number::getUnitary();
	n = tmp02N->sub(tmp01N);
	delete(tmp01N);
	delete(tmp02N);
	
	int j = this->mDim->mIdx[i];
	newp = (DomainPoint*) ((IrregularMatrix*)this)->insertElement(i,j+1,n);
	
	return newp;
	
}

