#include "dataStruct/MultiIndex.h"
#include "domain_and_range/DomainPoint.h"
#include "domain_and_range/DomainMapping.h"
#include "dataType/IrregularMatrix.h"
#include "dataType/Number.h"
#include <stdio.h>
#include <stdlib.h>
#include <vector>

int main()
{
	
	MultiIndex* mdim = new MultiIndex(1,1);
	std::vector<DomainPoint*> v;
	std::vector<DomainPoint*>::iterator iter;
	
	v = DomainPoint::domainPoints(mdim,50);
	DomainPoint* pp;

	FILE* fp1 = fopen("/home/lbfreitas/t01","w");
	FILE* fp2 = fopen("/home/lbfreitas/t02_","w");
	DomainMapping *DM = DomainMapping::example03();
	DM->allocateIM();
	DM->buildIM_matrices();
	
	
	
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		//((IrregularMatrix*)(*iter))->printPlot(fp1);
		pp = DM->map_A_delta_to_A_epsilon_usingIM(*iter);
		((IrregularMatrix*)(pp))->printPlot(fp2);
		
	}
	
	mdim = new MultiIndex(0,2);
	v = DomainPoint::domainPoints(mdim,50);
	
	for(iter=v.begin();iter!=v.end();iter++)
	{
		((IrregularMatrix*)(*iter))->printPlot(fp1);

			
	}
	
	fclose(fp1);
	fclose(fp2);
		
	fprintf(stderr,"\ndone!\n");
}
