#include "BezierCube.h"




float* BezierCube::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
	
	Index::MultiIdx *midx;
	
	
	midx = (Index::MultiIdx*)idx;
	
	
	res = this->rec[idx->get(0)]->BezierRectangle::getControlPoint(midx->supressFirst());
	
	return res;
}


void BezierCube::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	Index::MultiIdx *midx, *newidx;
		
	midx = (Index::MultiIdx*)idx;

	newidx = (Index::MultiIdx*)midx->MultiIdx::supressFirst();
	//fprintf(stderr,"\n");
//	midx->print(stderr);
//	newidx->print(stderr);
		
	
	this->rec[idx->get(0)]->BezierRectangle::setControlPoint(newidx,x,y,z);
	
	return;
}




void BezierCube::fromBezierTetrahedron(Index::IndexedMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}



int BezierCube::getOrder()
{
	return 3;
}
	
int* BezierCube::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(3,sizeof(int));
	
	dim[0] = 1;
	dim[1] = 1;
	dim[2] = 1;
	
	return dim;
}
	
int* BezierCube::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(2,sizeof(int));
	
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	deg[2] = this->deg_w;
	
	return deg;
}







int BezierCube::getN()
{
	return this->n;
}

void BezierCube::stepZ(float step)
{
	int i;
		
		for(i=0;i<this->deg_u+1;i++)
		{

			this->rec[i]->BezierRectangle::stepZ(step);
		}
}


void BezierCube::init(float spacing)
{
	int i;
	
	for(i=0;i<this->deg_u+1;i++)
	{
		this->rec[i]->BezierRectangle::init(spacing);
		this->rec[i]->BezierRectangle::stepZ(-1*spacing*i);
	}
}


void BezierCube::name()
{
	fprintf(stderr,"cube\n");
}

BezierCube::BezierCube(int deg_u, int deg_v,int deg_w, int build)
{
	int i;
	
	this->deg_u = deg_u;
	this->n_u = deg_u+1;
	this->rec = (BezierRectangle**) calloc(this->n_u,sizeof(BezierRectangle*));
		
	this->deg_v = deg_v;
	this->n_v = deg_v +1;
	
	this->deg_w = deg_w;
	this->n_w = deg_w +1;
	
	
	if(build==1)
		for(i=0;i<this->n_u;i++)
			this->rec[i] = new BezierRectangle(this->deg_v, this->deg_w,1);
		
	
		
	this->n = this->n_u * this->n_v * this->n_w;
	
}


void BezierCube::updControlPoints(int i, float x, float y, float z)
{
	int quo, rest;
	int n = this->n_v * this->n_w;
	quo = i/n;
	rest = i % n;
	
	this->rec[quo]->updControlPoints(rest,x,y,z);
		
	
}




BezierCube* BezierCube::blossom_1D(int dir, float v1,float v2)
{
	BezierCube *cube;
	BezierRectangle *rec1, *rec2;
	//BezierCurve *c1,*c2;
	
	int i;
	if(dir==0)
	{
		cube = new BezierCube(this->deg_u-1,this->deg_v,this->deg_w,0);
		
		for(i=0; i< this->deg_u;i++)
		{
			rec1 = this->rec[i]->BezierRectangle::times(v1);
			rec2 = this->rec[i+1]->BezierRectangle::times(v2);
						
			cube->rec[i] =rec1->BezierRectangle::add(rec2);
		}
		
	}
	
	if(dir>0)
	{
		if(dir==1)
			cube = new BezierCube(this->deg_u,this->deg_v-1,this->deg_w,0);
		
		if(dir==2)
			cube = new BezierCube(this->deg_u,this->deg_v,this->deg_w-1,0);
				
		
		for(i=0; i<= this->deg_u;i++)
			cube->rec[i] = this->rec[i]->BezierRectangle::blossom_1D(dir-1,v1,v2);
		
	}
	
	

	return cube;
}


double BezierCube::eval(double u, double v,double w,int coord)
{
	BezierCube *cube;
	
	cube = this;
	int i;
	
	for(i=0;i<this->deg_u;i++)
		cube = cube->BezierCube::blossom_1D(0,u,1-u);
	
	for(i=0;i<this->deg_v;i++)
		cube = cube->BezierCube::blossom_1D(1,v,1-v);
	
	for(i=0;i<this->deg_w;i++)
		cube = cube->BezierCube::blossom_1D(2,w,1-w);
		
		
	if(coord==0)
		return cube->rec[0]->c[0]->X[0];
	
	
	if(coord==1)
		return cube->rec[0]->c[0]->Y[0];
	
	
	 return cube->rec[0]->c[0]->Z[0];
	
		
}


void BezierCube::evalGrid(int steps)
{
	int v1=0;
    int u1=0;
    int w1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float***)calloc(steps+1,sizeof(float**)) ;
    gY = (float***)calloc(steps+1,sizeof(float**)) ;
    gZ = (float***)calloc(steps+1,sizeof(float**)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float**)calloc(steps+1,sizeof(float*));
        gY[u1] = (float**)calloc(steps+1,sizeof(float*));
        gZ[u1] = (float**)calloc(steps+1,sizeof(float*));


        for (v1=0; v1 <= steps; v1++)
        {
            gX[u1][v1] = (float*)calloc(steps+1,sizeof(float));
            gY[u1][v1] = (float*)calloc(steps+1,sizeof(float));
            gZ[u1][v1] = (float*)calloc(steps+1,sizeof(float));

            for (w1=0; w1 <= steps; w1++)
            {
                gX[u1][v1][w1] = this->eval(u1*step1, v1*step1,w1*step1, 0);

                gY[u1][v1][w1] = this->eval(u1*step1, v1*step1,w1*step1, 1);

                gZ[u1][v1][w1] = this->eval(u1*step1, v1*step1,w1*step1, 2);
            }
            
        }
    }


    return;
}


std::vector<float*> BezierCube::wireFrameEdges(int steps)
{
	return BezierCube::wireFrame(steps);
	
}


std::vector<float*> BezierCube::wireFrame(int steps)
{
	std::vector<float*> l;
	
    float *linePiece;


    int ui,vi,wi;

    this->BezierCube::evalGrid(steps);


    // wireframe

    for (ui=0; ui< steps; ui++)
      {
        for (vi=0; vi< steps; vi++)
          {
        	for (wi=0; wi< steps; wi++)
            {
            	linePiece = new float[6];
            	
                linePiece[0] = gX[ui][vi][wi];
                linePiece[1] = gY[ui][vi][wi];
                linePiece[2] = gZ[ui][vi][wi];
                linePiece[3] = gX[ui+1][vi][wi];
                linePiece[4] = gY[ui+1][vi][wi];
                linePiece[5] = gZ[ui+1][vi][wi];

                l.push_back(linePiece);
                
                
                linePiece = new float[6];
                            	
                linePiece[0] = gX[ui][vi][wi];
                linePiece[1] = gY[ui][vi][wi];
                linePiece[2] = gZ[ui][vi][wi];
                linePiece[3] = gX[ui][vi+1][wi];
                linePiece[4] = gY[ui][vi+1][wi];
                linePiece[5] = gZ[ui][vi+1][wi];

                l.push_back(linePiece);

                linePiece = new float[6];
                            	
                linePiece[0] = gX[ui][vi][wi];
                linePiece[1] = gY[ui][vi][wi];
                linePiece[2] = gZ[ui][vi][wi];
                linePiece[3] = gX[ui][vi][wi+1];
                linePiece[4] = gY[ui][vi][wi+1];
                linePiece[5] = gZ[ui][vi][wi+1];

                l.push_back(linePiece);            
            
            
            
            }


          }
      }



    return l;

	
}


std::vector<float*> BezierCube::getControlPoints()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
	
    int i;
    for(i=0;i<this->n_u;i++)
    {
    	laux = this->rec[i]->BezierRectangle::getControlPoints();
    	for(iter=laux.begin();iter!=laux.end();iter++)
    		l.push_back(*iter);
	}

    return l;


}



std::vector<float*> BezierCube::controlNet()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
		
	float *linePiece;
	
	
    int i,j,k;
    for(i=0;i< this->n_u -1;i++)
    {
    	
    	laux = this->rec[i]->BezierRectangle::controlNet();
    	   	
    	
    	for(j=0;j < this->n_v ; j++)
    		for(k=0;k < this->n_v ; k++)
			{
				linePiece = new float[6];
				linePiece[0] = this->rec[i]->c[j]->X[k];
				linePiece[1] = this->rec[i]->c[j]->Y[k];
				linePiece[2] = this->rec[i]->c[j]->Z[k];
				
				linePiece[3] = this->rec[i+1]->c[j]->X[k];
				linePiece[4] = this->rec[i+1]->c[j]->Y[k];
				linePiece[5] = this->rec[i+1]->c[j]->Z[k];
			
				laux.push_back(linePiece);
			}
	
	
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
}
    
    
    laux = this->rec[this->deg_u]->BezierRectangle::controlNet();
    for(iter=laux.begin();iter!=laux.end();iter++)
        		l.push_back(*iter);
    

	    return l;
}

/*
 * void BezierCube::init(float spacing)
{
	int i,j,k;
	
	for(i=0;i<this->n_u;i++)
		for(j=0;j<this->n_v;j++)
			for(k=0;k<this->n_w;k++)
			{
				this->rec[i]->c[j]->X[k] = spacing*i;
				this->rec[i]->c[j]->Y[k] = spacing*j;
				this->rec[i]->c[j]->Z[k] = spacing*k;
			}
}
*/


BezierCube::~BezierCube()
{
}
