#ifndef BEZIERCUBE_H_
#define BEZIERCUBE_H_

#include "Bezier_Element.h"
#include "BezierRectangle.h"

#include "BezierTetrahedron.h"
#include "BezierCurve.h"
#include <vector.h>
#include <stdio.h>

class BezierCube : public Bezier_Element
{
public:

	BezierRectangle** rec;
		int deg_u, deg_v, deg_w;
		int n_u,n_v,n_w;
		int n;
		
		float ***gX, ***gY, ***gZ;
		
		
		
		
		
		 int  getOrder();
		
		 int*  getDimensions();
		
		 int*  getDegrees();
		
		
		 void  fromBezierTetrahedron(Index::IndexedMatrix *m, Bezier_Element *bt);
		
		
		 void  setControlPoint(Index::BezierIndex *idx, float x, float y, float z);
		 float*  getControlPoint(Index::BezierIndex *idx);
		 
		
		 int  getN();
		
		void  stepZ(float step);
		
		void  name();
		
		void  updControlPoints(int i, float x, float y, float z);
		
		BezierCube*  blossom_1D(int dir, float v1,float v2);
		//BezierCube*  blossom(float u, float v);
		double  eval(double u, double v,double w,int coord);
		void  evalGrid(int steps);
		
		
		std::vector<float*>  wireFrame(int steps);
		std::vector<float*>  wireFrameEdges(int steps);		
		std::vector<float*>  getControlPoints();
		
		float*  getLinePiece(int orig, int dest);	
			
		std::vector<float*>  controlNet();
				
		
		void  init(float spacing);
	
	
	
	
	
	BezierCube(int deg_u, int deg_v, int deg_w, int build);
	virtual ~BezierCube();
};

#endif /*BEZIERCUBE_H_*/
