#include "BezierCube2.h"
#include "BezierPoint.h"



float* BezierCube2::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
		
		BezierPoint* bp;
		
		bp = (BezierPoint*) this->bspd->BezierSimploid::getControl_Point(idx);
		
		res = (float*) calloc(3,sizeof(float));
		
		
		res[0] = bp->data[0];
		res[1] = bp->data[1];
		res[2] = bp->data[2];
		
		return res;
}


void BezierCube2::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	double *data = (double*) calloc(3,sizeof(double));
		
		data[0] = x;
		data[1] = y;
		data[2] = z;
		
		((BezierPoint*) (this->bspd->BezierSimploid::getControl_Point(idx) ) )->BezierPoint::setData(data);
		
		return;
}




void BezierCube2::fromBezierTetrahedron(Index::IndexedMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}



int BezierCube2::getOrder()
{
	return 3;
}
	
int* BezierCube2::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(3,sizeof(int));
	
	dim[0] = 1;
	dim[1] = 1;
	dim[2] = 1;
	
	return dim;
}
	
int* BezierCube2::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(2,sizeof(int));
	
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	deg[2] = this->deg_w;
	
	return deg;
}







int BezierCube2::getN()
{
	return this->n;
}

void BezierCube2::stepZ(float step)
{
	double *d = (double*) calloc(3,sizeof(double));
	d[0] = 0;
	d[1] = 0;
	d[2] = step;
	this->bspd->BezierSimploid::translate(d);
}


void BezierCube2::init(float spacing)
{
	int *ddim = new int[3];
	int *deg = new int[3];
	ddim[0]=1;
	ddim[1]=1;
	ddim[2]=1;
		
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	deg[2] = this->deg_w;
		
	this->bspd = new BezierSimploid(3,ddim,3,deg);
	this->bspd->BezierSimploid::init(spacing);
}


void BezierCube2::name()
{
	fprintf(stderr,"cube\n");
}

BezierCube2::BezierCube2(int deg_u, int deg_v,int deg_w, int build)
{
	
	this->deg_u = deg_u;
	this->n_u = deg_u+1;
	this->rec = (BezierRectangle**) calloc(this->n_u,sizeof(BezierRectangle*));
		
	this->deg_v = deg_v;
	this->n_v = deg_v +1;
	
	this->deg_w = deg_w;
	this->n_w = deg_w +1;
	
		
	this->n = this->n_u * this->n_v * this->n_w;
	
	
	this->ind_vec = (Index::HyperIdx**) calloc(this->n,sizeof(Index::HyperIdx*));
	
	
	
	
	
}


void BezierCube2::updControlPoints(int j, float x, float y, float z)
{
    this->BezierCube2::setControlPoint((Index::BezierIndex*)this->ind_vec[j],x,y,z);

    return;	
}




BezierCube2* BezierCube2::blossom_1D(int dir, float v1,float v2,float v3)
{
	
	BezierCube2* br2 = new BezierCube2(this->deg_u-1,this->deg_v-1,this->deg_w,1);
	
	double** point;
	point= (double**) calloc(3,sizeof(double*));
	point[0] = (double*) calloc(2,sizeof(double));
	point[1] = (double*) calloc(2,sizeof(double));
	point[2] = (double*) calloc(2,sizeof(double));
	
	point[0][0] = v1;
	point[0][1] = 1.f -v1;
	point[1][0] = v2;
	point[1][1] = 1.f -v2;	
	point[2][0] = v3;
	point[2][1] = 1.f -v3;	
		
	br2->bspd = this->bspd->BezierSimploid::blossom(point);
	
	return br2;
}


double BezierCube2::eval(double u, double v,double w,int coord)
{
	BezierPoint* bp;
	double** point;
	point= (double**) calloc(3,sizeof(double*));
	point[0] = (double*) calloc(2,sizeof(double));
	point[1] = (double*) calloc(2,sizeof(double));
	point[2] = (double*) calloc(2,sizeof(double));
		
	point[0][0] = u;
	point[0][1] = 1.f -u;
	point[1][0] = v;
	point[1][1] = 1.f -v;	
	point[2][0] = w;
	point[2][1] = 1.f -w;	
			
	bp = (BezierPoint*) this->bspd->BezierSimploid::eval(point);
		
	return bp->data[coord];
		
}


void BezierCube2::evalGrid(int steps)
{
	int v1=0;
    int u1=0;
    int w1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float***)calloc(steps+1,sizeof(float**)) ;
    gY = (float***)calloc(steps+1,sizeof(float**)) ;
    gZ = (float***)calloc(steps+1,sizeof(float**)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float**)calloc(steps+1,sizeof(float*));
        gY[u1] = (float**)calloc(steps+1,sizeof(float*));
        gZ[u1] = (float**)calloc(steps+1,sizeof(float*));


        for (v1=0; v1 <= steps; v1++)
        {
            gX[u1][v1] = (float*)calloc(steps+1,sizeof(float));
            gY[u1][v1] = (float*)calloc(steps+1,sizeof(float));
            gZ[u1][v1] = (float*)calloc(steps+1,sizeof(float));

            for (w1=0; w1 <= steps; w1++)
            {
                gX[u1][v1][w1] = this->eval(u1*step1, v1*step1,w1*step1, 0);

                gY[u1][v1][w1] = this->eval(u1*step1, v1*step1,w1*step1, 1);

                gZ[u1][v1][w1] = this->eval(u1*step1, v1*step1,w1*step1, 2);
            }
            
        }
    }


    return;
}

std::vector<float*> BezierCube2::wireFrameEdges(int steps)
{
	return BezierCube2::wireFrame(steps);
	
}

std::vector<float*> BezierCube2::wireFrame(int steps)
{
	std::vector<float*> l;
	
    float *linePiece;


    int ui,vi,wi;

    this->BezierCube2::evalGrid(steps);


    // wireframe

    for (ui=0; ui< steps; ui++)
      {
        for (vi=0; vi< steps; vi++)
          {
        	for (wi=0; wi< steps; wi++)
            {
            	linePiece = new float[6];
            	
                linePiece[0] = gX[ui][vi][wi];
                linePiece[1] = gY[ui][vi][wi];
                linePiece[2] = gZ[ui][vi][wi];
                linePiece[3] = gX[ui+1][vi][wi];
                linePiece[4] = gY[ui+1][vi][wi];
                linePiece[5] = gZ[ui+1][vi][wi];

                l.push_back(linePiece);
                
                
                linePiece = new float[6];
                            	
                linePiece[0] = gX[ui][vi][wi];
                linePiece[1] = gY[ui][vi][wi];
                linePiece[2] = gZ[ui][vi][wi];
                linePiece[3] = gX[ui][vi+1][wi];
                linePiece[4] = gY[ui][vi+1][wi];
                linePiece[5] = gZ[ui][vi+1][wi];

                l.push_back(linePiece);

                linePiece = new float[6];
                            	
                linePiece[0] = gX[ui][vi][wi];
                linePiece[1] = gY[ui][vi][wi];
                linePiece[2] = gZ[ui][vi][wi];
                linePiece[3] = gX[ui][vi][wi+1];
                linePiece[4] = gY[ui][vi][wi+1];
                linePiece[5] = gZ[ui][vi][wi+1];

                l.push_back(linePiece);            
            
            
            
            }


          }
      }



    return l;

	
}


std::vector<float*> BezierCube2::getControlPoints()
{
	std::vector<float*> l;
	//std::vector<float*>::iterator iter;
	
	std::vector<Index::HyperIdx*>::iterator iter;
	std::vector<Index::HyperIdx*> v;
	
	Index::BezierIndex* p;
	
	Index::MultiIdx *degs,*dims;
	degs = new Index::MultiIdx(3);
	dims = new Index::MultiIdx(3);
	int i;
	for(i=0;i<3;i++)
	{
		degs->idx[i] = this->bspd->deg_v[i];
		dims->idx[i] = this->bspd->ddim_v[i];
	}
		
	
	v = Index::HyperIdx::getAllIndexes(degs,dims);
	
	
    i=0;

    {

    	for(iter=v.begin();iter!=v.end();iter++)
    	{
    		p = (Index::BezierIndex*) (*iter);
    		//((Index::HyperIdx*)p)->print(stderr);
    		l.push_back(this->BezierCube2::getControlPoint(p));
    		this->ind_vec[i] = (Index::HyperIdx*)p;
    		//this->ind_vec[i]->line[0]->print(stderr);
    		i++;
    		
    	}
	}

    return l;

}



std::vector<float*> BezierCube2::controlNet()
{
	std::vector<BezierSimploid**> l;
	std::vector<float*> res;
	std::vector<BezierSimploid**>::iterator iter;
			
	float *linePiece;
		
		
		l = this->bspd->BezierSimploid::controlNet();
		for(iter=l.begin();iter!=l.end();iter++)
		{
			linePiece = (float*) calloc(6,sizeof(float));
			linePiece[0] = ((BezierPoint**)(*iter))[0]->data[0];
			linePiece[1] = ((BezierPoint**)(*iter))[0]->data[1];
			linePiece[2] = ((BezierPoint**)(*iter))[0]->data[2];
			linePiece[3] = ((BezierPoint**)(*iter))[1]->data[0];
			linePiece[4] = ((BezierPoint**)(*iter))[1]->data[1];
			linePiece[5] = ((BezierPoint**)(*iter))[1]->data[2];
			
			res.push_back(linePiece);
		}
		
	   
		    return res;
}



BezierCube2::~BezierCube2()
{
}
