#include "BezierCurve.h"

BezierCurve::BezierCurve(int deg)
{
	this->n = deg+1;
	this->deg = deg;
	
	this->X = (float*) calloc(this->n,sizeof(float));
	this->Y = (float*) calloc(this->n,sizeof(float));
	this->Z = (float*) calloc(this->n,sizeof(float));
	
}

void BezierCurve::init(float spacing)
{
	int i;
	for(i=0;i<this->n;i++)
	{
		this->X[i] = spacing*i; this->Y[i] = 0; this->Z[i] = 0;
	}

	
}

void BezierCurve::step(int dir,float value)
{
	int i;
	
	for(i=0;i<this->n;i++)
	{
		if(dir==0)
			this->X[i]= this->X[i] + value;
		
		if(dir==2)
			this->Y[i]= this->Y[i] + value;
		
		if(dir==3)
			this->Z[i]= this->Z[i] + value;
	}
}





void BezierCurve::stepZ(int step)
{
	int i;
	for(i=0;i<this->n;i++)
		this->Z[i] = this->Z[i] + step;
}



void BezierCurve::updControlPoints(int i, float x, float y, float z)
{
	this->X[i] = x;
	this->Y[i] = y;
	this->Z[i] = z;
		
}


BezierCurve* BezierCurve::times(float u)
{
	BezierCurve* bc = new BezierCurve(this->deg);
	int i;
	
	for(i=0;i<bc->n;i++)
	{
		bc->X[i] = this->X[i]*u;
		bc->Y[i] = this->Y[i]*u;
		bc->Z[i] = this->Z[i]*u;
	}
	
	return bc;
}


BezierCurve* BezierCurve::add(BezierCurve* op)
{
	BezierCurve* bc = new BezierCurve(this->deg);
	int i;
	
	for(i=0;i<bc->n;i++)
	{
		bc->X[i] = this->X[i] + op->X[i];
		bc->Y[i] = this->Y[i] + op->Y[i];
		bc->Z[i] = this->Z[i] + op->Z[i];
	}
	
	return bc;
}

BezierCurve* BezierCurve::blossom(float u, float v)
{
	BezierCurve* bc = new BezierCurve(this->deg-1);
	int i;
	
	for(i=0;i<this->deg;i++)
	{
		bc->X[i] = this->X[i]*u + this->X[i+1]*v;
		bc->Y[i] = this->Y[i]*u + this->Y[i+1]*v;
		bc->Z[i] = this->Z[i]*u + this->Z[i+1]*v;
	}
	
	return bc;
}


double BezierCurve::eval(double u, double v, int coord)
{
	BezierCurve* bc;
	
	bc = this;
	int i;
	
	for(i=0;i<this->deg;i++)
		bc = bc->BezierCurve::blossom(u,v);
	
	if(coord==0)
		return bc->X[0];
	
	if(coord==1)
		return bc->Y[0];
	
	return bc->Z[0];
		
}

float* BezierCurve::getLinePiece(int orig, int dest)
{
	float *linePiece;


	linePiece = new float[6];
	
    linePiece[0] = X[orig];
    linePiece[1] = Y[orig];
    linePiece[2] = Z[orig];
    linePiece[3] = X[dest];
    linePiece[4] = Y[dest];
    linePiece[5] = Z[dest];
    
    return linePiece;
}


std::vector<float*> BezierCurve::wireFrameEdges(int steps)
{
	return BezierCurve::wireFrame(steps);
}

std::vector<float*> BezierCurve::wireFrame(int steps)
{
	std::vector<float*> l;
	
    float *linePiece;


    int ui;

    this->BezierCurve::evalGrid(steps);


    // wireframe

    for (ui=0; ui< steps; ui++)
    {
		linePiece = new float[6];
    	
        linePiece[0] = gX[ui];
        linePiece[1] = gY[ui];
        linePiece[2] = gZ[ui];
        linePiece[3] = gX[ui+1];
        linePiece[4] = gY[ui+1];
        linePiece[5] = gZ[ui+1];

        l.push_back(linePiece);
    }



    return l;

	
}




std::vector<float*> BezierCurve::controlNet()
{
	std::vector<float*> l;
	


	int i;
                	
	
	for(i=0;i<this->n-1;i++)
	    l.push_back(this->BezierCurve::getLinePiece(i,i+1));
		
	
    
    return l;
	
}


void BezierCurve::evalGrid(int steps)
{
    int u1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float*)calloc(steps+1,sizeof(float)) ;
    gY = (float*)calloc(steps+1,sizeof(float)) ;
    gZ = (float*)calloc(steps+1,sizeof(float)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = this->eval(u1*step1, 1- u1*step1, 0);

        gY[u1] = this->eval(u1*step1, 1- u1*step1, 1);

        gZ[u1] = this->eval(u1*step1, 1- u1*step1, 2);
    }
            


    return;
}


std::vector<float*> BezierCurve::getControlPoints()
{
	std::vector<float*> l;
	
    float *pt;


    int i;
    for(i=0;i<this->n;i++)
    {
    	pt= new float[3];
    	pt[0] = X[i];
    	pt[1] = Y[i];
    	pt[2] = Z[i];
    	
    	l.push_back(pt);
    }

    return l;

	
}


BezierCurve::~BezierCurve()
{
}
