#ifndef BEZIERCURVE_H_
#define BEZIERCURVE_H_

#include "Bezier_Element.h"
#include <stdlib.h>
#include <vector>

class BezierCurve : public Bezier_Element
{
public:
	
	int deg;
	int n;
	
	float *X,*Y,*Z;
	
	float *gX;
	float *gY;
	float *gZ; 
	
	BezierCurve*  blossom(float u, float v);
	BezierCurve*  times(float u);
	BezierCurve*  add(BezierCurve* op);
	void  updControlPoints(int i, float x, float y, float z);
	void  init(float spacing);
	
	
	double  eval(double u, double v, int coord);
	std::vector<float*>  wireFrame(int steps);
	std::vector<float*>  wireFrameEdges(int steps);
		
	std::vector<float*>  getControlPoints();
	std::vector<float*>  controlNet();
	
	void  stepZ(int step);
	
	BezierCurve(int deg);
	virtual ~BezierCurve();
	
	void  step(int dir,float value);
	
	
protected:
	float*  getLinePiece(int orig, int dest);
	void  evalGrid(int steps);
	
	

};

#endif /*BEZIERCURVE_H_*/
