#include "BezierPoint.h"


//static variables
	 BezierPoint** BezierPoint::allBPoints;
	 int* BezierPoint::validBPoints; // -1=never_used; 0=discarded; 1=in_use
	 int BezierPoint::nextId;
	 int BezierPoint::maxBPoints;
	 int BezierPoint::allocatedBPs;


 BezierPoint* BezierPoint::clone()
 {
	BezierPoint* res = new BezierPoint(this->rdim);
	memcpy(res->data,this->data,this->rdim*sizeof(double));
	 return res;
	
 }

void BezierPoint::initClass(int size)
{
	int i;
	BezierPoint::nextId = 0;
	BezierPoint::allBPoints = (BezierPoint**) malloc(size*sizeof(BezierPoint*));
	BezierPoint::validBPoints = (int*) malloc(size*sizeof(int));
	BezierPoint::maxBPoints = size;
	BezierPoint::allocatedBPs=0;
	
	for(i=0;i<size;i++)
		BezierPoint::validBPoints[i] = -1;
		
}

void BezierPoint::allocateBezierPoint(BezierPoint* bp)
{
	//if out of space, duplicate it ...
	
	int i,id;
	int freed;
	
	id = BezierPoint::nextId;
	
	BezierPoint::nextId++;
	
	if(BezierPoint::nextId==BezierPoint::maxBPoints)
	{
		//realloc necessary
		fprintf(stderr,"Last Id = %d\n",BezierPoint::nextId);
		freed=BezierPoint::BezierPoint::cleanBPvector();
		fprintf(stderr,"Last Id (after cleaning)= %d\n",BezierPoint::nextId);
		fprintf(stderr,"%d discarded BezierPoints were deallocated\n",freed);
		fprintf(stderr,"%d BezierPoints still allocated\n",BezierPoint::allocatedBPs);
				
		
		BezierPoint::allBPoints = (BezierPoint**) realloc(BezierPoint::allBPoints,2*BezierPoint::maxBPoints*sizeof(BezierPoint*));
		BezierPoint::validBPoints = (int*) realloc(BezierPoint::validBPoints,2*BezierPoint::maxBPoints*sizeof(int));
		BezierPoint::maxBPoints = BezierPoint::maxBPoints*2;
		
		if((!BezierPoint::allBPoints)||(!BezierPoint::validBPoints))
		{
			fprintf(stderr,"error allocating memory for vector of BPoints\n");
			bp->id = -1;
			return;
		}
		
		for(i=BezierPoint::nextId;i<BezierPoint::maxBPoints;i++)
			BezierPoint::validBPoints[i] = -1;
	}
		
	
	BezierPoint::allBPoints[id] = bp;
	BezierPoint::validBPoints[id] = 1;
	
	bp->id = id;
	BezierPoint::allocatedBPs++;
		
}


int BezierPoint::cleanBPvector()
{
	int i,ii;
	int oldNextId = BezierPoint::nextId;
	
	
	BezierPoint** auxBPoints = (BezierPoint**) malloc(BezierPoint::maxBPoints*sizeof(BezierPoint*));
	int* auxvalidBPs = (int*) malloc(BezierPoint::maxBPoints*sizeof(int));
	
	for(i=0,ii=0;i<BezierPoint::maxBPoints;i++)
	{
		if(BezierPoint::validBPoints[i]==1)
		{
			auxBPoints[ii]=BezierPoint::allBPoints[i];
			BezierPoint::allBPoints[i]->id = ii;
			auxvalidBPs[ii] = BezierPoint::validBPoints[i];
			ii++;
		}
	}
	
	
	BezierPoint::nextId = ii;
	
	
	free(BezierPoint::allBPoints);
	free(BezierPoint::validBPoints);
	
	for(;ii<BezierPoint::maxBPoints;ii++)
		auxvalidBPs[ii] =-1;
	
	BezierPoint::allBPoints = auxBPoints;
	BezierPoint::validBPoints = auxvalidBPs;
			
	return (oldNextId - BezierPoint::nextId);
	
}

BezierPoint::BezierPoint(int rdim)
{
	this->rdim = rdim;
	this->data = (double*) calloc(rdim,sizeof(double));
	this->ddim = 0;
	this->deg = 0;
	this->subsimplices = 0x0;
	this->ddim_v = (int*) calloc(1,sizeof(int));
	this->deg_v = (int*) calloc(1,sizeof(int));
		
	this->subsimploids = 0x0;
	this->ddim_v[0] = 0;
	this->deg_v[0] = 0;
	
	BezierPoint::BezierPoint::allocateBezierPoint(this);
	//fprintf(stderr,"%d BezierPoints still allocated\n",BezierPoint::allocatedBPs);
		
	if(this->id==-1)
	{
		fprintf(stderr,"error creating BPoint\n");
	}
	
}

BezierPoint::~BezierPoint()
{
	//this->rdim = rdim;
	free(this->data);
	//this->ddim = 0;
	//this->deg = 0;
	//this->subsimplices = 0x0;
	free(this->ddim_v);
	free(this->deg_v);
		
	//this->subsimploids = 0x0;
	//this->ddim_v[0] = 0;
	//this->deg_v[0] = 0;
	
	BezierPoint::validBPoints[this->id] = 0;// discarded
	
	BezierPoint::allocatedBPs--;
	//fprintf(stderr,"%d BezierPoints still allocated\n",BezierPoint::allocatedBPs);
	
	
}

BezierPoint* BezierPoint::add(BezierPoint* op)
{
	int i;
	
	if(op->rdim != this->rdim)
	{
		fprintf(stderr,"BezierPoint::add --> dimension mismatch\n");
		return 0x0;
	}
	
	BezierPoint* newpt= new BezierPoint(this->rdim);
	
	for(i=0;i<this->rdim;i++)
		newpt->data[i] = this->data[i]+op->data[i];
	
	return newpt;
}


BezierPoint* BezierPoint::times(double t)
{
	int i;
	BezierPoint* newpt= new BezierPoint(this->rdim);
		
	for(i=0;i<this->rdim;i++)
		newpt->data[i] = this->data[i]* t;
	
	return newpt;
	
}


void BezierPoint::setData(double *data)
{
	int i;
	for(i=0;i<this->rdim;i++)
		this->data[i] = data[i];
}

double* BezierPoint::getData()
{
	double* r = (double*)calloc(this->rdim,sizeof(double));
	int i;
	
	for(i=0;i<this->rdim;i++)
		r[i] = this->data[i];
	
	return r;
}

void BezierPoint::translate(double *d)
{

	int j;
		
		for(j=0;j<this->rdim;j++)
			this->data[j]+=d[j];
	
	
	return;
	
}
