#ifndef BEZIERPOINT_H_
#define BEZIERPOINT_H_

#include "BezierSimplex.h"
#include <stdlib.h>
#include <stdio.h>

class BezierPoint : public BezierSimplex 
{
public:
	double *data;
	int id;
	
	
public:
	
	static BezierPoint** allBPoints;
	static int* validBPoints; // -1=never_used; 0=discarded; 1=in_use
	static int nextId;
	static int maxBPoints;
	static int allocatedBPs;
	
	
	

	static void  initClass(int size);
	static void  allocateBezierPoint(BezierPoint* bp);
	static int  cleanBPvector();
	
	BezierPoint*  clone();
	
	BezierPoint*  add(BezierPoint* op);
	BezierPoint*  times(double t);
	void  setData(double *data);
	double*  getData();
		
	void translate(double *d);
		
	
	BezierPoint(int rdim);
	virtual ~BezierPoint();
};

#endif /*BEZIERPOINT_H_*/
