#include "BezierPrism.h"
#include "BezierPoint.h"

BezierPrism::~BezierPrism()
{
}

int BezierPrism::getOrder()
{
	return 2;
}
	
int* BezierPrism::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(2,sizeof(int));
	
	dim[0] = 1;
	dim[1] = 2;
	
	
	return dim;
}
	
int* BezierPrism::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(2,sizeof(int));
	
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	
	
	return deg;
}







float* BezierPrism::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
		
		BezierPoint* bp;
		
		bp = (BezierPoint*) this->bspd->BezierSimploid::getControl_Point(idx);
		
		res = (float*) calloc(3,sizeof(float));
		
		
		res[0] = bp->data[0];
		res[1] = bp->data[1];
		res[2] = bp->data[2];
		
		return res;
}


void BezierPrism::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	double *data = (double*) calloc(3,sizeof(double));
		
		data[0] = x;
		data[1] = y;
		data[2] = z;
		
		((BezierPoint*) (this->bspd->BezierSimploid::getControl_Point(idx) ) )->BezierPoint::setData(data);
		
		return;
}




void BezierPrism::stepZ(float step)
{
	double *d = (double*) calloc(3,sizeof(double));
	d[0] = 0;
	d[1] = 0;
	d[2] = step;
	this->bspd->BezierSimploid::translate(d);
}


BezierPrism::BezierPrism(int deg_u, int deg_v, int build)
{
	
	this->n = (deg_u+1)*((deg_v+2)*(deg_v+1)/2);
	
	this->deg_u = deg_u;
	this->deg_v = deg_v;
	
	this->ind_vec = (Index::HyperIdx**) calloc(this->n,sizeof(Index::HyperIdx*));
	
}


void BezierPrism::updControlPoints(int j, float x, float y, float z)
{
    this->BezierPrism::setControlPoint((Index::BezierIndex*)this->ind_vec[j],x,y,z);

    return;	
	
}


int BezierPrism::getN()
{
	return this->n;
}



BezierPrism* BezierPrism::blossom_1D(int dir, float a,float u,float v,float w)
{
	BezierPrism* br2 = new BezierPrism(this->deg_u-1,this->deg_v-1,1);
	
	double** point;
	point= (double**) calloc(2,sizeof(double*));
	point[0] = (double*) calloc(2,sizeof(double));
	point[1] = (double*) calloc(3,sizeof(double));
	
	point[0][0] = a;
	point[0][1] = 1.f -a;
	point[1][0] = u;
	point[1][1] = v;	
	point[1][2] = w;
	
	br2->bspd = this->bspd->BezierSimploid::blossom(point);
	
	return br2;
}


double BezierPrism::eval(float a,float u,float v,float w,int coord)
{
	BezierPoint* bp;
	double value;
	
	double** point;
	point= (double**) calloc(2,sizeof(double*));
	point[0] = (double*) calloc(2,sizeof(double));
	point[1] = (double*) calloc(3,sizeof(double));
	
	point[0][0] = a;
	point[0][1] = 1.f -a;
	point[1][0] = u;
	point[1][1] = v;	
	point[1][2] = w;
	
	bp = (BezierPoint*) this->bspd->BezierSimploid::eval(point);
		
	value =  bp->data[coord];
	
	delete (BezierPoint*)bp;
	
	delete point;
		
	return value;
	
		
}


void BezierPrism::evalGrid(int steps)
{
		int a1=0;
		int v1=0;
	    int u1=0;
	    
	    float step1 = (float)1.0001/steps;


	    gX = (float****)calloc(steps+1,sizeof(float***)) ;
	    gY = (float****)calloc(steps+1,sizeof(float***)) ;
	    gZ = (float****)calloc(steps+1,sizeof(float***)) ;



	    for(a1=0;a1<=steps;a1++)
	    {
	    	gX[a1] = (float***)calloc(steps+1,sizeof(float**));
	        gY[a1] = (float***)calloc(steps+1,sizeof(float**));
	        gZ[a1] = (float***)calloc(steps+1,sizeof(float**));
		    for (u1=0; u1 <= steps; u1++)
		    {
	
		        gX[a1][u1] = (float**)calloc(steps-u1+1,sizeof(float*));
		        gY[a1][u1] = (float**)calloc(steps-u1+1,sizeof(float*));
		        gZ[a1][u1] = (float**)calloc(steps-u1+1,sizeof(float*));
	
	
		        for (v1=0; v1 <= steps-u1; v1++)
		        {
		            gX[a1][u1][v1] = (float*)calloc(1,sizeof(float));
		            gY[a1][u1][v1] = (float*)calloc(1,sizeof(float));
		            gZ[a1][u1][v1] = (float*)calloc(1,sizeof(float));
	
		            //if(comp==0)
		            {
		                gX[a1][u1][v1][0] = this->eval(a1*step1,u1*step1, v1*step1,1-(u1*step1 + v1*step1), 0);
	
		                gY[a1][u1][v1][0] = this->eval(a1*step1,u1*step1, v1*step1,1-(u1*step1 + v1*step1), 1);
	
		                gZ[a1][u1][v1][0] = this->eval(a1*step1,u1*step1, v1*step1,1-(u1*step1 + v1*step1), 2);
		            }
		            
		        }
		    }
	    }

	    return;
}

std::vector<float*> BezierPrism::wireFrameEdges(int steps)
{
	std::vector<float*> l;
	
	
	
	this->BezierPrism::evalGrid(steps);
	
    float *linePiece;

    
	linePiece = new float[6];
    	
    linePiece[0] = 0;
    linePiece[1] = 0;
    linePiece[2] = 0;
    linePiece[3] = 1;
    linePiece[4] = 1;
    linePiece[5] = 1;


    //l.push_back(linePiece);
    //return l;



        int ai,ui,vi,wi;

        


        // wireframe
        for(ai=0; ai<= steps; ai++)
        for (ui=0; ui<= steps; ui++)
          {
            for (vi=0; vi<= steps - ui; vi++)
              {
                
                {wi=0;
                    
                    {
                    	if(ui<steps)
                    	if((vi==0)&&((ai==0)||(ai==steps)))
                    	{
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai][ui+1][vi][wi];
	                        linePiece[4] = gY[ai][ui+1][vi][wi];
	                        linePiece[5] = gZ[ai][ui+1][vi][wi];
	
	                        l.push_back(linePiece);
                    	}

                    	if(ai<steps)
	                    if ((ui==steps)||(vi==steps)||((ui==0)&&(vi==0)))
	                    {
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai+1][ui][vi][wi];
	                        linePiece[4] = gY[ai+1][ui][vi][wi];
	                        linePiece[5] = gZ[ai+1][ui][vi][wi];
	
	                        l.push_back(linePiece);
	                    }                    
                    
                    
                    	if(vi<steps)
	                    if((ui==0)&&((ai==0)||(ai==steps)))
	                    {   //if(gX[i][j+1]!=0)
	                    	
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai][ui][vi+1][wi];
	                        linePiece[4] = gY[ai][ui][vi+1][wi];
	                        linePiece[5] = gZ[ai][ui][vi+1][wi];
	
	                        l.push_back(linePiece);
	                    }
                    	
	                    if ((vi>0)&&(ui<steps))
	                    	if((ui+vi==steps)&&((ai==0)||(ai==steps)))
	                    {   //if(gX[i][j+1]!=0)
	                    	
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai][ui+1][vi-1][wi];
	                        linePiece[4] = gY[ai][ui+1][vi-1][wi];
	                        linePiece[5] = gZ[ai][ui+1][vi-1][wi];
	
	                        l.push_back(linePiece);
	                    }

                    }
                }


              }
          }


        return l;
   	
}

std::vector<float*> BezierPrism::wireFrame(int steps)
{
	std::vector<float*> l;
	
	
	
	this->BezierPrism::evalGrid(steps);
	
    float *linePiece;

    
	linePiece = new float[6];
    	
    linePiece[0] = 0;
    linePiece[1] = 0;
    linePiece[2] = 0;
    linePiece[3] = 1;
    linePiece[4] = 1;
    linePiece[5] = 1;


    //l.push_back(linePiece);
    //return l;



        int ai,ui,vi,wi;

        


        // wireframe
        for(ai=0; ai<= steps; ai++)
        for (ui=0; ui<= steps; ui++)
          {
            for (vi=0; vi<= steps - ui; vi++)
              {
                
                {wi=0;
                    
                    {
                    	if(ui<steps)
                    	if((vi==0))
                    	{
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai][ui+1][vi][wi];
	                        linePiece[4] = gY[ai][ui+1][vi][wi];
	                        linePiece[5] = gZ[ai][ui+1][vi][wi];
	
	                        l.push_back(linePiece);
                    	}

                    	if(ai<steps)
	                    if ((ui==steps)||(vi==steps)||((ui==0)&&(vi==0)))
	                    {
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai+1][ui][vi][wi];
	                        linePiece[4] = gY[ai+1][ui][vi][wi];
	                        linePiece[5] = gZ[ai+1][ui][vi][wi];
	
	                        l.push_back(linePiece);
	                    }                    
                    
                    
                    	if(vi<steps)
	                    if((ui==0))
	                    {   //if(gX[i][j+1]!=0)
	                    	
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai][ui][vi+1][wi];
	                        linePiece[4] = gY[ai][ui][vi+1][wi];
	                        linePiece[5] = gZ[ai][ui][vi+1][wi];
	
	                        l.push_back(linePiece);
	                    }
                    	
	                    if ((vi>0)&&(ui<steps))
	                    	if((ui+vi==steps))
	                    {   //if(gX[i][j+1]!=0)
	                    	
	                    	linePiece = new float[6];
	                    	
	                        linePiece[0] = gX[ai][ui][vi][wi];
	                        linePiece[1] = gY[ai][ui][vi][wi];
	                        linePiece[2] = gZ[ai][ui][vi][wi];
	                        linePiece[3] = gX[ai][ui+1][vi-1][wi];
	                        linePiece[4] = gY[ai][ui+1][vi-1][wi];
	                        linePiece[5] = gZ[ai][ui+1][vi-1][wi];
	
	                        l.push_back(linePiece);
	                    }

                    }
                }


              }
          }


        return l;
   	
}


/*
std::vector<float*> BezierPrism::wireFrame(int steps)
{
	std::vector<float*> l;
	
	
	
	this->BezierPrism::evalGrid(steps);
	
    float *linePiece;

    
	linePiece = new float[6];
    	
    linePiece[0] = 0;
    linePiece[1] = 0;
    linePiece[2] = 0;
    linePiece[3] = 1;
    linePiece[4] = 1;
    linePiece[5] = 1;


    //l.push_back(linePiece);
    //return l;



        int ai,ui,vi,wi;

        


        // wireframe
        for(ai=0; ai< steps; ai++)
        for (ui=0; ui< steps; ui++)
          {
            for (vi=0; vi< steps - ui; vi++)
              {
                //for (wi=0; wi< steps -ui -vi; wi++)
                {wi=0;
                    //if (dir==0 )
                    {//if(gX[i+1][j]!=0)
                    	linePiece = new float[6];
                    	
                        linePiece[0] = gX[ai][ui][vi][wi];
                        linePiece[1] = gY[ai][ui][vi][wi];
                        linePiece[2] = gZ[ai][ui][vi][wi];
                        linePiece[3] = gX[ai][ui+1][vi][wi];
                        linePiece[4] = gY[ai][ui+1][vi][wi];
                        linePiece[5] = gZ[ai][ui+1][vi][wi];

                        l.push_back(linePiece);
                    }

                    {//if(gX[i+1][j]!=0)
                    	linePiece = new float[6];
                    	
                        linePiece[0] = gX[ai][ui][vi][wi];
                        linePiece[1] = gY[ai][ui][vi][wi];
                        linePiece[2] = gZ[ai][ui][vi][wi];
                        linePiece[3] = gX[ai+1][ui][vi][wi];
                        linePiece[4] = gY[ai+1][ui][vi][wi];
                        linePiece[5] = gZ[ai+1][ui][vi][wi];

                        l.push_back(linePiece);
                    }                    
                    
                    
                    
                    
                    //if (dir==1)
                    {   //if(gX[i][j+1]!=0)
                    	
                    	linePiece = new float[6];
                    	
                        linePiece[0] = gX[ai][ui][vi][wi];
                        linePiece[1] = gY[ai][ui][vi][wi];
                        linePiece[2] = gZ[ai][ui][vi][wi];
                        linePiece[3] = gX[ai][ui][vi+1][wi];
                        linePiece[4] = gY[ai][ui][vi+1][wi];
                        linePiece[5] = gZ[ai][ui][vi+1][wi];

                        l.push_back(linePiece);
                    }
                    if ((vi>0))
                    {   //if(gX[i][j+1]!=0)
                    	
                    	linePiece = new float[6];
                    	
                        linePiece[0] = gX[ai][ui][vi][wi];
                        linePiece[1] = gY[ai][ui][vi][wi];
                        linePiece[2] = gZ[ai][ui][vi][wi];
                        linePiece[3] = gX[ai][ui+1][vi-1][wi];
                        linePiece[4] = gY[ai][ui+1][vi-1][wi];
                        linePiece[5] = gZ[ai][ui+1][vi-1][wi];

                        l.push_back(linePiece);
                    }

                    
                }


              }
          }


        return l;
    
}

*/

std::vector<float*> BezierPrism::getControlPoints()
{
	std::vector<float*> l;
	//std::vector<float*>::iterator iter;
	
	std::vector<Index::HyperIdx*>::iterator iter;
	std::vector<Index::HyperIdx*> v;
	
	Index::BezierIndex* p;
	
	Index::MultiIdx *degs,*dims;
	degs = new Index::MultiIdx(2);
	dims = new Index::MultiIdx(2);
	int i;
	for(i=0;i<2;i++)
	{
		degs->idx[i] = this->bspd->deg_v[i];
		dims->idx[i] = this->bspd->ddim_v[i];
	}
		
	
	v = Index::HyperIdx::getAllIndexes(degs,dims);
	
	
    i=0;

    {

    	for(iter=v.begin();iter!=v.end();iter++)
    	{
    		p = (Index::BezierIndex*) (*iter);
    		//((Index::HyperIdx*)p)->print(stderr);
    		l.push_back(this->BezierPrism::getControlPoint(p));
    		this->ind_vec[i] = (Index::HyperIdx*)p;
    		//this->ind_vec[i]->line[0]->print(stderr);
    		i++;
    		
    	}
	}

    return l;

}


float* BezierPrism::getLinePiece(int orig, int dest)
{
return NULL;
}


std::vector<float*> BezierPrism::controlNet()
{
	std::vector<BezierSimploid**> l;
	std::vector<float*> res;
	std::vector<BezierSimploid**>::iterator iter;
			
	float *linePiece;
		
		
		l = this->bspd->BezierSimploid::controlNet();
		for(iter=l.begin();iter!=l.end();iter++)
		{
			linePiece = (float*) calloc(6,sizeof(float));
			linePiece[0] = ((BezierPoint**)(*iter))[0]->data[0];
			linePiece[1] = ((BezierPoint**)(*iter))[0]->data[1];
			linePiece[2] = ((BezierPoint**)(*iter))[0]->data[2];
			linePiece[3] = ((BezierPoint**)(*iter))[1]->data[0];
			linePiece[4] = ((BezierPoint**)(*iter))[1]->data[1];
			linePiece[5] = ((BezierPoint**)(*iter))[1]->data[2];
			
			res.push_back(linePiece);
		}
		
	   
		    return res;
}

void BezierPrism::init(float spacing)
{
	
	int *ddim = new int[2];
	int *deg = new int[2];
	ddim[0]=1;
	ddim[1]=2;
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	
	this->bspd = new BezierSimploid(2,ddim,3,deg);
	this->bspd->BezierSimploid::init(spacing);
}

