#ifndef BEZIERPRISM_H_
#define BEZIERPRISM_H_

#include "Bezier_Element.h"
#include "BezierCurve.h"
#include <vector.h>
//#include "BezierTriangle.h"
#include "../../conversionV2/Index/IndexedMatrix.h"
#include "../../conversionV2/Index/HyperIdx.h"
#include "BezierSimploid.h"



class BezierPrism : public Bezier_Element
{
public:
	BezierCurve** c;
		int deg_u, deg_v;
		int n_u,n_v;
		int n;
		
		float ****gX, ****gY, ****gZ;
		
		Index::HyperIdx **ind_vec;		
		
		BezierSimploid* bspd;
		
		
		 int  getOrder();
		
		 int*  getDimensions();
		
		 int*  getDegrees();
		
		
		
		//void  fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bt);
		
		void  setControlPoint(Index::BezierIndex *idx, float x, float y, float z);
		
		float*  getControlPoint(Index::BezierIndex *idx);
		
		
		void  updControlPoints(int i, float x, float y, float z);
		
		int  getN();
		
		BezierPrism*  blossom_1D(int dir, float a,float u,float v,float w);
		//BezierPrism*  blossom(float u, float v);
		double  eval(float a,float u,float v,float w,int coord);
		void  evalGrid(int steps);
		
		
		std::vector<float*>  wireFrame(int steps);
		std::vector<float*>  wireFrameEdges(int steps);		
		std::vector<float*>  getControlPoints();
		
		float*  getLinePiece(int orig, int dest);	
			
		std::vector<float*>  controlNet();
				
		
		
		void  stepZ(float step);
		
		void  init(float spacing);
		
		
		BezierPrism*  times(float v);
		BezierPrism*  add(BezierPrism* op1);
		
		//void  uptFromBezierTriangle(BezierTriangle* bt);
		
		
		BezierPrism(int deg_u, int deg_v, int build);
		virtual ~BezierPrism();
	
	
	
};

#endif /*BEZIERPRISM_H_*/
