#include "BezierRectangle.h"



int BezierRectangle::getOrder()
{
	return 2;
}
	
int* BezierRectangle::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(2,sizeof(int));
	
	dim[0] = 1;
	dim[1] = 1;
	
	
	return dim;
}
	
int* BezierRectangle::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(2,sizeof(int));
	
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	
	
	return deg;
}







float* BezierRectangle::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
	
	if((idx->get(0)> this->deg_u)||
			(idx->get(1)> this->deg_v))
		return 0x0;
	
	
	res = (float*) calloc(3,sizeof(float));
	
	res[0] = this->c[idx->get(0)]->X[idx->get(1)];
	res[1] = this->c[idx->get(0)]->Y[idx->get(1)];
	res[2] = this->c[idx->get(0)]->Z[idx->get(1)];
	
	return res;
}


void BezierRectangle::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	if((idx->get(0)> this->deg_u)||
			(idx->get(1)> this->deg_v))
		return;
	
	
	this->c[idx->get(0)]->X[idx->get(1)]=x;
	this->c[idx->get(0)]->Y[idx->get(1)]=y;
	this->c[idx->get(0)]->Z[idx->get(1)]=z;
	
	return;
}


void BezierRectangle::fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}

/*
void BezierRectangle::uptFromBezierTriangle(BezierTriangle* bt)
{

    this->c[0]->X[0] = bt->c[0]->X[0];
    
    this->c[0]->X[1] = bt->c[1]->X[1];
    
    this->c[0]->X[2] = bt->c[2]->X[2];
    
    this->c[0]->X[3] = bt->c[3]->X[3];
    
    
    
    this->c[1]->X[0] = bt->c[1]->X[0];
    
    this->c[1]->X[1] = -0.33f*bt->c[0]->X[0] + 0.33f*bt->c[1]->X[1] + 
                    0.33f*bt->c[1]->X[0] + 0.66f*bt->c[2]->X[1];
    
    this->c[1]->X[2] = -0.66f*bt->c[1]->X[1] + 0.66f*bt->c[2]->X[2] + 
                    0.66f*bt->c[2]->X[1] + 0.33f*bt->c[3]->X[2];
    
    this->c[1]->X[3] = -1*bt->c[2]->X[2] + bt->c[3]->X[3] + bt->c[3]->X[2];
    
    
    
    
    this->c[2]->X[0] = bt->c[2]->X[0];       
    
    this->c[2]->X[1] = -0.66f*bt->c[1]->X[0] + 0.66f*bt->c[2]->X[1] + 
                    0.66f*bt->c[2]->X[0] + 0.33f*bt->c[3]->X[1];
    
    this->c[2]->X[2] = 0.33f*bt->c[0]->X[0] -0.66f*bt->c[1]->X[1] + 0.33f*bt->c[2]->X[2] +
                   -0.66f*bt->c[1]->X[0] + 0.66f*bt->c[3]->X[2] +
                   0.33f*bt->c[2]->X[0] + 0.66f*bt->c[3]->X[1];
    
    this->c[2]->X[3] = bt->c[1]->X[1] - 2*bt->c[2]->X[2] + bt->c[3]->X[3] +
                   -2*bt->c[2]->X[1] + 2*bt->c[3]->X[2] +
                   bt->c[3]->X[1];
    
    
    
    this->c[3]->X[0] = bt->c[3]->X[0];       
    
    this->c[3]->X[1] = -1*bt->c[2]->X[0] + bt->c[3]->X[1] + 
    			bt->c[3]->X[0];
    
    this->c[3]->X[2] = bt->c[1]->X[0] -2*bt->c[2]->X[1] + bt->c[3]->X[2] +
                   -2*bt->c[2]->X[0] + 2*bt->c[3]->X[1] +
                   bt->c[3]->X[0];
    
    this->c[3]->X[3] = -1*bt->c[0]->X[0] + 3*bt->c[1]->X[1] - 3*bt->c[2]->X[2] +
    			bt->c[3]->X[3] + 3*bt->c[1]->X[0] - 6*bt->c[2]->X[1] +
               3*bt->c[3]->X[2] - 3*bt->c[2]->X[0] + 3*bt->c[3]->X[1] +
               bt->c[3]->X[0];
	        	
    
    
    
    
    //////////////////////////////////
    this->c[0]->Y[0] = bt->c[0]->Y[0];
    
    this->c[0]->Y[1] = bt->c[1]->Y[1];
    
    this->c[0]->Y[2] = bt->c[2]->Y[2];
    
    this->c[0]->Y[3] = bt->c[3]->Y[3];
    
    
    
    this->c[1]->Y[0] = bt->c[1]->Y[0];
    
    this->c[1]->Y[1] = -0.33f*bt->c[0]->Y[0] + 0.33f*bt->c[1]->Y[1] + 
                    0.33f*bt->c[1]->Y[0] + 0.66f*bt->c[2]->Y[1];
    
    this->c[1]->Y[2] = -0.66f*bt->c[1]->Y[1] + 0.66f*bt->c[2]->Y[2] + 
                    0.66f*bt->c[2]->Y[1] + 0.33f*bt->c[3]->Y[2];
    
    this->c[1]->Y[3] = -1*bt->c[2]->Y[2] + bt->c[3]->Y[3] + bt->c[3]->Y[2];
    
    
    
    
    this->c[2]->Y[0] = bt->c[2]->Y[0];       
    
    this->c[2]->Y[1] = -0.66f*bt->c[1]->Y[0] + 0.66f*bt->c[2]->Y[1] + 
                    0.66f*bt->c[2]->Y[0] + 0.33f*bt->c[3]->Y[1];
    
    this->c[2]->Y[2] = 0.33f*bt->c[0]->Y[0] -0.66f*bt->c[1]->Y[1] + 0.33f*bt->c[2]->Y[2] +
                   -0.66f*bt->c[1]->Y[0] + 0.66f*bt->c[3]->Y[2] +
                   0.33f*bt->c[2]->Y[0] + 0.66f*bt->c[3]->Y[1];
    
    this->c[2]->Y[3] = bt->c[1]->Y[1] - 2*bt->c[2]->Y[2] + bt->c[3]->Y[3] +
                   -2*bt->c[2]->Y[1] + 2*bt->c[3]->Y[2] +
                   bt->c[3]->Y[1];
    
    
    
    this->c[3]->Y[0] = bt->c[3]->Y[0];       
    
    this->c[3]->Y[1] = -1*bt->c[2]->Y[0] + bt->c[3]->Y[1] + 
    			bt->c[3]->Y[0];
    
    this->c[3]->Y[2] = bt->c[1]->Y[0] -2*bt->c[2]->Y[1] + bt->c[3]->Y[2] +
                   -2*bt->c[2]->Y[0] + 2*bt->c[3]->Y[1] +
                   bt->c[3]->Y[0];
    
    this->c[3]->Y[3] = -1*bt->c[0]->Y[0] + 3*bt->c[1]->Y[1] - 3*bt->c[2]->Y[2] +
    			bt->c[3]->Y[3] + 3*bt->c[1]->Y[0] - 6*bt->c[2]->Y[1] +
               3*bt->c[3]->Y[2] - 3*bt->c[2]->Y[0] + 3*bt->c[3]->Y[1] +
               bt->c[3]->Y[0];
    
    
    /////////////////////////////////////////////////////////
    this->c[0]->Z[0] = bt->c[0]->Z[0];
    
    this->c[0]->Z[1] = bt->c[1]->Z[1];
    
    this->c[0]->Z[2] = bt->c[2]->Z[2];
    
    this->c[0]->Z[3] = bt->c[3]->Z[3];
    
    
    
    this->c[1]->Z[0] = bt->c[1]->Z[0];
    
    this->c[1]->Z[1] = -0.33f*bt->c[0]->Z[0] + 0.33f*bt->c[1]->Z[1] + 
                    0.33f*bt->c[1]->Z[0] + 0.66f*bt->c[2]->Z[1];
    
    this->c[1]->Z[2] = -0.66f*bt->c[1]->Z[1] + 0.66f*bt->c[2]->Z[2] + 
                    0.66f*bt->c[2]->Z[1] + 0.33f*bt->c[3]->Z[2];
    
    this->c[1]->Z[3] = -1*bt->c[2]->Z[2] + bt->c[3]->Z[3] + bt->c[3]->Z[2];
    
    
    
    
    this->c[2]->Z[0] = bt->c[2]->Z[0];       
    
    this->c[2]->Z[1] = -0.66f*bt->c[1]->Z[0] + 0.66f*bt->c[2]->Z[1] + 
                    0.66f*bt->c[2]->Z[0] + 0.33f*bt->c[3]->Z[1];
    
    this->c[2]->Z[2] = 0.33f*bt->c[0]->Z[0] -0.66f*bt->c[1]->Z[1] + 0.33f*bt->c[2]->Z[2] +
                   -0.66f*bt->c[1]->Z[0] + 0.66f*bt->c[3]->Z[2] +
                   0.33f*bt->c[2]->Z[0] + 0.66f*bt->c[3]->Z[1];
    
    this->c[2]->Z[3] = bt->c[1]->Z[1] - 2*bt->c[2]->Z[2] + bt->c[3]->Z[3] +
                   -2*bt->c[2]->Z[1] + 2*bt->c[3]->Z[2] +
                   bt->c[3]->Z[1];
    
    
    
    this->c[3]->Z[0] = bt->c[3]->Z[0];       
    
    this->c[3]->Z[1] = -1*bt->c[2]->Z[0] + bt->c[3]->Z[1] + 
    			bt->c[3]->Z[0];
    
    this->c[3]->Z[2] = bt->c[1]->Z[0] -2*bt->c[2]->Z[1] + bt->c[3]->Z[2] +
                   -2*bt->c[2]->Z[0] + 2*bt->c[3]->Z[1] +
                   bt->c[3]->Z[0];
    
    this->c[3]->Z[3] = -1*bt->c[0]->Z[0] + 3*bt->c[1]->Z[1] - 3*bt->c[2]->Z[2] +
    			bt->c[3]->Z[3] + 3*bt->c[1]->Z[0] - 6*bt->c[2]->Z[1] +
               3*bt->c[3]->Z[2] - 3*bt->c[2]->Z[0] + 3*bt->c[3]->Z[1] +
               bt->c[3]->Z[0];
}
*/


void BezierRectangle::stepZ(float step)
{
	int i;
	for(i=0;i<=this->deg_u;i++)
		this->c[i]->stepZ((int)step);
}


BezierRectangle::BezierRectangle(int deg_u, int deg_v, int build)
{
	int i;
	
	this->deg_u = deg_u;
	this->n_u = deg_u+1;
	this->c = (BezierCurve**) calloc(this->n_u,sizeof(BezierCurve*));
	
	
	
	this->deg_v = deg_v;
	this->n_v = deg_v +1;
	
	if(build==1)
		for(i=0;i<this->n_u;i++)
			this->c[i] = new BezierCurve(this->deg_v);
		
	
		
	this->n = this->n_v * this->n_v;
	
}


void BezierRectangle::updControlPoints(int i, float x, float y, float z)
{
	int quo, rest;
	quo = i/this->n_v;
	rest = i % this->n_v;
	
	this->c[quo]->X[rest] = x;
	this->c[quo]->Y[rest] = y;
	this->c[quo]->Z[rest] = z;
		
	
}


int BezierRectangle::getN()
{
	return this->n;
}



BezierRectangle* BezierRectangle::blossom_1D(int dir, float v1,float v2)
{
	BezierRectangle* rec;
	BezierCurve *c1,*c2;
	
	int i;
	if(dir==0)
	{
		rec = new BezierRectangle(this->deg_u-1,this->deg_v,0);
		
		for(i=0; i< this->deg_u;i++)
		{
			c1 = this->c[i]->BezierCurve::times(v1);
			c2 = this->c[i+1]->BezierCurve::times(v2);
						
			rec->c[i] =c1->BezierCurve::add(c2);
		}
		
	}
	
	if(dir==1)
	{
		rec = new BezierRectangle(this->deg_u,this->deg_v-1,0);
		
		for(i=0; i<= this->deg_u;i++)
			rec->c[i] = this->c[i]->BezierCurve::blossom(v1,v2);
		
	}

	return rec;
}


double BezierRectangle::eval(double u, double v,int coord)
{
	BezierRectangle *rec;
	
	rec = this;
	int i;
	
	for(i=0;i<this->deg_u;i++)
		rec = rec->BezierRectangle::blossom_1D(0,u,1-u);
	
	for(i=0;i<this->deg_v;i++)
			rec = rec->BezierRectangle::blossom_1D(1,v,1-v);
		
	if(coord==0)
		return rec->c[0]->X[0];
	
	
	if(coord==1)
		return rec->c[0]->Y[0];
	
	
	return rec->c[0]->Z[0];
	
		
}


void BezierRectangle::evalGrid(int steps)
{
	int v1=0;
    int u1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float**)calloc(steps+1,sizeof(float*)) ;
    gY = (float**)calloc(steps+1,sizeof(float*)) ;
    gZ = (float**)calloc(steps+1,sizeof(float*)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float*)calloc(steps+1,sizeof(float));
        gY[u1] = (float*)calloc(steps+1,sizeof(float));
        gZ[u1] = (float*)calloc(steps+1,sizeof(float));


        for (v1=0; v1 <= steps; v1++)
        {
            //gX[u1][v1] = (float*)calloc(1,sizeof(float));
            //gY[u1][v1] = (float*)calloc(1,sizeof(float));
            //gZ[u1][v1] = (float*)calloc(1,sizeof(float));

            //if(comp==0)
            {
                gX[u1][v1] = this->eval(u1*step1, v1*step1, 0);

                gY[u1][v1] = this->eval(u1*step1, v1*step1, 1);

                gZ[u1][v1] = this->eval(u1*step1, v1*step1, 2);
            }
            
        }
    }


    return;
}

std::vector<float*> BezierRectangle::wireFrameEdges(int steps)
{
	return BezierRectangle::wireFrame(steps);
}


std::vector<float*> BezierRectangle::wireFrame(int steps)
{
	std::vector<float*> l;
	
    float *linePiece;


    int ui,vi;

    this->BezierRectangle::evalGrid(steps);


    // wireframe

    for (ui=0; ui< steps; ui++)
      {
        for (vi=0; vi< steps; vi++)
          {
           
            {//if(gX[i+1][j]!=0)
            	linePiece = new float[6];
            	
                linePiece[0] = gX[ui][vi];
                linePiece[1] = gY[ui][vi];
                linePiece[2] = gZ[ui][vi];
                linePiece[3] = gX[ui+1][vi];
                linePiece[4] = gY[ui+1][vi];
                linePiece[5] = gZ[ui+1][vi];

                l.push_back(linePiece);
            }

        	{   //if(gX[i][j+1]!=0)
            	
            	linePiece = new float[6];
            	
                linePiece[0] = gX[ui][vi];
                linePiece[1] = gY[ui][vi];
                linePiece[2] = gZ[ui][vi];
                linePiece[3] = gX[ui][vi+1];
                linePiece[4] = gY[ui][vi+1];
                linePiece[5] = gZ[ui][vi+1];

                l.push_back(linePiece);                
            }


          }
      }



    return l;

	
}


std::vector<float*> BezierRectangle::getControlPoints()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
	
    int i;
    for(i=0;i<this->n_u;i++)
    {
    	laux = this->c[i]->BezierCurve::getControlPoints();
    	for(iter=laux.begin();iter!=laux.end();iter++)
    		l.push_back(*iter);
	}

    return l;


}


float* BezierRectangle::getLinePiece(int orig, int dest)
{
return NULL;
}


std::vector<float*> BezierRectangle::controlNet()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
		
	float *linePiece;
	
	
    int i,j;
    for(i=0;i< this->n_u -1;i++)
    {
    	
    	laux = this->c[i]->BezierCurve::controlNet();
    	
    	    	
    	
    	for(j=0;j < this->n_v ; j++)
		{
			linePiece = new float[6];
			linePiece[0] = this->c[i]->X[j];
			linePiece[1] = this->c[i]->Y[j];
			linePiece[2] = this->c[i]->Z[j];
			
			linePiece[3] = this->c[i+1]->X[j];
			linePiece[4] = this->c[i+1]->Y[j];
			linePiece[5] = this->c[i+1]->Z[j];
		
			laux.push_back(linePiece);
		}
	
	
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
}
    
    
    laux = this->c[this->deg_u]->BezierCurve::controlNet();
    for(iter=laux.begin();iter!=laux.end();iter++)
        		l.push_back(*iter);
    

	    return l;
}

void BezierRectangle::init(float spacing)
{
	int i,j;
	
	for(i=0;i<this->n_u;i++)
		for(j=0;j<this->n_v;j++)
		{
			this->c[i]->X[j] = spacing*i;
			this->c[i]->Y[j] = spacing*j;
			this->c[i]->Z[j] = 0;
		}
}



BezierRectangle* BezierRectangle::times(float v)
{
	int i;
	BezierRectangle* r = new BezierRectangle(this->deg_u,this->deg_v,0);
	
	for(i=0;i<this->n_u;i++)
		r->c[i] = this->c[i]->BezierCurve::times(v);
	
	return r;
	
}

BezierRectangle* BezierRectangle::add(BezierRectangle* op1)
{
	int i;
	BezierRectangle* r = new BezierRectangle(op1->deg_u,op1->deg_v,0);
	
	for(i=0;i<op1->n_u;i++)
			r->c[i] = this->c[i]->BezierCurve::add(op1->c[i]);
		
	return r;
	
	
}


BezierRectangle::~BezierRectangle()
{
}
