#ifndef BEZIERRECTANGLE_H_
#define BEZIERRECTANGLE_H_

#include "Bezier_Element.h"
#include "BezierCurve.h"
#include <vector.h>
//#include "BezierTriangle.h"
#include "../../conversionV2/Index/IndexedMatrix.h"

class BezierRectangle : public Bezier_Element
{
public:
	
	BezierCurve** c;
	int deg_u, deg_v;
	int n_u,n_v;
	int n;
	
	float **gX, **gY, **gZ;
	
	
	 int  getOrder();
	
	 int*  getDimensions();
	
	 int*  getDegrees();
	
	
	
	void  fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bt);
	
	void  setControlPoint(Index::BezierIndex *idx, float x, float y, float z);
	
	float*  getControlPoint(Index::BezierIndex *idx);
	
	
	void  updControlPoints(int i, float x, float y, float z);
	
	int  getN();
	
	BezierRectangle*  blossom_1D(int dir, float v1,float v2);
	//BezierRectangle*  blossom(float u, float v);
	double  eval(double u, double v,int coord);
	void  evalGrid(int steps);
	
	
	std::vector<float*>  wireFrame(int steps);
	std::vector<float*>  wireFrameEdges(int steps);
	std::vector<float*>  getControlPoints();
	
	float*  getLinePiece(int orig, int dest);	
		
	std::vector<float*>  controlNet();
			
	
	
	void  stepZ(float step);
	
	void  init(float spacing);
	
	
	BezierRectangle*  times(float v);
	BezierRectangle*  add(BezierRectangle* op1);
	
	//void  uptFromBezierTriangle(BezierTriangle* bt);
	
	
	BezierRectangle(int deg_u, int deg_v, int build);
	virtual ~BezierRectangle();
};

#endif /*BEZIERRECTANGLE_H_*/
