#include "BezierRectangle2.h"
#include "BezierPoint.h"




int BezierRectangle2::getOrder()
{
	return 2;
}
	
int* BezierRectangle2::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(2,sizeof(int));
	
	dim[0] = 1;
	dim[1] = 1;
	
	
	return dim;
}
	
int* BezierRectangle2::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(2,sizeof(int));
	
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	
	
	return deg;
}







float* BezierRectangle2::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
		
		BezierPoint* bp;
		
		bp = (BezierPoint*) this->bspd->BezierSimploid::getControl_Point(idx);
		
		res = (float*) calloc(3,sizeof(float));
		
		
		res[0] = bp->data[0];
		res[1] = bp->data[1];
		res[2] = bp->data[2];
		
		return res;
}


void BezierRectangle2::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	double *data = (double*) calloc(3,sizeof(double));
		
		data[0] = x;
		data[1] = y;
		data[2] = z;
		
		((BezierPoint*) (this->bspd->BezierSimploid::getControl_Point(idx) ) )->BezierPoint::setData(data);
		
		return;
}


void BezierRectangle2::fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	Index::HyperIdx* idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		idx = Index::HyperIdx::HyperIdx::fromTensorIdx((Index::MultiIdx*)row_idx,this->bspd->deg_v);
		
		this->setControlPoint((Index::BezierIndex*)idx,x,y,z);
	}
	
}




void BezierRectangle2::stepZ(float step)
{
	double *d = (double*) calloc(3,sizeof(double));
	d[0] = 0;
	d[1] = 0;
	d[2] = step;
	this->bspd->BezierSimploid::translate(d);
}


BezierRectangle2::BezierRectangle2(int deg_u, int deg_v, int build)
{
	
	this->n = (deg_u+1)*(deg_v+1);
	
	this->deg_u = deg_u;
	this->deg_v = deg_v;
	
	this->ind_vec = (Index::HyperIdx**) calloc(this->n,sizeof(Index::HyperIdx*));
	
}


void BezierRectangle2::updControlPoints(int j, float x, float y, float z)
{
    this->BezierRectangle2::setControlPoint((Index::BezierIndex*)this->ind_vec[j],x,y,z);

    return;	
	
}


int BezierRectangle2::getN()
{
	return this->n;
}



BezierRectangle2* BezierRectangle2::blossom_1D(int dir, float v1,float v2)
{
	BezierRectangle2* br2 = new BezierRectangle2(this->deg_u-1,this->deg_v-1,1);
	
	double** point;
	point= (double**) calloc(2,sizeof(double*));
	point[0] = (double*) calloc(2,sizeof(double));
	point[1] = (double*) calloc(2,sizeof(double));
	
	point[0][0] = v1;
	point[0][1] = 1.f -v1;
	point[1][0] = v2;
	point[1][1] = 1.f -v2;	
	
	br2->bspd = this->bspd->BezierSimploid::blossom(point);
	
	return br2;
}


double BezierRectangle2::eval(double v1, double v2,int coord)
{
	BezierPoint* bp;
	double** point;
	double value;
	
	
	point= (double**) calloc(2,sizeof(double*));
	point[0] = (double*) calloc(2,sizeof(double));
	point[1] = (double*) calloc(2,sizeof(double));
	
	point[0][0] = v1;
	point[0][1] = 1.f -v1;
	point[1][0] = v2;
	point[1][1] = 1.f -v2;	
		
	bp = (BezierPoint*) this->bspd->BezierSimploid::eval(point);
		
	value = bp->data[coord];
	delete (BezierPoint*)bp;
	
	return value;
		
}


void BezierRectangle2::evalGrid(int steps)
{
	int v1=0;
    int u1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float**)calloc(steps+1,sizeof(float*)) ;
    gY = (float**)calloc(steps+1,sizeof(float*)) ;
    gZ = (float**)calloc(steps+1,sizeof(float*)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float*)calloc(steps+1,sizeof(float));
        gY[u1] = (float*)calloc(steps+1,sizeof(float));
        gZ[u1] = (float*)calloc(steps+1,sizeof(float));


        for (v1=0; v1 <= steps; v1++)
        {
            //gX[u1][v1] = (float*)calloc(1,sizeof(float));
            //gY[u1][v1] = (float*)calloc(1,sizeof(float));
            //gZ[u1][v1] = (float*)calloc(1,sizeof(float));

            //if(comp==0)
            {
                gX[u1][v1] = this->eval(u1*step1, v1*step1, 0);

                gY[u1][v1] = this->eval(u1*step1, v1*step1, 1);

                gZ[u1][v1] = this->eval(u1*step1, v1*step1, 2);
            }
            
        }
    }


    return;
}

std::vector<float*> BezierRectangle2::wireFrameEdges(int steps)
{
	return BezierRectangle2::wireFrame(steps);
}



std::vector<float*> BezierRectangle2::wireFrame(int steps)
{
	std::vector<float*> l;
	
	
    float *linePiece;

    
	linePiece = new float[6];
    	
    linePiece[0] = 0;
    linePiece[1] = 0;
    linePiece[2] = 0;
    linePiece[3] = 1;
    linePiece[4] = 1;
    linePiece[5] = 1;


    //l.push_back(linePiece);
    //return l;
    
    int ui,vi;

    this->BezierRectangle2::evalGrid(steps);


    // wireframe

    for (ui=0; ui< steps; ui++)
      {
        for (vi=0; vi< steps; vi++)
          {
           
            {//if(gX[i+1][j]!=0)
            	linePiece = new float[6];
            	
                linePiece[0] = gX[ui][vi];
                linePiece[1] = gY[ui][vi];
                linePiece[2] = gZ[ui][vi];
                linePiece[3] = gX[ui+1][vi];
                linePiece[4] = gY[ui+1][vi];
                linePiece[5] = gZ[ui+1][vi];

                l.push_back(linePiece);
            }

        	{   //if(gX[i][j+1]!=0)
            	
            	linePiece = new float[6];
            	
                linePiece[0] = gX[ui][vi];
                linePiece[1] = gY[ui][vi];
                linePiece[2] = gZ[ui][vi];
                linePiece[3] = gX[ui][vi+1];
                linePiece[4] = gY[ui][vi+1];
                linePiece[5] = gZ[ui][vi+1];

                l.push_back(linePiece);                
            }


          }
      }



    return l;

	
}


std::vector<float*> BezierRectangle2::getControlPoints()
{
	std::vector<float*> l;
	//std::vector<float*>::iterator iter;
	
	std::vector<Index::HyperIdx*>::iterator iter;
	std::vector<Index::HyperIdx*> v;
	
	Index::BezierIndex* p;
	
	Index::MultiIdx *degs,*dims;
	degs = new Index::MultiIdx(2);
	dims = new Index::MultiIdx(2);
	int i;
	for(i=0;i<2;i++)
	{
		degs->idx[i] = this->bspd->deg_v[i];
		dims->idx[i] = this->bspd->ddim_v[i];
	}
		
	
	v = Index::HyperIdx::getAllIndexes(degs,dims);
	
	
    i=0;

    {

    	for(iter=v.begin();iter!=v.end();iter++)
    	{
    		p = (Index::BezierIndex*) (*iter);
    		//((Index::HyperIdx*)p)->print(stderr);
    		l.push_back(this->BezierRectangle2::getControlPoint(p));
    		this->ind_vec[i] = (Index::HyperIdx*)p;
    		//this->ind_vec[i]->line[0]->print(stderr);
    		i++;
    		
    	}
	}

    return l;

}


float* BezierRectangle2::getLinePiece(int orig, int dest)
{
return NULL;
}


std::vector<float*> BezierRectangle2::controlNet()
{
	std::vector<BezierSimploid**> l;
	std::vector<float*> res;
	std::vector<BezierSimploid**>::iterator iter;
			
	float *linePiece;
		
	//return res;
		
		l = this->bspd->BezierSimploid::controlNet();
		for(iter=l.begin();iter!=l.end();iter++)
		{
			linePiece = (float*) calloc(6,sizeof(float));
			linePiece[0] = ((BezierPoint**)(*iter))[0]->data[0];
			linePiece[1] = ((BezierPoint**)(*iter))[0]->data[1];
			linePiece[2] = ((BezierPoint**)(*iter))[0]->data[2];
			linePiece[3] = ((BezierPoint**)(*iter))[1]->data[0];
			linePiece[4] = ((BezierPoint**)(*iter))[1]->data[1];
			linePiece[5] = ((BezierPoint**)(*iter))[1]->data[2];
			
			res.push_back(linePiece);
		}
		
	   
		    return res;
}

void BezierRectangle2::init(float spacing)
{
	
	int *ddim = new int[2];
	int *deg = new int[2];
	ddim[0]=1;
	ddim[1]=1;
	deg[0] = this->deg_u;
	deg[1] = this->deg_v;
	
	this->bspd = new BezierSimploid(2,ddim,3,deg);
	this->bspd->BezierSimploid::init(spacing);
}





BezierRectangle2::~BezierRectangle2()
{
}
