#include "BezierSimplex.h"
#include "BezierPoint.h"
#include "../../conversionV2/Index/MultiIdx.h"

BezierSimplex::BezierSimplex()
{
}

BezierSimplex::~BezierSimplex()
{

		int i;
		
		if(this->ddim==0)
			return;
		
		//this->ddim = ddim;
		//this->rdim = rdim;
		//this->deg = deg;
		
		//this->order= 1;
		free(this->ddim_v);
		free(this->deg_v);
			
		//this->ddim_v[0] = this->ddim;
		//this->deg_v[0] = this->deg;
		
		
		
		
		if(this->ddim==1)
		{
			//this->subsimplices = (BezierSimplex**) calloc(deg+1, sizeof(BezierSimplex*));
			for(i=0;i<this->deg+1;i++)
			{
					delete ((BezierPoint*)this->subsimplices[i]);
			}
			free(this->subsimplices);
			
			return;
		}
		
		
		for(i=0;i<this->deg+1;i++)
		{
			delete this->subsimplices[i];
		}
		free(this->subsimplices);
		
		return;
		

}

BezierSimplex::BezierSimplex(int ddim,int rdim, int deg)
{
	int i;
	
	this->ddim = ddim;
	this->rdim = rdim;
	this->deg = deg;
	
	this->order= 1;
	this->ddim_v = new int[1];
	this->deg_v = new int[1];
		
	this->ddim_v[0] = this->ddim;
	this->deg_v[0] = this->deg;
	
	
	if(ddim==1)
	{
		this->subsimplices = (BezierSimplex**) calloc(deg+1, sizeof(BezierSimplex*));
		for(i=0;i<deg+1;i++)
		{
				this->subsimplices[i] = (BezierSimplex*)new BezierPoint(rdim);
		}
		
		return;
	}
	
	this->subsimplices = (BezierSimplex**) calloc(deg+1, sizeof(BezierSimplex*));
	for(i=0;i<deg+1;i++)
	{
		this->subsimplices[i] = new BezierSimplex(ddim-1,rdim,i);
	}
	
	return;
	
}



BezierSimplex* BezierSimplex::getControl_Point(Index::BezierIndex *idx)
{
	BezierSimplex *res;
	
	if(this->ddim==1)
		return this->subsimplices[this->deg -idx->get(0)];
	
	
	Index::MultiIdx* newidx;
	
	newidx = (Index::MultiIdx*)idx->supressFirst();
		
	
	res = this->subsimplices[this->deg - idx->get(0)]->BezierSimplex::getControl_Point(newidx);
	
	return res;
}


void BezierSimplex::setControlPoint(Index::BezierIndex *idx, BezierSimplex* data)
{

	if(this->ddim==1)
	{
		this->subsimplices[this->deg - idx->get(0)] = data;
		
		return;
	}
	
	Index::MultiIdx* newidx;
	
	newidx = (Index::MultiIdx*)idx->supressFirst();
		
	
	this->subsimplices[this->deg - idx->get(0)]->BezierSimplex::setControlPoint(newidx,data);
	
}



BezierSimplex* BezierSimplex::blossom(double *simplexPoint)
{
	BezierSimplex* T = new BezierSimplex(this->ddim,this->rdim,this->deg-1);
	int i;

	BezierSimplex *bt,*bt2;
	BezierPoint *a;
	BezierPoint *b;
	
	
	//recursion basis
	if(this->ddim==1)
	{
		for(i=0;i <= T->deg ;i++)
		{
			a = ((BezierPoint*)this->subsimplices[i])->BezierPoint::times((simplexPoint[0]));
			b = ((BezierPoint*)this->subsimplices[i+1])->BezierPoint::times((simplexPoint[1]));
			
			delete T->subsimplices[i];
			
			T->subsimplices[i] = (BezierSimplex*) a->BezierPoint::add(b);
			
			//a and b not used anymore;
			delete a;
			delete b;
		}
		return T;
	}
	
	
	for(i=0;i <= T->deg ;i++)
	{
		bt = this->subsimplices[i+1]->BezierSimplex::blossom(simplexPoint);
		bt2 = this->subsimplices[i]->BezierSimplex::times(simplexPoint[this->ddim]);
		
		delete T->subsimplices[i];
		
		T->subsimplices[i] = bt2->BezierSimplex::add(bt);
		
		// bt and bt2 not used anymore
		delete bt2;
		delete bt;
		
	}
	return T;
	
}

BezierSimplex* BezierSimplex::times(double op)
{
	BezierSimplex* bt = new BezierSimplex(this->ddim,this->rdim,this->deg);
	int i,j;
	
	
	if(this->ddim==1)
	{
		for(j=0;j<this->deg+1;j++)
		{
			delete bt->subsimplices[j];
			
			bt->subsimplices[j] = (BezierPoint*) ((BezierPoint*)this->subsimplices[j])->times(op);
		}
		return bt;
	}
	
	
	for(i=0;i<=this->deg;i++)
	{
		delete bt->subsimplices[i];
		bt->subsimplices[i] = this->subsimplices[i]->BezierSimplex::times(op);  
	}
	
	return bt;
}

BezierSimplex* BezierSimplex::add(BezierSimplex* op)
{
	BezierSimplex* bt = new BezierSimplex(this->ddim,this->rdim,this->deg);
	int i,j;
	
	
	if(this->ddim==1)
	{
		for(j=0;j<this->deg+1;j++)
		{
			delete bt->subsimplices[j];
		
			bt->subsimplices[j] = (BezierPoint*) ((BezierPoint*)this->subsimplices[j])->add((BezierPoint*)op->subsimplices[j]);
		}
		return bt;
	}
	
	for(i=0;i<=this->deg;i++)
	{
		delete bt->subsimplices[i];
		bt->subsimplices[i] = this->subsimplices[i]->BezierSimplex::add(op->subsimplices[i]);  
	}
	
	return bt;
}


BezierSimplex* BezierSimplex::eval(double* simplexPoint)
{
	BezierSimplex *T,*Taux;
	
	BezierPoint* res;
	
	
	std::vector<Index::MultiIdx*> v;
	std::vector<Index::MultiIdx*>::iterator iter;
	Index::MultiIdx* idx;
	
	
	v = Index::MultiIdx::MultiIdx::getMultiIdxSet(0,this->ddim+1);
	iter = v.begin();
	idx = (*iter);
	
	T = this;
	int i;
	
	
	
	T= this->BezierSimplex::blossom(simplexPoint);
	
	for(i=1;i<this->deg;i++)
	{
		Taux = T->BezierSimplex::blossom(simplexPoint);
		
		//deallocate T;
		delete T;
		
		
		T=Taux;
			
	}
	
	res = ((BezierPoint*)T->BezierSimplex::getControl_Point(idx))->BezierPoint::clone();
	
	delete T;
	
	return  res;
		
}


std::vector<BezierSimplex**> BezierSimplex::controlNet()
{
	std::vector<BezierSimplex**> l;

	std::vector<Index::MultiIdx*> idx;
	std::vector<Index::MultiIdx*>::iterator iterIdx,iterIdx2;
		
	BezierSimplex **pair;
		
	Index::MultiIdx *midx;
	int far,i;
	int aux;
	
	idx = Index::MultiIdx::MultiIdx::getMultiIdxSet(this->deg,this->ddim+1);
	
	
	for(iterIdx=idx.begin();iterIdx!=idx.end();iterIdx++)
		for(iterIdx2=idx.begin();iterIdx2!=idx.end();iterIdx2++)				
		{
			midx = ((Index::MultiIdx*)(*iterIdx))->MultiIdx::sub((Index::MultiIdx*)(*iterIdx2));
			far=0;
			
			//midx->print(stderr);
							
			for(i=0;i<this->ddim+1;i++)
			{
				aux = midx->idx[i];
				if(( aux< -1)||(aux > 1))
					far=1;
			}
			if((midx->sum()==0)&&(!far))
			{
				pair = (BezierSimplex**) calloc(2,sizeof(BezierSimplex*));
				pair[0] = this->BezierSimplex::getControl_Point((Index::MultiIdx*)(*iterIdx));
				pair[1] = this->BezierSimplex::getControl_Point((Index::MultiIdx*)(*iterIdx2));
				l.push_back(pair);
								
			}
			
		}
	

	    return l;
	
}

std::vector<BezierSimplex*> BezierSimplex::getAllCPs()
{
	std::vector<BezierSimplex*> l;

	std::vector<Index::MultiIdx*> idx;
	std::vector<Index::MultiIdx*>::iterator iterIdx;
		
	BezierSimplex* bs;
	
	idx = Index::MultiIdx::MultiIdx::getMultiIdxSet(this->deg,this->ddim+1);
	
	
	for(iterIdx=idx.begin();iterIdx!=idx.end();iterIdx++)
	{
			bs = this->BezierSimplex::getControl_Point((Index::MultiIdx*)(*iterIdx));
			l.push_back(bs);
								
	}
			
	return l;
	
}

void BezierSimplex::translate(double *d)
{

	int j;
	
	std::vector<BezierSimplex*> l;
	std::vector<BezierSimplex*>::iterator i;
		
	l = this->BezierSimplex::getAllCPs();
	
	for(i=l.begin();i!=l.end();i++)
	{
		for(j=0;j<this->rdim;j++)
			((BezierPoint*)(*i))->data[j]+=d[j];
	}
	
	return;
	
}

void BezierSimplex::init(double spacing)
{
	int i;
	double *d = (double*) calloc(this->rdim,sizeof(double));
	
	if(this->rdim < this->ddim)
	{
		fprintf(stderr,"rdim > ddim --> usual initialization not valid\n");
		return;
	}
	
	
	if(this->ddim==1)
	{
		for(i=0;i<this->deg+1;i++)
		{
			d[0] = i*spacing;
			this->subsimplices[i]->translate(d);
		}
		
		return;
	}
	
	
	for(i=0;i<this->deg+1;i++)
	{
		d[this->ddim-1] = i*spacing;
		this->subsimplices[i]->init(spacing);
		this->subsimplices[i]->translate(d);

	}
	
	return;
}
