#ifndef BEZIERSIMPLEX_H_
#define BEZIERSIMPLEX_H_

#include "Bezier_Element.h"
#include <vector>
#include "../../conversionV2/Index/IndexedMatrix.h"
#include "BezierSimploid.h"


class BezierSimplex : public BezierSimploid
{
public:
	
	BezierSimplex** subsimplices;
	int deg;
	int ddim;
	int rdim;


	BezierSimplex();
	virtual ~BezierSimplex();
	
	
	BezierSimplex(int ddim, int rdim, int deg);
	
	
	std::vector<BezierSimplex**>  controlNet();
	std::vector<BezierSimplex*>  getAllCPs();
	
	BezierSimplex*  getControl_Point(Index::BezierIndex *idx);
	void  setControlPoint(Index::BezierIndex *idx, BezierSimplex* cp);
	
	
	BezierSimplex*  blossom(double *simplexPoint);
	virtual BezierSimplex*  times(double op);
	virtual BezierSimplex*  add(BezierSimplex* op);
	
	virtual void  translate(double *d);
	
	BezierSimplex*  eval(double* simplexPoint);
	
	
	void  init(double spacing);
	
};

#endif /*BEZIERSIMPLEX_H_*/
