#include "BezierSimploid.h"
#include "BezierSimplex.h"
#include "BezierPoint.h"
#include "../../conversionV2/Index/HyperIdx.h"
BezierSimploid::BezierSimploid()
{
	this->subsimploids = 0x0;
}

BezierSimploid::~BezierSimploid()
{
	// did not deallocate simple vectors
	
	
	if(this->subsimploids==0x0)//simplex
		return;
	
	int i;
	
	//this->order = order;
	//free(this->ddim_v);
	//this->rdim = rdim;
	//free(this->deg_v);
	
	
	//int *dimaux, *deg_vaux;
	
	//------------------------   same as BezierSimplex  -----------------------------------//
	if(order==1)
	{
		if(ddim_v[0]==1)
		{
			//this->subsimploids = (BezierSimploid**) calloc(deg_v[0]+1, sizeof(BezierSimploid*));
			for(i=0;i<deg_v[0]+1;i++)
			{
					delete ((BezierPoint*)this->subsimploids[i]);
			}
			
			free(this->subsimploids);
			return;
		}
		
		//this->subsimploids = (BezierSimploid**) calloc(deg_v[0]+1, sizeof(BezierSimploid*));
		for(i=0;i<deg_v[0]+1;i++)
		{
			delete ((BezierSimplex*)this->subsimploids[i]);
		}
		free(this->subsimploids);
		
		return;
	}
	//---------------------(end) same as BezierSimplex  -----------------------------------//
	
	
	
	if(ddim_v[0]==1)
	{
		//this->subsimploids = (BezierSimploid**)calloc(deg_v[0]+1,sizeof(BezierSimploid*));
		
		if(order==2)
		{
			
			
			for(i=0;i<deg_v[0]+1;i++)
			{
				delete ((BezierSimplex*)this->subsimploids[i]);
			}
			
			free(this->subsimploids);
			
			return;
		}
		
		if(order>2)
		{
			//dimaux = new int[order-1];
			//deg_vaux = new int[order-1];
						
			//for(j=1;j<order;j++)
			//{
			//	dimaux[j-1] = ddim_v[j];
			//	deg_vaux[j-1] = deg_v[j];
			//}
			
			//dimaux[0]--;
			
			for(i=0;i<deg_v[0]+1;i++)
			{
				//deg_vaux[0] = i;
				delete this->subsimploids[i];
			}
			
			free(this->subsimploids);
			
			return;
			
		}
		
	}
	
	//this->subsimploids = (BezierSimploid**)calloc(deg_v[0]+1,sizeof(BezierSimploid*));
	
	
	
	
	//dimaux = new int[order];
	//deg_vaux = new int[order];
				
	//for(j=0;i<order;j++)
	//{
	//	dimaux[j] = ddim_v[j];
	//	deg_vaux[j] = deg_v[j];
	//}
	
	//dimaux[0]--;
	
	for(i=0;i<deg_v[0]+1;i++)
	{
		//deg_vaux[0] = i;
		delete this->subsimploids[i];
	}
	

	free(this->subsimploids);
	
	
}

BezierSimploid::BezierSimploid(int order, int *ddim_v, int rdim, int *deg_v)
{
	int i,j;
	
	this->order = order;
	this->ddim_v = ddim_v;
	this->rdim = rdim;
	this->deg_v = deg_v;
	
	
	int *dimaux, *deg_vaux;
	
	//------------------------   same as BezierSimplex  -----------------------------------//
	if(order==1)
	{
		if(ddim_v[0]==1)
		{
			this->subsimploids = (BezierSimploid**) calloc(deg_v[0]+1, sizeof(BezierSimploid*));
			for(i=0;i<deg_v[0]+1;i++)
			{
					this->subsimploids[i] = (BezierSimploid*)new BezierPoint(rdim);
			}
			
			return;
		}
		
		this->subsimploids = (BezierSimploid**) calloc(deg_v[0]+1, sizeof(BezierSimploid*));
		for(i=0;i<deg_v[0]+1;i++)
		{
			this->subsimploids[i] = (BezierSimploid*)new BezierSimplex(ddim_v[0]-1,rdim,i);
		}
		
		return;
	}
	//---------------------(end) same as BezierSimplex  -----------------------------------//
	
	
	
	if(ddim_v[0]==1)
	{
		this->subsimploids = (BezierSimploid**)calloc(deg_v[0]+1,sizeof(BezierSimploid*));
		
		if(order==2)
		{
			
			
			for(i=0;i<deg_v[0]+1;i++)
			{
				this->subsimploids[i] = (BezierSimploid*) new BezierSimplex(ddim_v[1],rdim,deg_v[1]);
			}
			
			return;
		}
		
		if(order>2)
		{
			dimaux = new int[order-1];
			deg_vaux = new int[order-1];
						
			for(j=1;j<order;j++)
			{
				dimaux[j-1] = ddim_v[j];
				deg_vaux[j-1] = deg_v[j];
			}
			
			//dimaux[0]--;
			
			for(i=0;i<deg_v[0]+1;i++)
			{
				//deg_vaux[0] = i;
				this->subsimploids[i] = (BezierSimploid*) new BezierSimploid(order-1,dimaux,rdim,deg_vaux);
			}
			
			return;
			
		}
		
	}
	
	this->subsimploids = (BezierSimploid**)calloc(deg_v[0]+1,sizeof(BezierSimploid*));
	
	
	
	
	dimaux = new int[order];
	deg_vaux = new int[order];
				
	for(j=0;i<order;j++)
	{
		dimaux[j] = ddim_v[j];
		deg_vaux[j] = deg_v[j];
	}
	
	dimaux[0]--;
	
	for(i=0;i<deg_v[0]+1;i++)
	{
		deg_vaux[0] = i;
		this->subsimploids[i] = (BezierSimploid*) new BezierSimploid(order,dimaux,rdim,deg_vaux);
	}
	

	
}



BezierSimploid* BezierSimploid::getControl_Point(Index::BezierIndex *idx)
{
	Index::HyperIdx *newidx;
	Index::MultiIdx *midx;
		
	newidx =(Index::HyperIdx*)idx; 
	//newidx->print(stderr);
	midx = (newidx)->line[0];
	
	int i;
	
	if(this->order==1)//simplex
	{
		newidx = ((Index::HyperIdx*)idx)->supressFirst();
		
		
		return (BezierSimploid*) ((BezierSimplex*)this)->BezierSimplex::getControl_Point(midx);
		
	}
	
	i = this->deg_v[0] - midx->idx[0];
	
	if(this->ddim_v[0]>1)
		newidx = ((Index::HyperIdx*)idx)->HyperIdx::supressFirstElement();
	else
		newidx = ((Index::HyperIdx*)idx)->HyperIdx::supressFirst();
	
	return this->subsimploids[i]->BezierSimploid::getControl_Point((Index::BezierIndex*)newidx);
	
	
	
}


void BezierSimploid::setControlPoint(Index::BezierIndex *idx, BezierSimploid* data)
{
	Index::HyperIdx *newidx;
	Index::MultiIdx *midx, *newmidx;

	
	midx = ((Index::HyperIdx*)idx)->line[0];
	int i;
	
	if(this->order==1)//simplex
	{
		newidx = (Index::HyperIdx*)idx->supressFirst();
		if(this->ddim_v[0]==1)
		{
			this->subsimploids[this->deg_v[0] - midx->idx[0]] = data;
		}
		
		newmidx = (Index::MultiIdx*)midx->supressFirst();
		
		((BezierSimplex*)this->subsimploids[this->deg_v[0] - midx->idx[0]])->BezierSimplex::setControlPoint(newmidx,(BezierSimplex*)data);
		
	}
	i = this->deg_v[0] - midx->idx[0];
	
	newidx = ((Index::HyperIdx*)idx)->HyperIdx::supressFirstElement();
	
	this->subsimploids[i]->BezierSimploid::setControlPoint((Index::BezierIndex*)newidx,data);
	

}



BezierSimploid* BezierSimploid::blossom(double **simploidPoint)
{
	int *newdeg_v;
	int i;
	BezierSimploid* T ;
	BezierSimploid *spda,*spdb,*spdaa,*spdbb;
	BezierSimplex *a,*aa,*b,*bb;
	
	
	newdeg_v = new int[this->order];
	
	for(i=0;i < this->order;i++)
		newdeg_v[i] = this->deg_v[i]-1;
	
	
	T= new BezierSimploid(this->order,this->ddim_v,this->rdim,newdeg_v);
	
	//recursion basis
	if(this->order==1)
	{
		delete T;
		return (BezierSimploid*) ((BezierSimplex*)this)->BezierSimplex::blossom(simploidPoint[0]);
	}

	
	
	//recursion 2nd basis
	if(this->ddim_v[0]==1)
	{
		if(this->order==2)
		{
			for(i=0;i <= T->deg_v[0] ;i++)
			{
				a = ((BezierSimplex*)this->subsimploids[i])->BezierSimplex::blossom(simploidPoint[1]);
				b = ((BezierSimplex*)this->subsimploids[i+1])->BezierSimplex::blossom(simploidPoint[1]);
				
				aa = a->BezierSimplex::times(simploidPoint[0][0]);
				bb = b->BezierSimplex::times(simploidPoint[0][1]);
							
				delete T->subsimploids[i];
				T->subsimploids[i] = (BezierSimploid*) aa->BezierSimplex::add(bb);
				
				delete ((BezierSimplex*)a);
				delete ((BezierSimplex*)b);
				delete ((BezierSimplex*)aa);
				delete ((BezierSimplex*)bb);
			}
			return T;
		}
		
		if(this->order>2)
		{
			for(i=0;i <= T->deg_v[0] ;i++)
			{
				spda = this->subsimploids[i]->BezierSimploid::blossom(&(simploidPoint[1]));
				spdb = this->subsimploids[i+1]->BezierSimploid::blossom(&(simploidPoint[1]));
				
				spdaa = spda->BezierSimploid::times(simploidPoint[0][0]);
				spdbb = spdb->BezierSimploid::times(simploidPoint[0][1]);
				
				delete T->subsimploids[i];
				T->subsimploids[i] = (BezierSimploid*) spdaa->BezierSimploid::add(spdbb);
				
				delete spda;
				delete spdb;
				delete spdaa;
				delete spdbb;
				
			}
			return T;
		}
	}// end of ''ddim_v[0]==1''
	
	
	for(i=0;i <= T->deg_v[0] ;i++)
	{
		spda = this->subsimploids[i+1]->BezierSimploid::blossom(&(simploidPoint[1]));
		
		spdb = this->subsimploids[i]->BezierSimploid::times(simploidPoint[0][this->ddim_v[0]]);
		
		delete T->subsimploids[i];
		T->subsimploids[i] = spdb->BezierSimploid::add(spda);
		
		delete spda;
		delete spdb;
		
	}
	return T;
	
}

BezierSimploid* BezierSimploid::times(double op)
{
	
	BezierSimploid* bt = new BezierSimploid(this->order,this->ddim_v,this->rdim,this->deg_v);
	
	int i;
	
	if(this->order==1)
	{
		delete bt;
		return (BezierSimploid*) ((BezierSimplex*)this)->BezierSimplex::times(op);
	}
	
	for(i=0;i<deg_v[0]+1;i++)
	{
		delete bt->subsimploids[i];
		bt->subsimploids[i] = (BezierSimploid*) this->subsimploids[i]->BezierSimploid::times(op);
	}
	
	return bt;
}


BezierSimploid* BezierSimploid::add(BezierSimploid* op)
{
	
	BezierSimploid* bt = new BezierSimploid(this->order,this->ddim_v,this->rdim,this->deg_v);
	
	int i;
	
	if(this->order==1)
	{
		delete bt;
		return (BezierSimploid*) ((BezierSimplex*)this)->BezierSimplex::add((BezierSimplex*)op);
	}

	
	for(i=0;i<deg_v[0]+1;i++)
	{
		delete bt->subsimploids[i];
		bt->subsimploids[i] = (BezierSimploid*) this->subsimploids[i]->BezierSimploid::add(op->subsimploids[i]);
	}
	
	return bt;
}

BezierSimploid* BezierSimploid::eval(double** simploidPoint)
{
	BezierSimploid *T;
	BezierSimploid *Taux;
	
	BezierPoint* res;
	
		
	Index::HyperIdx* idx;
	
	
	idx = Index::HyperIdx::HyperIdx::getZeroHyperIdx(this->order,this->ddim_v);
	
	T = this;
	int i;
	
	T = this->BezierSimploid::blossom(simploidPoint);
	
	
	for(i=1;i<this->deg_v[0];i++)
	{
		Taux = T->BezierSimploid::blossom(simploidPoint);
			
		//deallocate T;
		delete T;		
		T=Taux;

	}
	
	
	res = ((BezierPoint*)T->BezierSimploid::getControl_Point((Index::BezierIndex*)idx))->BezierPoint::clone();	
	
	delete T;
		
	return  res;
		
}


std::vector<BezierSimploid**> BezierSimploid::controlNet()
{
	std::vector<BezierSimploid**> l;
	Index::MultiIdx *deg_vs,*dims;


	std::vector<Index::HyperIdx*> idx,hvec;
	std::vector<Index::HyperIdx*>::iterator iterIdx,iterIdx2;
		
	BezierSimploid **pair;
			
		Index::HyperIdx *midx;
		
		int far,farfar,i,j;
		int aux;
		
	
	
		deg_vs = new Index::MultiIdx(this->order);
		dims = new Index::MultiIdx(this->order);
			
		for(i=0;i<this->order;i++)
		{
			deg_vs->idx[i] = this->deg_v[i];
			dims->idx[i] = this->ddim_v[i];
		}
		
		hvec = Index::HyperIdx::getAllIndexes(deg_vs,dims);
	

		
		for(iterIdx=hvec.begin();iterIdx!=hvec.end();iterIdx++)
			for(iterIdx2=hvec.begin();iterIdx2!=hvec.end();iterIdx2++)				
			{
				midx = ((Index::HyperIdx*)(*iterIdx))->HyperIdx::sub((Index::HyperIdx*)(*iterIdx2));
				far=0;
				farfar=-1;
				
				//midx->print(stderr);
				
				
				for(j=0;j<midx->n_rows;j++)
				{
					for(i=0;i<this->ddim_v[j]+1;i++)
					{
						aux = midx->line[j]->idx[i];
						if(( aux< -1)||(aux > 1))
							far=1;
						
						if((aux!=0))
							if(farfar==-1)
								farfar=j;
							else
								{
									if(farfar!=j)
										far=1;
								}
					}
				}
				if((midx->sum()==0)&&(!far))
				{
					pair = (BezierSimploid**) calloc(2,sizeof(BezierSimploid*));
					pair[0] = this->BezierSimploid::getControl_Point((Index::BezierIndex*)(*iterIdx));
					pair[1] = this->BezierSimploid::getControl_Point((Index::BezierIndex*)(*iterIdx2));
					l.push_back(pair);
									
				}
				
			}
		

		    return l;
	
}

std::vector<BezierSimploid*> BezierSimploid::getAllCPs()
{
	std::vector<BezierSimploid*> l;
	
	std::vector<Index::HyperIdx*> hvec;
	std::vector<Index::HyperIdx*>::iterator iter;
		
	
	BezierSimploid* cp;
	Index::HyperIdx* hidx;
	int i;

	Index::MultiIdx *deg_vs,*dims;
	
	deg_vs = new Index::MultiIdx(this->order);
	dims = new Index::MultiIdx(this->order);
		
	for(i=0;i<this->order;i++)
	{
		deg_vs->idx[i] = this->deg_v[i];
		dims->idx[i] = this->ddim_v[i];
	}
	
	hvec = Index::HyperIdx::getAllIndexes(deg_vs,dims);
	
	for(iter=hvec.begin();iter!=hvec.end();iter++)
	{
		hidx = (Index::HyperIdx*) *iter;
		cp = this->BezierSimploid::getControl_Point((Index::BezierIndex*)hidx);
		
		l.push_back(cp);
	}
	
			
	return l;
	
}

void BezierSimploid::translate(double *d)
{

	int j;
	
	std::vector<BezierSimploid*> l;
	std::vector<BezierSimploid*>::iterator i;
		
	l = this->BezierSimploid::getAllCPs();
	
	for(i=l.begin();i!=l.end();i++)
	{
		for(j=0;j<this->rdim;j++)
			((BezierPoint*)(*i))->data[j]+=d[j];
	}
	
	return;
	
}

void BezierSimploid::init(double spacing)
{
	int i;
	double *d = (double*) calloc(this->rdim,sizeof(double));
	
	int total_ddim_v = 0;
	
	for(i=0;i<this->order;i++)
		total_ddim_v += this->ddim_v[i];
	
	
	if(this->rdim < total_ddim_v)
	{
		fprintf(stderr,"rdim > ddim_v --> usual initialization not valid\n");
		return;
	}
	
	
	if(this->order==1)
	{
		((BezierSimplex*)this)->BezierSimplex::init(spacing);
		return;
	}
	
	if(this->ddim_v[0]==1)
	{
		if(this->order==2)
		{
			for(i=0;i<this->deg_v[0]+1;i++)
			{
				d[this->ddim_v[1]] = i*spacing;
				((BezierSimplex*)this->subsimploids[i])->BezierSimplex::init(spacing);
				((BezierSimplex*)this->subsimploids[i])->BezierSimplex::translate(d);
			}
			
			return;
		}
		
		if(this->order>2)
		{
			for(i=0;i<this->deg_v[0]+1;i++)
			{
				d[2] = i*spacing;
				(this->subsimploids[i])->BezierSimploid::init(spacing);
				(this->subsimploids[i])->BezierSimploid::translate(d);
			}
		
			return;
			
		}		
		
	}//end of dim[0]==1
	
	
	
}
