#ifndef BEZIERSIMPLOID_H_
#define BEZIERSIMPLOID_H_

#include <vector>
#include "../../conversionV2/Index/IndexedMatrix.h"


class BezierSimploid
{
public:

	BezierSimploid** subsimploids;
	int order;
	int *deg_v;
	int *ddim_v;
	int rdim;


	BezierSimploid();
	virtual ~BezierSimploid();
	
	
	BezierSimploid(int order, int *ddim_v, int rdim, int *deg_v);
	
	
	std::vector<BezierSimploid**>  controlNet();
	std::vector<BezierSimploid*>  getAllCPs();
	
	BezierSimploid*  getControl_Point(Index::BezierIndex *idx);
	void  setControlPoint(Index::BezierIndex *idx, BezierSimploid* cp);
	
	
	BezierSimploid*  blossom(double **simploidPoint);
	virtual BezierSimploid*  times(double op);
	virtual BezierSimploid*  add(BezierSimploid* op);
	
	virtual void  translate(double *d);
	
	BezierSimploid*  eval(double **simploidPoint);
	
	
	void  init(double spacing);
	
	
	
};

#endif /*BEZIERSIMPLOID_H_*/
