#include "BezierTetrahedron.h"




	void BezierTetrahedron::stepZ(float step)
	{
		int i;
		for(i=0;i<this->deg+1;i++)
			this->tri[i]->BezierTriangle::stepZ(step);
	}


void BezierTetrahedron::fromBezierCube(Index::IndexedMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}



float* BezierTetrahedron::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
	
	Index::MultiIdx* newidx;
	
	//if((idx->sum()!= this->deg))
		//return 0x0;
	
	
	//res = (float*) calloc(3,sizeof(float));
	//((Index::MultiIdx*)idx)->MultiIdx::print(stderr);
	
	
	newidx = (Index::MultiIdx*)idx->supressFirst();
	//((Index::MultiIdx*)newidx)->MultiIdx::print(stderr);
		
	
	res = this->tri[this->deg - idx->get(0)]->BezierTriangle::getControlPoint(newidx);
	
	return res;
}

void BezierTetrahedron::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	//if((idx->sum()!= this->deg))
	//	return;
	
	
	this->tri[this->deg - idx->get(0)]->BezierTriangle::setControlPoint(
			idx->supressFirst(),
			x,y,z);
	
	return;
}












int BezierTetrahedron::getOrder()
{
	return 1;
}
	
int* BezierTetrahedron::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(1,sizeof(int));
	
	dim[0] = 3;
	
	return dim;
}
	
int* BezierTetrahedron::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(1,sizeof(int));
	
	deg[0] = this->deg;
	
	return deg;
}








int BezierTetrahedron::getN()
{
	return this->n;
}



void BezierTetrahedron::init(float spacing)
{
	int i;
	
	for(i=0;i< this->deg+1;i++)
	{
		this->tri[i]->init(spacing);
		this->tri[i]->stepZ(-1*spacing*i);
	}
	
}
	
	


BezierTetrahedron::BezierTetrahedron(int deg)
{
	this->deg = deg;
	this->tri = (BezierTriangle**) calloc(deg+1, sizeof(BezierTriangle*));
	int i;
	
	this->n = 0;
	
	for(i=0;i< deg+1;i++)
	{
		this->tri[i] = new BezierTriangle(i);
		this->n = this->n + this->tri[i]->n;
	}
	
	
	this->ind_vec = (Index::MultiIdx**) calloc(this->n,sizeof(Index::MultiIdx*));
	
	
	
}

//////// No INIT!!!!!!!

BezierTetrahedron::BezierTetrahedron(int deg,int op)
{
	this->deg = deg;
	this->tri = (BezierTriangle**) calloc(deg+1, sizeof(BezierTriangle*));
	
	int i;
		
		this->n = 0;
		
		for(i=0;i< deg+1;i++)
		{
			this->n = this->n + (new BezierTriangle(i))->n;
		}
	
	
}

BezierTetrahedron::~BezierTetrahedron()
{
}


BezierTetrahedron* BezierTetrahedron::blossom(float u, float v, float w, float x)
{
	BezierTetrahedron* T = new BezierTetrahedron(this->deg-1,1);
	int i;
		
	//for(i=0;i<this->deg;i++)
	//	T->tri[i] = this->tri[i];
	
	
	BezierTriangle *bt;
	
	for(i=0;i <= T->deg ;i++)
	{
		bt = this->tri[i+1]->BezierTriangle::blossom(u,v,w);
		T->tri[i] = this->tri[i]->BezierTriangle::times(x);
		T->tri[i] = T->tri[i]->BezierTriangle::add(bt);
		
	}
	return T;
	
}


double BezierTetrahedron::evalV2(double u, double v, double w, double x, int coord)
{
	BezierTetrahedron* T;
	
	T = this;
	int i;
	
	for(i=0;i<this->deg;i++)
	{
		T = T->BezierTetrahedron::blossom(u,v,w,x);

			
	}
	
	
	if(coord==0)
		return  T->tri[0]->c[0]->X[0];
	
	if(coord==1)
		return T->tri[0]->c[0]->Y[0];
	
	return T->tri[0]->c[0]->Z[0];
		
}




float* BezierTetrahedron::getLinePiece(int orig, int dest)
{
	float *linePiece;


	linePiece = new float[6];
	

    
    return linePiece;
}


void BezierTetrahedron::updControlPoints(int j, float x, float y, float z)
{

	/*
    int i;
    for(i=0;i<this->deg+1;i++)
    {
    	if(j < this->tri[i]->n)
    	{
    		this->tri[i]->X[j] = x;
    		this->tri[i]->Y[j] = y;
    		this->tri[i]->Z[j] = z;
    		    		
    		return;
    	}
    	else
    	{
    		j = j- this->tri[i]->n;
    	}
	}
	*/
	
    this->BezierTetrahedron::setControlPoint(this->ind_vec[j],x,y,z);

    return;
	

    return;

	
}

std::vector<float*> BezierTetrahedron::controlNet()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
		
	float *linePiece;
	
	
    int i,j,k;
    for(i=0;i< this->deg;i++)
    {
    	
    	laux = this->tri[i]->BezierTriangle::controlNet();
    	
    	//this->tri[i]->BezierTriangle::loadCurves();
    	//this->tri[i+1]->BezierTriangle::loadCurves();
    	    	
    	
    	
    	for(j=0;j <= this->tri[i]->deg; j++)
    		for(k=0; k <= this->tri[i]->c[j]->deg; k++)
    		{
    			linePiece = new float[6];
    			linePiece[0] = this->tri[i]->c[j]->X[k];
    			linePiece[1] = this->tri[i]->c[j]->Y[k];
    			linePiece[2] = this->tri[i]->c[j]->Z[k];
    			
    			linePiece[3] = this->tri[i+1]->c[j]->X[k];
    			linePiece[4] = this->tri[i+1]->c[j]->Y[k];
    			linePiece[5] = this->tri[i+1]->c[j]->Z[k];
    		
    			laux.push_back(linePiece);
    			
    			linePiece = new float[6];
    			linePiece[0] = this->tri[i]->c[j]->X[k];
    			linePiece[1] = this->tri[i]->c[j]->Y[k];
    			linePiece[2] = this->tri[i]->c[j]->Z[k];
    			
    			linePiece[3] = this->tri[i+1]->c[j+1]->X[k+1];
    			linePiece[4] = this->tri[i+1]->c[j+1]->Y[k+1];
    			linePiece[5] = this->tri[i+1]->c[j+1]->Z[k+1];
    			    		
    			laux.push_back(linePiece);
    			
    			
    			
    			linePiece = new float[6];
    			linePiece[0] = this->tri[i]->c[j]->X[k];
    			linePiece[1] = this->tri[i]->c[j]->Y[k];
    			linePiece[2] = this->tri[i]->c[j]->Z[k];
    			
    			linePiece[3] = this->tri[i+1]->c[j+1]->X[k];
    			linePiece[4] = this->tri[i+1]->c[j+1]->Y[k];
    			linePiece[5] = this->tri[i+1]->c[j+1]->Z[k];
    			
    			laux.push_back(linePiece);
    						
    		}
    	
    	
    	for(iter=laux.begin();iter!=laux.end();iter++)
    		l.push_back(*iter);
	}
    
    
    laux = this->tri[this->deg]->BezierTriangle::controlNet();
    for(iter=laux.begin();iter!=laux.end();iter++)
        		l.push_back(*iter);
    

	    return l;
}



/*
std::vector<float*> BezierTetrahedron::getControlPoints()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
	
    int i;
    for(i=0;i<this->deg+1;i++)
    {
    	laux = this->tri[i]->BezierTriangle::getControlPoints();
    	for(iter=laux.begin();iter!=laux.end();iter++)
    		l.push_back(*iter);
	}

    return l;

	
}
*/
std::vector<float*> BezierTetrahedron::getControlPoints()
{
	std::vector<float*> l;
	//std::vector<float*>::iterator iter;
	
	std::vector<Index::MultiIdx*>::iterator iter;
	std::vector<Index::MultiIdx*> v;
	
	Index::MultiIdx *p,*q;
	
	v = Index::MultiIdx::MultiIdx::getMultiIdxSet(this->deg,4);
	
	
    int i=0;
    //for(i=0;i<this->deg+1;i++)
    {
    	//laux = this->c[i]->BezierCurve::getControlPoints();
    	for(iter=v.begin();iter!=v.end();iter++)
    	{
    		p = (Index::MultiIdx*) (*iter);
    		q = (Index::MultiIdx*) p->supressFirst();
    		
    		l.push_back(this->tri[this->deg - p->get(0)]->BezierTriangle::getControlPoint(q));
    		this->ind_vec[i] = p;
    		i++;
    		
    	}
	}

    return l;
	
}

void BezierTetrahedron::evalGrid(int steps)
{
	int v1=0;
    int u1=0;
    int w1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float****)calloc(steps+1,sizeof(float***)) ;
    gY = (float****)calloc(steps+1,sizeof(float***)) ;
    gZ = (float****)calloc(steps+1,sizeof(float***)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float***)calloc(steps-u1+1,sizeof(float**));
        gY[u1] = (float***)calloc(steps-u1+1,sizeof(float**));
        gZ[u1] = (float***)calloc(steps-u1+1,sizeof(float**));


        for (v1=0; v1 <= steps-u1; v1++)
        {
            gX[u1][v1] = (float**)calloc(steps-u1-v1+1,sizeof(float*));
            gY[u1][v1] = (float**)calloc(steps-u1-v1+1,sizeof(float*));
            gZ[u1][v1] = (float**)calloc(steps-u1-v1+1,sizeof(float*));

            
            for(w1=0; w1 <= steps-u1-v1; w1++)
            {
                gX[u1][v1][w1] = (float*)calloc(1,sizeof(float));
                gY[u1][v1][w1] = (float*)calloc(1,sizeof(float));
                gZ[u1][v1][w1] = (float*)calloc(1,sizeof(float));
            
            	
            
	            //for(x1=0; x1 <= steps-u1-v1-w1; x1++)
	            {
	                gX[u1][v1][w1][0] = this->evalV2(u1*step1, v1*step1, w1*step1,(1- u1*step1- v1*step1- w1*step1), 0);
	
	                gY[u1][v1][w1][0] = this->evalV2(u1*step1, v1*step1, w1*step1,(1- u1*step1- v1*step1- w1*step1), 1);
	
	                gZ[u1][v1][w1][0] = this->evalV2(u1*step1, v1*step1, w1*step1,(1- u1*step1- v1*step1- w1*step1), 2);
	                
	                
                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
                    //		gX[u1][v1][w1][0],gY[u1][v1][w1][0],gZ[u1][v1][w1][0],
                    //		gX[u1][v1][w1][0],gY[u1][v1][w1][0],gZ[u1][v1][w1][0]);
	                
	            }
            }
        }
    }


    return;
}

std::vector<float*> BezierTetrahedron::wireFrameEdges(int steps)
{
	return BezierTetrahedron::wireFrame(steps);
}



std::vector<float*> BezierTetrahedron::wireFrame(int steps)
{
	std::vector<float*> l;
	
    float *linePiece;

    int hy;
    
    int ui,vi,wi,xi;

    this->evalGrid(steps);


    // wireframe

    for (ui=0; ui< steps; ui++)
      {
        for (vi=0; vi< steps - ui; vi++)
          {
            for (wi=0; wi< steps -ui -vi; wi++)
            {
            	//if(xi == (steps - ui - vi - wi))
            	//for (xi=0; xi< steps -ui -vi -wi; xi++)
	            
	            	xi = 0;
	                if (ui < steps )
	                {//if(gX[i+1][j]!=0)
	                	linePiece = new float[6];
	                	
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui+1][vi][wi][xi];
	                    linePiece[4] = gY[ui+1][vi][wi][xi];
	                    linePiece[5] = gZ[ui+1][vi][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	
	                if (vi < steps - ui)
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui][vi+1][wi][xi];
	                    linePiece[4] = gY[ui][vi+1][wi][xi];
	                    linePiece[5] = gZ[ui][vi+1][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	
	                if (wi < steps - ui)
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui][vi][wi+1][xi];
	                    linePiece[4] = gY[ui][vi][wi+1][xi];
	                    linePiece[5] = gZ[ui][vi][wi+1][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	                
	                
	                if (vi >0)
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui+1][vi-1][wi][xi];
	                    linePiece[4] = gY[ui+1][vi-1][wi][xi];
	                    linePiece[5] = gZ[ui+1][vi-1][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                    
	                }
	
	                if (wi >0)
		                {   //if(gX[i][j+1]!=0)
		                	
		                	linePiece = new float[6];
		                	
		                    linePiece[0] = gX[ui][vi][wi][xi];
		                    linePiece[1] = gY[ui][vi][wi][xi];
		                    linePiece[2] = gZ[ui][vi][wi][xi];
		                    linePiece[3] = gX[ui+1][vi][wi-1][xi];
		                    linePiece[4] = gY[ui+1][vi][wi-1][xi];
		                    linePiece[5] = gZ[ui+1][vi][wi-1][xi];
		
		                    l.push_back(linePiece);
		                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
		                    //		linePiece[0],linePiece[1],linePiece[2],
		                    //		linePiece[3],linePiece[4],linePiece[5]);
		                    
		                }
	                

	                if (wi >0)
		                {   //if(gX[i][j+1]!=0)
		                	
		                	linePiece = new float[6];
		                	
		                    linePiece[0] = gX[ui][vi][wi][xi];
		                    linePiece[1] = gY[ui][vi][wi][xi];
		                    linePiece[2] = gZ[ui][vi][wi][xi];
		                    linePiece[3] = gX[ui][vi+1][wi-1][xi];
		                    linePiece[4] = gY[ui][vi+1][wi-1][xi];
		                    linePiece[5] = gZ[ui][vi+1][wi-1][xi];
		
		                    l.push_back(linePiece);
		                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
		                    //		linePiece[0],linePiece[1],linePiece[2],
		                    //		linePiece[3],linePiece[4],linePiece[5]);
		                    
		                }
	                
	                
	            
            }


          }
      }


    hy=93;

    return l;

	
}

