#ifndef BEZIERTETRAHEDRON_H_
#define BEZIERTETRAHEDRON_H_

#include "Bezier_Element.h"
#include "BezierTriangle.h"

class BezierTetrahedron : public Bezier_Element
{
public:
	
	BezierTriangle **tri;
	int deg;
	int n;
	
	float ****gX,****gY,****gZ;
	
	Index::MultiIdx **ind_vec;
	
	
	
	void  stepZ(float step);
	

	void  fromBezierCube(Index::IndexedMatrix *m, Bezier_Element *bt);
	
	
	
	
	
	void  setControlPoint(Index::BezierIndex *idx, float x, float y, float z);

	float*  getControlPoint(Index::BezierIndex *idx);
	
	
	 int  getOrder();
	
	 int*  getDimensions();
	
	 int*  getDegrees();
	
	
	
	
	
	
	 int  getN();
	
	
	 BezierTetrahedron(int deg,int op);
	BezierTetrahedron(int deg);
		
	
	void  updControlPoints(int i, float x, float y, float z);
	BezierTetrahedron*  blossom(float u, float v, float w, float x);
	double  evalV2(double u, double v, double w, double x, int coord);
	std::vector<float*>  wireFrame(int steps);
	std::vector<float*>  wireFrameEdges(int steps);	
	std::vector<float*>  getControlPoints();
	
	
	std::vector<float*>  controlNet();
		
	
	void  init(float spacing);
	
	
	double  eval(double u, double v, double w, double x,int coord);
	void  evalGrid(int steps);
	
	float*  getLinePiece(int orig, int dest);
	
	virtual ~BezierTetrahedron();
};

#endif /*BEZIERTETRAHEDRON_H_*/
