#include "BezierTetrahedron2.h"
#include "BezierPoint.h"




void BezierTetrahedron2::stepZ(float step)
{
	double *d = (double*) calloc(3,sizeof(double));
	d[0] = 0;
	d[1] = 0;
	d[2] = step;
	this->bs->BezierSimplex::translate(d);
}


void BezierTetrahedron2::fromBezierCube(Index::IndexedMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}



float* BezierTetrahedron2::getControlPoint(Index::BezierIndex *idx)
{
	
	
	float *res;
	
	BezierPoint* bp;
	
	bp = (BezierPoint*) this->bs->BezierSimplex::getControl_Point(idx);

	res = (float*) calloc(3,sizeof(float));
	
	
	res[0] = bp->data[0];
	res[1] = bp->data[1];
	res[2] = bp->data[2];
	
	return res;
	
}


void BezierTetrahedron2::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	double *data = (double*) calloc(3,sizeof(double));
	
	data[0] = x;
	data[1] = y;
	data[2] = z;
	
	((BezierPoint*) (this->bs->BezierSimplex::getControl_Point(idx) ) )->BezierPoint::setData(data);
	
	return;
}







int BezierTetrahedron2::getOrder()
{
	return 1;
}
	
int* BezierTetrahedron2::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(1,sizeof(int));
	
	dim[0] = 3;
	
	return dim;
}
	
int* BezierTetrahedron2::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(1,sizeof(int));
	
	deg[0] = this->deg;
	
	return deg;
}








int BezierTetrahedron2::getN()
{
	return this->n;
}



void BezierTetrahedron2::init(float spacing)
{
	this->bs = new BezierSimplex(3,3,this->deg);
	this->bs->BezierSimplex::init(spacing);
	
}
	
	


BezierTetrahedron2::BezierTetrahedron2(int deg)
{
	int nsum=0;
	int i;
	
	for(i=0;i<deg+1;i++)
		nsum = nsum + (i+2)*(i+1)/2;
	
	this->n = nsum;
	this->deg = deg;
	
	
	this->ind_vec = (Index::MultiIdx**) calloc(this->n,sizeof(Index::MultiIdx*));
	
	
	
}

//////// No INIT!!!!!!!


BezierTetrahedron2::~BezierTetrahedron2()
{
}


BezierTetrahedron2* BezierTetrahedron2::blossom(float u, float v, float w, float x)
{
	
	BezierTetrahedron2* bt2 = new BezierTetrahedron2(this->deg-1);
	
	double* point = (double*) calloc(4,sizeof(double));
	point[0] = u;
	point[1] = v;
	point[2] = w;
	point[3] = x;
	
	bt2->bs = this->bs->BezierSimplex::blossom(point);
	
	return bt2;
	
	
}


double BezierTetrahedron2::evalV2(double u, double v, double w, double x, int coord)
{
	BezierPoint* bp;
	double* point = (double*) calloc(4,sizeof(double));
		point[0] = u;
		point[1] = v;
		point[2] = w;
		point[3] = x;
		
		bp = (BezierPoint*) this->bs->BezierSimplex::eval(point);
		
		return bp->data[coord];
		
}





void BezierTetrahedron2::updControlPoints(int j, float x, float y, float z)
{

	
    this->BezierTetrahedron2::setControlPoint(this->ind_vec[j],x,y,z);

    return;
	

    return;

	
}

std::vector<float*> BezierTetrahedron2::controlNet()
{
	std::vector<BezierSimplex**> l;
	std::vector<float*> res;
	std::vector<BezierSimplex**>::iterator iter;
		
	float *linePiece;
	
	
	l = this->bs->BezierSimplex::controlNet();
	for(iter=l.begin();iter!=l.end();iter++)
	{
		linePiece = (float*) calloc(6,sizeof(float));
		linePiece[0] = ((BezierPoint**)(*iter))[0]->data[0];
		linePiece[1] = ((BezierPoint**)(*iter))[0]->data[1];
		linePiece[2] = ((BezierPoint**)(*iter))[0]->data[2];
		linePiece[3] = ((BezierPoint**)(*iter))[1]->data[0];
		linePiece[4] = ((BezierPoint**)(*iter))[1]->data[1];
		linePiece[5] = ((BezierPoint**)(*iter))[1]->data[2];
		
		res.push_back(linePiece);
	}
	
   
	    return res;
}



std::vector<float*> BezierTetrahedron2::getControlPoints()
{
	std::vector<float*> l;
		//std::vector<float*>::iterator iter;
		
		std::vector<Index::MultiIdx*>::iterator iter;
		std::vector<Index::MultiIdx*> v;
		
		Index::MultiIdx* p;
		
		v = Index::MultiIdx::MultiIdx::getMultiIdxSet(this->deg,4);
		
		
	    int i=0;

	    {

	    	for(iter=v.begin();iter!=v.end();iter++)
	    	{
	    		p = (Index::MultiIdx*) (*iter);
	    		//p->print(stderr);
	    		l.push_back(this->BezierTetrahedron2::getControlPoint(p));
	    		this->ind_vec[i] = p;
	    		i++;
	    		
	    	}
		}

	    return l;
	
}

void BezierTetrahedron2::evalGrid(int steps)
{
	int v1=0;
    int u1=0;
    int w1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float****)calloc(steps+1,sizeof(float***)) ;
    gY = (float****)calloc(steps+1,sizeof(float***)) ;
    gZ = (float****)calloc(steps+1,sizeof(float***)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float***)calloc(steps-u1+1,sizeof(float**));
        gY[u1] = (float***)calloc(steps-u1+1,sizeof(float**));
        gZ[u1] = (float***)calloc(steps-u1+1,sizeof(float**));


        for (v1=0; v1 <= steps-u1; v1++)
        {
            gX[u1][v1] = (float**)calloc(steps-u1-v1+1,sizeof(float*));
            gY[u1][v1] = (float**)calloc(steps-u1-v1+1,sizeof(float*));
            gZ[u1][v1] = (float**)calloc(steps-u1-v1+1,sizeof(float*));

            
            for(w1=0; w1 <= steps-u1-v1; w1++)
            {
                gX[u1][v1][w1] = (float*)calloc(1,sizeof(float));
                gY[u1][v1][w1] = (float*)calloc(1,sizeof(float));
                gZ[u1][v1][w1] = (float*)calloc(1,sizeof(float));
            
            	
            
	            //for(x1=0; x1 <= steps-u1-v1-w1; x1++)
	            {
	                gX[u1][v1][w1][0] = this->evalV2(u1*step1, v1*step1, w1*step1,(1- u1*step1- v1*step1- w1*step1), 0);
	
	                gY[u1][v1][w1][0] = this->evalV2(u1*step1, v1*step1, w1*step1,(1- u1*step1- v1*step1- w1*step1), 1);
	
	                gZ[u1][v1][w1][0] = this->evalV2(u1*step1, v1*step1, w1*step1,(1- u1*step1- v1*step1- w1*step1), 2);
	                
	                
	                
	            }
            }
        }
    }


    return;
}

std::vector<float*> BezierTetrahedron2::wireFrameEdges(int steps)
{
	std::vector<float*> l;
	
    float *linePiece;

    int hy;
    
    int ui,vi,wi,xi;

    this->evalGrid(steps);


    // wireframe

    for (ui=0; ui<= steps; ui++)
      {
        for (vi=0; vi<= steps - ui; vi++)
          {
            for (wi=0; wi<= steps -ui -vi; wi++)
            {
            	//if(xi == (steps - ui - vi - wi))
            	//for (xi=0; xi< steps -ui -vi -wi; xi++)
	            
	            	xi = 0;
	                if (ui+vi+wi < steps )
	                if((vi==0)&&(wi==0))
	                {//if(gX[i+1][j]!=0)
	                	linePiece = new float[6];
	                	
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui+1][vi][wi][xi];
	                    linePiece[4] = gY[ui+1][vi][wi][xi];
	                    linePiece[5] = gZ[ui+1][vi][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	
	                if (ui+vi+wi < steps )
                	if((ui==0)&&(wi==0))
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui][vi+1][wi][xi];
	                    linePiece[4] = gY[ui][vi+1][wi][xi];
	                    linePiece[5] = gZ[ui][vi+1][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	
	                if (ui+vi+wi < steps )
	                	if((vi==0)&&(ui==0))
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui][vi][wi+1][xi];
	                    linePiece[4] = gY[ui][vi][wi+1][xi];
	                    linePiece[5] = gZ[ui][vi][wi+1][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	                
	                
	                if ((vi >0)&&(ui<steps))
	                	if((wi==0)&&(ui+vi+wi==steps))
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui+1][vi-1][wi][xi];
	                    linePiece[4] = gY[ui+1][vi-1][wi][xi];
	                    linePiece[5] = gZ[ui+1][vi-1][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                    
	                }
	
	                if ((wi >0)&&(ui<steps))
	                	if((vi==0)&&(ui+vi+wi==steps))
		                {   //if(gX[i][j+1]!=0)
		                	
		                	linePiece = new float[6];
		                	
		                    linePiece[0] = gX[ui][vi][wi][xi];
		                    linePiece[1] = gY[ui][vi][wi][xi];
		                    linePiece[2] = gZ[ui][vi][wi][xi];
		                    linePiece[3] = gX[ui+1][vi][wi-1][xi];
		                    linePiece[4] = gY[ui+1][vi][wi-1][xi];
		                    linePiece[5] = gZ[ui+1][vi][wi-1][xi];
		
		                    l.push_back(linePiece);
		                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
		                    //		linePiece[0],linePiece[1],linePiece[2],
		                    //		linePiece[3],linePiece[4],linePiece[5]);
		                    
		                }
	                

	                if ((wi >0)&&(vi<steps-ui))
	                	if((ui==0)&&(ui+vi+wi==steps))
		                {   //if(gX[i][j+1]!=0)
		                	
		                	linePiece = new float[6];
		                	
		                    linePiece[0] = gX[ui][vi][wi][xi];
		                    linePiece[1] = gY[ui][vi][wi][xi];
		                    linePiece[2] = gZ[ui][vi][wi][xi];
		                    linePiece[3] = gX[ui][vi+1][wi-1][xi];
		                    linePiece[4] = gY[ui][vi+1][wi-1][xi];
		                    linePiece[5] = gZ[ui][vi+1][wi-1][xi];
		
		                    l.push_back(linePiece);
		                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
		                    //		linePiece[0],linePiece[1],linePiece[2],
		                    //		linePiece[3],linePiece[4],linePiece[5]);
		                    
		                }
	                
	                
	            
            }


          }
      }


    hy=93;

    return l;

	
}



std::vector<float*> BezierTetrahedron2::wireFrame(int steps)
{
	std::vector<float*> l;
	
    float *linePiece;

    int hy;
    
    int ui,vi,wi,xi;

    this->evalGrid(steps);


    // wireframe

    for (ui=0; ui<= steps; ui++)
      {
        for (vi=0; vi<= steps - ui; vi++)
          {
            for (wi=0; wi<= steps -ui -vi; wi++)
            {
            	//if(xi == (steps - ui - vi - wi))
            	//for (xi=0; xi< steps -ui -vi -wi; xi++)
	            
	            	xi = 0;
	                if (ui+vi+wi < steps )
	                {//if(gX[i+1][j]!=0)
	                	linePiece = new float[6];
	                	
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui+1][vi][wi][xi];
	                    linePiece[4] = gY[ui+1][vi][wi][xi];
	                    linePiece[5] = gZ[ui+1][vi][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	
	                if (ui+vi+wi < steps )
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui][vi+1][wi][xi];
	                    linePiece[4] = gY[ui][vi+1][wi][xi];
	                    linePiece[5] = gZ[ui][vi+1][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	
	                if (ui+vi+wi < steps )
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui][vi][wi+1][xi];
	                    linePiece[4] = gY[ui][vi][wi+1][xi];
	                    linePiece[5] = gZ[ui][vi][wi+1][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                }
	                
	                
	                if ((vi >0)&&(ui<steps))
	                {   //if(gX[i][j+1]!=0)
	                	
	                	linePiece = new float[6];
	                	
	                    linePiece[0] = gX[ui][vi][wi][xi];
	                    linePiece[1] = gY[ui][vi][wi][xi];
	                    linePiece[2] = gZ[ui][vi][wi][xi];
	                    linePiece[3] = gX[ui+1][vi-1][wi][xi];
	                    linePiece[4] = gY[ui+1][vi-1][wi][xi];
	                    linePiece[5] = gZ[ui+1][vi-1][wi][xi];
	
	                    l.push_back(linePiece);
	                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
	                    //		linePiece[0],linePiece[1],linePiece[2],
	                    //		linePiece[3],linePiece[4],linePiece[5]);
	                    
	                }
	
	                if ((wi >0)&&(ui<steps))
		                {   //if(gX[i][j+1]!=0)
		                	
		                	linePiece = new float[6];
		                	
		                    linePiece[0] = gX[ui][vi][wi][xi];
		                    linePiece[1] = gY[ui][vi][wi][xi];
		                    linePiece[2] = gZ[ui][vi][wi][xi];
		                    linePiece[3] = gX[ui+1][vi][wi-1][xi];
		                    linePiece[4] = gY[ui+1][vi][wi-1][xi];
		                    linePiece[5] = gZ[ui+1][vi][wi-1][xi];
		
		                    l.push_back(linePiece);
		                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
		                    //		linePiece[0],linePiece[1],linePiece[2],
		                    //		linePiece[3],linePiece[4],linePiece[5]);
		                    
		                }
	                

	                if ((wi >0)&&(vi<steps-ui))
		                {   //if(gX[i][j+1]!=0)
		                	
		                	linePiece = new float[6];
		                	
		                    linePiece[0] = gX[ui][vi][wi][xi];
		                    linePiece[1] = gY[ui][vi][wi][xi];
		                    linePiece[2] = gZ[ui][vi][wi][xi];
		                    linePiece[3] = gX[ui][vi+1][wi-1][xi];
		                    linePiece[4] = gY[ui][vi+1][wi-1][xi];
		                    linePiece[5] = gZ[ui][vi+1][wi-1][xi];
		
		                    l.push_back(linePiece);
		                    //fprintf(stderr,"%g %g %g --- %g %g %g \n",
		                    //		linePiece[0],linePiece[1],linePiece[2],
		                    //		linePiece[3],linePiece[4],linePiece[5]);
		                    
		                }
	                
	                
	            
            }


          }
      }


    hy=93;

    return l;

	
}
