#include "BezierTriangle.h"





void BezierTriangle::fromBezierRectangle(Index::IndexedMatrix *m, Bezier_Element *bR)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bR->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}



void BezierTriangle::stepZ(float step)
{
	int i;
	for(i=0;i<this->deg+1;i++)
		this->c[i]->BezierCurve::stepZ((int)step);
}



int BezierTriangle::getOrder()
{
	return 1;
}
	
int* BezierTriangle::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(1,sizeof(int));
	
	dim[0] = 2;
	
	return dim;
}
	
int* BezierTriangle::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(1,sizeof(int));
	
	deg[0] = this->deg;
	
	return deg;
}



float* BezierTriangle::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
	
	//if((idx->sum()!= this->deg))
		//return 0x0;
	
	
	res = (float*) calloc(3,sizeof(float));
	
	
	res[0] = this->c[this->deg - idx->get(0)]->X[idx->get(1)];
	res[1] = this->c[this->deg - idx->get(0)]->Y[idx->get(1)];
	res[2] = this->c[this->deg - idx->get(0)]->Z[idx->get(1)];
	
	return res;
}

void BezierTriangle::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	//if((idx->sum()!= this->deg))
	//	return;
	
	
	
	this->c[this->deg - idx->get(0)]->X[idx->get(1)] = x;
	this->c[this->deg - idx->get(0)]->Y[idx->get(1)] = y;
	this->c[this->deg - idx->get(0)]->Z[idx->get(1)] = z;
	
	return;
}


BezierTriangle::BezierTriangle(int deg)
{
	this->n = (deg+2)*(deg+1)/2;
	this->deg = deg;
	
	this->X = new float[n];
	this->Y = new float[n];
	this->Z = new float[n];

	this->ind_vec = (Index::MultiIdx**) calloc(this->n,sizeof(Index::MultiIdx*));
	this->c = (BezierCurve**) calloc(deg+1,sizeof(BezierCurve*));
	
	int i;
	for(i=0;i<this->deg+1;i++)
	{
		this->c[i] = new BezierCurve(i);
	}
	
	
	//this->init();

}

BezierTriangle::BezierTriangle(int deg,int op)
{
	this->n = (deg+2)*(deg+1)/2;
	this->deg = deg;
	
	this->X = new float[n];
	this->Y = new float[n];
	this->Z = new float[n];
	
	this->c = (BezierCurve**) calloc(deg+1,sizeof(BezierCurve*));

	int i;
	for(i=0;i<this->deg+1;i++)
	{
		this->c[i] = new BezierCurve(i);
	}
}


BezierTriangle* BezierTriangle::times(float op)
{
	BezierTriangle* bt = new BezierTriangle(this->deg,1);
	
	int i;
	for(i=0;i<=this->deg;i++)
	{
		bt->c[i] = this->c[i]->BezierCurve::times(op);  
	}
	
	return bt;
}

BezierTriangle* BezierTriangle::add(BezierTriangle *op)
{
	
	BezierTriangle* bt;
	bt = new BezierTriangle(this->deg,1);
	
	if(this->deg != op->deg)
		return NULL;

	int i;
	for(i=0;i<=this->deg;i++)
	{
		bt->c[i] = op->c[i]->BezierCurve::add(this->c[i]);
	}
	
	return bt;
}



BezierTriangle* BezierTriangle::blossom(float u, float v, float w)
{
	if(this->deg<=0)
		return 0x0;
	
	

	
	BezierTriangle* bt = new BezierTriangle(this->deg-1,1);

	BezierCurve* bc;
	
	int i;
	
	for(i=0;i<= bt->deg;i++)
	{
		bc = this->c[i+1]->BezierCurve::blossom(u,v);
		
		bt->c[i] = (this->c[i]->BezierCurve::times(w));
		
		bt->c[i] = bt->c[i]->BezierCurve::add(bc);
		
	}
	

	
	return bt;
}



void BezierTriangle::init(float spacing)
{
	int i;
	for(i=0;i<this->deg+1;i++)
	{
		this->c[i]->BezierCurve::init( spacing);
		this->c[i]->step(2,i*spacing);
	}
	
		
}

double BezierTriangle::eval(double u, double v, double w, int coord)
{
	BezierTriangle* bt;
	
	bt = this;
	int i;
	
	for(i=0;i<this->deg;i++)
		bt = bt->BezierTriangle::blossom(u,v,w);
	
	if(coord==0)
		return bt->c[0]->X[0];
	
	if(coord==1)
		return bt->c[0]->Y[0];
	
	return bt->c[0]->Z[0];
		
}

std::vector<float*> BezierTriangle::wireFrameEdges(int steps)
{
	return BezierTriangle::wireFrame(steps);
	
}

std::vector<float*> BezierTriangle::wireFrame(int steps)
{
	
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
		
	this->BezierTriangle::evalGrid(steps,0);
	
	
	
	
	laux = this->BezierTriangle::wireFrame1Dir(steps,0);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle::wireFrame1Dir(steps,1);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle::wireFrame1Dir(steps,2);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
			
	return l;
	
	
}



void BezierTriangle::updControlPoints(int j, float x, float y, float z)
{

	
    //int i;
    
    /*
    
    for(i=0;i<this->deg+1;i++)
    {
    	if(j < this->c[i]->n)
    	{
    		this->c[i]->X[j] = x;
    		this->c[i]->Y[j] = y;
    		this->c[i]->Z[j] = z;
    		
    		return;
    	}
    	else
    	{
    		j = j- this->c[i]->n;
    	}
	}
    
	*/
    this->BezierTriangle::setControlPoint(this->ind_vec[j],x,y,z);

    return;

	
}




std::vector<float*> BezierTriangle::wireFrame1Dir(int steps, int dir)
{
	std::vector<float*> l;
	
    float *linePiece;


    int ui,vi,wi;

    


    // wireframe

    for (ui=0; ui< steps; ui++)
      {
        for (vi=0; vi< steps - ui; vi++)
          {
            //for (wi=0; wi< steps -ui -vi; wi++)
            {wi=0;
                if (dir==0 )
                {//if(gX[i+1][j]!=0)
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui+1][vi][wi];
                    linePiece[4] = gY[ui+1][vi][wi];
                    linePiece[5] = gZ[ui+1][vi][wi];

                    l.push_back(linePiece);
                }

                if (dir==1)
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui][vi+1][wi];
                    linePiece[4] = gY[ui][vi+1][wi];
                    linePiece[5] = gZ[ui][vi+1][wi];

                    l.push_back(linePiece);
                }
                if ((dir==2)&&(vi>0))
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui+1][vi-1][wi];
                    linePiece[4] = gY[ui+1][vi-1][wi];
                    linePiece[5] = gZ[ui+1][vi-1][wi];

                    l.push_back(linePiece);
                }

                
            }


          }
      }


    return l;
	
}




float* BezierTriangle::getLinePiece(int orig, int dest)
{
	float *linePiece;


	linePiece = new float[6];
	
    linePiece[0] = X[orig];
    linePiece[1] = Y[orig];
    linePiece[2] = Z[orig];
    linePiece[3] = X[dest];
    linePiece[4] = Y[dest];
    linePiece[5] = Z[dest];
    
    return linePiece;
}


std::vector<float*> BezierTriangle::controlNet()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
		
	float *linePiece;
	
	
    int i,j;
    for(i=0;i< this->deg;i++)
    {
    	
    	laux = this->c[i]->BezierCurve::controlNet();

    	
    	
    	for(j=0;j <= this->c[i]->deg; j++)
    		//for(k=0; k <= this->tri[i]->c[j]->deg; k++)
    		{
    			linePiece = new float[6];
    			linePiece[0] = this->c[i]->X[j];
    			linePiece[1] = this->c[i]->Y[j];
    			linePiece[2] = this->c[i]->Z[j];
    			
    			linePiece[3] = this->c[i+1]->X[j];
    			linePiece[4] = this->c[i+1]->Y[j];
    			linePiece[5] = this->c[i+1]->Z[j];
    		
    			laux.push_back(linePiece);
    			

    			
    			linePiece = new float[6];
    			linePiece[0] = this->c[i]->X[j];
    			linePiece[1] = this->c[i]->Y[j];
    			linePiece[2] = this->c[i]->Z[j];
    			
    			linePiece[3] = this->c[i+1]->X[j+1];
    			linePiece[4] = this->c[i+1]->Y[j+1];
    			linePiece[5] = this->c[i+1]->Z[j+1];
    		
    			laux.push_back(linePiece);

    		}
    	
    	
    	for(iter=laux.begin();iter!=laux.end();iter++)
    		l.push_back(*iter);
	}
    
    
    laux = this->c[this->deg]->BezierCurve::controlNet();
    for(iter=laux.begin();iter!=laux.end();iter++)
        		l.push_back(*iter);
    

	    return l;
	
}

/*
std::vector<float*> BezierTriangle::getControlPoints()
{
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
	
    int i;
    for(i=0;i<this->deg+1;i++)
    {
    	laux = this->c[i]->BezierCurve::getControlPoints();
    	for(iter=laux.begin();iter!=laux.end();iter++)
    		l.push_back(*iter);
	}

    return l;
	
}
*/
std::vector<float*> BezierTriangle::getControlPoints()
{
	std::vector<float*> l;
	//std::vector<float*>::iterator iter;
	
	std::vector<Index::MultiIdx*>::iterator iter;
	std::vector<Index::MultiIdx*> v;
	
	Index::MultiIdx* p;
	
	v = Index::MultiIdx::MultiIdx::getMultiIdxSet(this->deg,3);
	
	
    int i=0;
    //for(i=0;i<this->deg+1;i++)
    {
    	//laux = this->c[i]->BezierCurve::getControlPoints();
    	for(iter=v.begin();iter!=v.end();iter++)
    	{
    		p = (Index::MultiIdx*) (*iter);
    		//p->print(stderr);
    		l.push_back(this->BezierTriangle::getControlPoint(p));
    		this->ind_vec[i] = p;
    		i++;
    		
    	}
	}

    return l;
	
}




void BezierTriangle::evalGrid(int steps, int comp)
{
	int v1=0;
    int u1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float***)calloc(steps+1,sizeof(float**)) ;
    gY = (float***)calloc(steps+1,sizeof(float**)) ;
    gZ = (float***)calloc(steps+1,sizeof(float**)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float**)calloc(steps-u1+1,sizeof(float*));
        gY[u1] = (float**)calloc(steps-u1+1,sizeof(float*));
        gZ[u1] = (float**)calloc(steps-u1+1,sizeof(float*));


        for (v1=0; v1 <= steps-u1; v1++)
        {
            gX[u1][v1] = (float*)calloc(1,sizeof(float));
            gY[u1][v1] = (float*)calloc(1,sizeof(float));
            gZ[u1][v1] = (float*)calloc(1,sizeof(float));

            //if(comp==0)
            {
                gX[u1][v1][0] = this->eval(u1*step1, v1*step1,1-(u1*step1 + v1*step1), 0);

                gY[u1][v1][0] = this->eval(u1*step1, v1*step1,1-(u1*step1 + v1*step1), 1);

                gZ[u1][v1][0] = this->eval(u1*step1, v1*step1,1-(u1*step1 + v1*step1), 2);
            }
            
        }
    }


    return;
}


int BezierTriangle::getN()
{
	return this->n;
}


BezierTriangle::~BezierTriangle()
{
}
