#ifndef BEZIERTRIANGLE_H_
#define BEZIERTRIANGLE_H_

#include "Bezier_Element.h"
#include "BezierCurve.h"

#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include "../../conversionV2/Index/IndexedMatrix.h"


class BezierTriangle : public Bezier_Element
{
public:
	int deg;
	int n;
	
	Index::MultiIdx **ind_vec;
	
	float *X;
	float *Y;
	float *Z;
	
	float ***gX;
	float ***gY;
	float ***gZ; 
	
	BezierCurve** c;
	
public:
	BezierTriangle(int deg);
	BezierTriangle(int deg, int op);

	
	void  fromBezierRectangle(Index::IndexedMatrix *m, Bezier_Element *bR);
	
	
	 int  getOrder();
	
	 int*  getDimensions();
	
	 int*  getDegrees();
	
	
	void  setControlPoint(Index::BezierIndex *idx, float x, float y, float z);
	
	float*  getControlPoint(Index::BezierIndex *idx);
	
	int  getN();
	
	void  updControlPoints(int i, float x, float y, float z);
	
	BezierTriangle*  blossom(float u, float v, float w);	
	double  eval(double u, double v, double w, int coord);
	std::vector<float*>  wireFrame(int steps);
	std::vector<float*>  wireFrameEdges(int steps);	
	std::vector<float*>  getControlPoints();
	std::vector<float*>  controlNet();

	BezierTriangle*  add(BezierTriangle *op);
	BezierTriangle*  times(float op);

	void  downloadCurves();
	void  loadCurves();
	
	
	void  init(float spacing);
	
	
	
	void  stepZ(float step);
	
	
	
protected:	
	



		
	std::vector<float*>  wireFrame1Dir(int steps, int dir);
	
	

	void  evalGrid(int steps, int comp);
	float*  getLinePiece(int orig, int dest);
	
	virtual ~BezierTriangle();
};

#endif /*BEZIERTRIANGLE_H_*/
