#include "BezierTriangle2.h"
#include "BezierPoint.h"
#include "math.h"


void BezierTriangle2::fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bT)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bT->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}

void BezierTriangle2::fromBezierRectangle(Index::IndexedMatrix *m, Bezier_Element *bR)
{
	Index::BezierIndex *col_idx, *row_idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			p = bR->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		this->setControlPoint(row_idx,x,y,z);
	}
	
}



void BezierTriangle2::stepZ(float step)
{
	double *d = (double*) calloc(3,sizeof(double));
	d[0] = 0;
	d[1] = 0;
	d[2] = step;
	this->bs->BezierSimplex::translate(d);
	
}



int BezierTriangle2::getOrder()
{
	return 1;
}
	
int* BezierTriangle2::getDimensions()
{
	int *dim;
	
	dim = (int*) calloc(1,sizeof(int));
	
	dim[0] = 2;
	
	return dim;
}
	
int* BezierTriangle2::getDegrees()
{
	int *deg;
	
	deg = (int*) calloc(1,sizeof(int));
	
	deg[0] = this->deg;
	
	return deg;
}



float* BezierTriangle2::getControlPoint(Index::BezierIndex *idx)
{
	float *res;
	
	BezierPoint* bp;
	
	bp = (BezierPoint*) this->bs->BezierSimplex::getControl_Point(idx);
	
	res = (float*) calloc(3,sizeof(float));
	
	
	res[0] = bp->data[0];
	res[1] = bp->data[1];
	res[2] = bp->data[2];
	
	return res;
}

void BezierTriangle2::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
{
	
	//if((idx->sum()!= this->deg))
	//	return;
	
	double *data = (double*) calloc(3,sizeof(double));
	
	data[0] = x;
	data[1] = y;
	data[2] = z;
	
	((BezierPoint*) (this->bs->BezierSimplex::getControl_Point(idx) ) )->BezierPoint::setData(data);
	
	return;
}


BezierTriangle2::BezierTriangle2(int deg)
{
	this->n = (deg+2)*(deg+1)/2;
	this->deg = deg;
	
	
	this->ind_vec = (Index::MultiIdx**) calloc(this->n,sizeof(Index::MultiIdx*));
	
	
	
}




BezierTriangle2* BezierTriangle2::blossom(float u, float v, float w)
{
	BezierTriangle2* bt2 = new BezierTriangle2(this->deg-1);
	
	double* point = (double*) calloc(3,sizeof(double));
	point[0] = u;
	point[1] = v;
	point[2] = w;
	
	bt2->bs = this->bs->BezierSimplex::blossom(point);
	
	return bt2;
	
}



void BezierTriangle2::init(float spacing)
{
	this->bs = new BezierSimplex(2,3,this->deg);
	this->bs->BezierSimplex::init(spacing);
		
}

double BezierTriangle2::eval(double u, double v, double w, int coord)
{
	BezierPoint* bp;
	double value;
	
	double* point = (double*) calloc(3,sizeof(double));
	point[0] = u;
	point[1] = v;
	point[2] = w;
		
	bp = (BezierPoint*) this->bs->BezierSimplex::eval(point);
	
	value =  bp->data[coord];
		
	delete (BezierPoint*)bp;
	delete point;
	
	return value;
				
}



std::vector<float*> BezierTriangle2::wireFrameExtDomain(int steps)
{
	
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
	
	//BezierPoint* dsa = new BezierPoint(3);
		
	this->BezierTriangle2::evalGridExtDomain(steps,0);
	
	//dsa->data[0] = 21;
	
	
	laux = this->BezierTriangle2::wireFrame1Dir(steps,0);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle2::wireFrame1Dir(steps,1);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle2::wireFrame1Dir(steps,2);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
			
	return l;
	
	
}

std::vector<float*> BezierTriangle2::wireFrame(int steps)
{
	
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
	
	//BezierPoint* dsa = new BezierPoint(3);
		
	this->BezierTriangle2::evalGrid(steps,0);
	
	//dsa->data[0] = 21;
	
	
	laux = this->BezierTriangle2::wireFrame1Dir(steps,0);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle2::wireFrame1Dir(steps,1);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle2::wireFrame1Dir(steps,2);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
			
	return l;
	
	
}


std::vector<float*> BezierTriangle2::wireFrameEdges(int steps)
{
	
	std::vector<float*> l,laux;
	std::vector<float*>::iterator iter;
	
	//BezierPoint* dsa = new BezierPoint(3);
		
	this->BezierTriangle2::evalGrid(steps,0);
	
	//dsa->data[0] = 21;
	
	
	laux = this->BezierTriangle2::wireFrame1DirEdges(steps,0);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle2::wireFrame1DirEdges(steps,1);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
	
	laux = this->BezierTriangle2::wireFrame1DirEdges(steps,2);
	for(iter=laux.begin();iter!=laux.end();iter++)
		l.push_back(*iter);
			
	return l;
	
	
}


void BezierTriangle2::updControlPoints(int j, float x, float y, float z)
{

	
    this->BezierTriangle2::setControlPoint(this->ind_vec[j],x,y,z);

    return;

	
}




std::vector<float*> BezierTriangle2::wireFrame1DirEdges(int steps, int dir)
{
	std::vector<float*> l;
	
    float *linePiece;


    int ui,vi,wi;

    


    // wireframe

    for (ui=0; ui<= steps; ui++)
      {
        for (vi=0; vi<= steps - ui; vi++)
          {
            //for (wi=0; wi< steps -ui -vi; wi++)
            {wi=0;
                if ((dir==0 )&&(ui+vi<steps))
                	if(vi==0)
                {//if(gX[i+1][j]!=0)
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui+1][vi][wi];
                    linePiece[4] = gY[ui+1][vi][wi];
                    linePiece[5] = gZ[ui+1][vi][wi];

                    l.push_back(linePiece);
                }

                if ((dir==1)&&(vi+ui<steps))
                	if(ui==0)
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui][vi+1][wi];
                    linePiece[4] = gY[ui][vi+1][wi];
                    linePiece[5] = gZ[ui][vi+1][wi];

                    l.push_back(linePiece);
                }
                
                if ((dir==2)&&(vi>0)&&(ui<steps))
                	if(ui+vi==steps)
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui+1][vi-1][wi];
                    linePiece[4] = gY[ui+1][vi-1][wi];
                    linePiece[5] = gZ[ui+1][vi-1][wi];

                    l.push_back(linePiece);
                }
                
                if ((dir==2)&&(ui>0)&&(vi<steps))
                	if(ui+vi==steps)
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui-1][vi+1][wi];
                    linePiece[4] = gY[ui-1][vi+1][wi];
                    linePiece[5] = gZ[ui-1][vi+1][wi];

                    l.push_back(linePiece);
                }

                
            }


          }
      }


    return l;
	
}


std::vector<float*> BezierTriangle2::wireFrame1Dir(int steps, int dir)
{
	std::vector<float*> l;
	
    float *linePiece;


    int ui,vi,wi;

    


    // wireframe

    for (ui=0; ui<= steps; ui++)
      {
        for (vi=0; vi<= steps - ui; vi++)
          {
            //for (wi=0; wi< steps -ui -vi; wi++)
            {wi=0;
                if ((dir==0 )&&(ui+vi<steps))
                {//if(gX[i+1][j]!=0)
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui+1][vi][wi];
                    linePiece[4] = gY[ui+1][vi][wi];
                    linePiece[5] = gZ[ui+1][vi][wi];

                    l.push_back(linePiece);
                }

                if ((dir==1)&&(vi+ui<steps))
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui][vi+1][wi];
                    linePiece[4] = gY[ui][vi+1][wi];
                    linePiece[5] = gZ[ui][vi+1][wi];

                    l.push_back(linePiece);
                }
                if ((dir==2)&&(vi>0)&&(ui<steps))
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui+1][vi-1][wi];
                    linePiece[4] = gY[ui+1][vi-1][wi];
                    linePiece[5] = gZ[ui+1][vi-1][wi];

                    l.push_back(linePiece);
                }
                
                if ((dir==2)&&(ui>0)&&(vi<steps))
                {   //if(gX[i][j+1]!=0)
                	
                	linePiece = new float[6];
                	
                    linePiece[0] = gX[ui][vi][wi];
                    linePiece[1] = gY[ui][vi][wi];
                    linePiece[2] = gZ[ui][vi][wi];
                    linePiece[3] = gX[ui-1][vi+1][wi];
                    linePiece[4] = gY[ui-1][vi+1][wi];
                    linePiece[5] = gZ[ui-1][vi+1][wi];

                    l.push_back(linePiece);
                }

                
            }


          }
      }


    return l;
	
}




std::vector<float*> BezierTriangle2::controlNet()
{
	std::vector<BezierSimplex**> l;
	std::vector<float*> res;
	std::vector<BezierSimplex**>::iterator iter;
		
	float *linePiece;
	
	//return res;
	
	l = this->bs->BezierSimplex::controlNet();
	for(iter=l.begin();iter!=l.end();iter++)
	{
		linePiece = (float*) calloc(6,sizeof(float));
		linePiece[0] = ((BezierPoint**)(*iter))[0]->data[0];
		linePiece[1] = ((BezierPoint**)(*iter))[0]->data[1];
		linePiece[2] = ((BezierPoint**)(*iter))[0]->data[2];
		linePiece[3] = ((BezierPoint**)(*iter))[1]->data[0];
		linePiece[4] = ((BezierPoint**)(*iter))[1]->data[1];
		linePiece[5] = ((BezierPoint**)(*iter))[1]->data[2];
		
		//delete ((BezierPoint**)(*iter))[0];
		//delete ((BezierPoint**)(*iter))[1];
				
		
		res.push_back(linePiece);
	}
	
   
	    return res;
	
}


std::vector<float*> BezierTriangle2::getControlPoints()
{
	std::vector<float*> l;
	//std::vector<float*>::iterator iter;
	
	std::vector<Index::MultiIdx*>::iterator iter;
	std::vector<Index::MultiIdx*> v;
	
	Index::MultiIdx* p;
	
	v = Index::MultiIdx::MultiIdx::getMultiIdxSet(this->deg,3);
	
	
    int i=0;

    {

    	for(iter=v.begin();iter!=v.end();iter++)
    	{
    		p = (Index::MultiIdx*) (*iter);
    		//p->print(stderr);
    		l.push_back(this->BezierTriangle2::getControlPoint(p));
    		this->ind_vec[i] = p;
    		i++;
    		
    	}
	}

    return l;
	
}


void BezierTriangle2::evalGridExtDomain(int steps, int comp)
{
	int v1=0;
    int u1=0;
    
    float u,v,w,uu,vv,ww;
    
    /*
     * (uu,vv) is (u,v) after the transformation
     * (3 -1,-1)
     * (-1 3 -1)
     * (-1 -1 3)
     */
    
    
    float step1 = (float)1.0001/steps;


    gX = (float***)calloc(steps+1,sizeof(float**)) ;
    gY = (float***)calloc(steps+1,sizeof(float**)) ;
    gZ = (float***)calloc(steps+1,sizeof(float**)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float**)calloc(steps-u1+1,sizeof(float*));
        gY[u1] = (float**)calloc(steps-u1+1,sizeof(float*));
        gZ[u1] = (float**)calloc(steps-u1+1,sizeof(float*));


        for (v1=0; v1 <= steps-u1; v1++)
        {
            gX[u1][v1] = (float*)calloc(1,sizeof(float));
            gY[u1][v1] = (float*)calloc(1,sizeof(float));
            gZ[u1][v1] = (float*)calloc(1,sizeof(float));

            //if(comp==0)
            {
            	u = u1*step1;
            	v = v1*step1;
            	w = 1 - u - v;
            	uu = 3*u - v - w;
            	vv = 3*v - u - w;
            	ww = 3*w - u - v;
            	
                gX[u1][v1][0] = this->eval(uu, vv,ww, 0);

                gY[u1][v1][0] = this->eval(uu, vv,ww, 1);

                gZ[u1][v1][0] = this->eval(uu, vv,ww, 2);
            }
            
        }
    }


    return;
}



void BezierTriangle2::evalGrid(int steps, int comp)
{
	int v1=0;
    int u1=0;
    
    float step1 = (float)1.0001/steps;


    gX = (float***)calloc(steps+1,sizeof(float**)) ;
    gY = (float***)calloc(steps+1,sizeof(float**)) ;
    gZ = (float***)calloc(steps+1,sizeof(float**)) ;




    for (u1=0; u1 <= steps; u1++)
    {

        gX[u1] = (float**)calloc(steps-u1+1,sizeof(float*));
        gY[u1] = (float**)calloc(steps-u1+1,sizeof(float*));
        gZ[u1] = (float**)calloc(steps-u1+1,sizeof(float*));


        for (v1=0; v1 <= steps-u1; v1++)
        {
            gX[u1][v1] = (float*)calloc(1,sizeof(float));
            gY[u1][v1] = (float*)calloc(1,sizeof(float));
            gZ[u1][v1] = (float*)calloc(1,sizeof(float));

            //if(comp==0)
            {
                gX[u1][v1][0] = this->eval(u1*step1, v1*step1,1-(u1*step1 + v1*step1), 0);

                gY[u1][v1][0] = this->eval(u1*step1, v1*step1,1-(u1*step1 + v1*step1), 1);

                gZ[u1][v1][0] = this->eval(u1*step1, v1*step1,1-(u1*step1 + v1*step1), 2);
            }
            
        }
    }


    return;
}




int BezierTriangle2::getN()
{
	return this->n;
}


BezierTriangle2::~BezierTriangle2()
{
}
