#ifndef BezierTriangle2_H_
#define BezierTriangle2_H_



#include "Bezier_Element.h"
#include "BezierCurve.h"

#include "BezierSimplex.h"

#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include "../../conversionV2/Index/IndexedMatrix.h"



class BezierTriangle2 : public Bezier_Element
{
public:
	int deg;
	int n;
	
	Index::MultiIdx **ind_vec;
	

	
	float ***gX;
	float ***gY;
	float ***gZ; 
	
	BezierSimplex* bs;
	
	
public:
	BezierTriangle2(int deg);

	void  fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bT);
	void  fromBezierRectangle(Index::IndexedMatrix *m, Bezier_Element *bR);
	
	
	 int  getOrder();
	
	 int*  getDimensions();
	
	 int*  getDegrees();
	
	
	void  setControlPoint(Index::BezierIndex *idx, float x, float y, float z);
	
	float*  getControlPoint(Index::BezierIndex *idx);
	
	int  getN();
	
	void  updControlPoints(int i, float x, float y, float z);
	
	BezierTriangle2*  blossom(float u, float v, float w);
	
	double  eval(double u, double v, double w, int coord);
	
	std::vector<float*>  wireFrame(int steps);
	std::vector<float*>  wireFrameEdges(int steps);
	std::vector<float*>  wireFrameExtDomain(int steps);
	std::vector<float*>  getControlPoints();
	std::vector<float*>  controlNet();


	
	
	void  init(float spacing);
	
	
	
	void  stepZ(float step);
	
	
	
protected:	
	

		
	std::vector<float*>  wireFrame1Dir(int steps, int dir);
	std::vector<float*>  wireFrame1DirEdges(int steps, int dir);
	
	

	void  evalGrid(int steps, int comp);
	
	void  evalGridExtDomain(int steps, int comp);
	
	float*  getLinePiece(int orig, int dest);
	
	virtual ~BezierTriangle2();
};
#endif /*BezierTriangle2_H_*/
