#include "Bezier_Element.h"
#include "../../conversionV2/Index/HyperIdx.h"
#include "../../conversionV2/Numbers/Number.h"


double* Bezier_Element::getControl_Point(Index::BezierIndex *idx)
{
	return 0;
}


void Bezier_Element::setControlPointsMP(Index::IndexedMPMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	Index::HyperIdx* idx;
	float x,y,z;
	float *p;
	
	Number *coef;
	float coefd;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			if(bt->getOrder()>1)
			{
				idx = Index::HyperIdx::HyperIdx::fromTensorIdx((Index::MultiIdx*)col_idx,bt->getDegrees());
				p = bt->getControlPoint((Index::BezierIndex*)idx);
			}
			else
				p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			
			coefd = (float)coef->getDouble();
			x = x + coefd * p[0];
			y = y + coefd * p[1];
			z = z + coefd * p[2];
						
		}
		
		if(this->getOrder()>1)
		{
			idx = Index::HyperIdx::HyperIdx::fromTensorIdx((Index::MultiIdx*)row_idx,this->getDegrees());
			this->setControlPoint((Index::BezierIndex*)idx,x,y,z);
		}
		else
			this->setControlPoint((Index::BezierIndex*)row_idx,x,y,z);
		
		
	}
	
	
}


void Bezier_Element::setSomeControlPointsMP(Index::IndexedMPMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	Index::HyperIdx* idx;
	float x,y,z;
	float *p;
	
	Number *coef;
	float coefd;
	
	int icol,irow;
	int mask_v;
	
	int face1,face2;
	
	face1=2;
	face2=0;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		mask_v=1;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			if(bt->getOrder()>1)
			{
				idx = Index::HyperIdx::HyperIdx::fromTensorIdx((Index::MultiIdx*)col_idx,bt->getDegrees());
				p = bt->getControlPoint((Index::BezierIndex*)idx);
			}
			else
				p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			((Index::MultiIdx*)col_idx)->print(stderr);
			
			if(col_idx->get(face1)>1 )
				mask_v = 0;

			if(mask_v)
			{
			coefd = (float)coef->getDouble();
			x = x + coefd * p[0];
			y = y + coefd * p[1];
			z = z + coefd * p[2];
			}
			
		}
		
		((Index::MultiIdx*)row_idx)->print(stderr);
		mask_v = 1;
		
		if(row_idx->get(face2)>1 )
				mask_v = 0;
		

		if(mask_v)
		{
			if(this->getOrder()>1)
			{
				idx = Index::HyperIdx::HyperIdx::fromTensorIdx((Index::MultiIdx*)row_idx,this->getDegrees());
				this->setControlPoint((Index::BezierIndex*)idx,x,y,z);
			}
			else
				this->setControlPoint((Index::BezierIndex*)row_idx,x,y,z);
		}
		
	}
	
	
}


void Bezier_Element::setControlPoints(Index::IndexedMatrix *m, Bezier_Element *bt)
{
	Index::BezierIndex *col_idx, *row_idx;
	Index::HyperIdx* idx;
	float x,y,z;
	float *p;
	
	float coef;
	
	int icol,irow;
	
	for(irow=0;irow<m->rown;irow++)
	{
		x = 0;
		y = 0;
		z = 0;
		
		row_idx = m->rowIdx[irow];
		
		//
		for(icol=0;icol<m->coln;icol++)
		{		
			col_idx = m->colIdx[icol];

			if(bt->getOrder()>1)
			{
				idx = Index::HyperIdx::HyperIdx::fromTensorIdx((Index::MultiIdx*)col_idx,bt->getDegrees());
				p = bt->getControlPoint((Index::BezierIndex*)idx);
			}
			else
				p = bt->getControlPoint(col_idx);
			
			coef = m->data[irow][icol];
			
			x = x + coef * p[0];
			y = y + coef * p[1];
			z = z + coef * p[2];
						
		}
		
		if(this->getOrder()>1)
		{
			idx = Index::HyperIdx::HyperIdx::fromTensorIdx((Index::MultiIdx*)row_idx,this->getDegrees());
			this->setControlPoint((Index::BezierIndex*)idx,x,y,z);
		}
		else
			this->setControlPoint((Index::BezierIndex*)row_idx,x,y,z);
		
		
	}
	
	
}



	 void Bezier_Element::fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bt)
	 {
		 
	 }
	 void Bezier_Element::fromBezierRectangle(Index::IndexedMatrix *m, Bezier_Element *bR)
	 {
		 
	 }






	 float* Bezier_Element::getControlPoint(Index::BezierIndex *idx)
	 {
		 return 0x0;
	 }
	 
	 void Bezier_Element::setControlPoint(Index::BezierIndex *idx, float x, float y, float z)
	 {
		 
	 }



int Bezier_Element::getOrder()
{
	return 0;
}
	
int* Bezier_Element::getDimensions()
{
	return 0x0;
}
	
int* Bezier_Element::getDegrees()
{
	return 0x0;
}





void Bezier_Element::name()
{
	fprintf(stderr,"element\n");
}


float* Bezier_Element::getControlPoint(Index::MultiIdx *idx)
{
	float* res;
	res = (float*) calloc(3,sizeof(float));
	res[0]=-1;
	res[1]=-1;
	res[2]=-1;
	
	return res;
}



 void Bezier_Element::updControlPoints(int i, float x, float y, float z)
{
	
}

 std::vector<float*> Bezier_Element::wireFrame(int steps)
 {
	 std::vector<float*> v;
	 return v;
	 
 }
 
 std::vector<float*> Bezier_Element::wireFrameEdges(int steps)
 {
	 std::vector<float*> v;
	 return v;
	 
 }
 
 std::vector<float*> Bezier_Element::getControlPoints()
 {
	 std::vector<float*> v;
	 return v;
 }

 std::vector<float*> Bezier_Element::controlNet()
 {
	 std::vector<float*> v;
	 return v;
 }
	
void Bezier_Element::init()
{
	
}


int Bezier_Element::getN()
{
	return 0;
}




Bezier_Element::Bezier_Element()
{
}

Bezier_Element::~Bezier_Element()
{
}
