#ifndef BEZIER_ELEMENT_H_
#define BEZIER_ELEMENT_H_


#include<stdlib.h>
#include <vector>
#include <stdio.h>
#include "../../conversionV2/Index/MultiIdx.h"
#include "../../conversionV2/Index/IndexedMatrix.h"
#include "../../conversionV2/Index/IndexedMPMatrix.h"

class Bezier_Element
{
public:
	
	int deg;
	int n;
	
	float *X,*Y,*Z;
	
	
	virtual void  setControlPoints(Index::IndexedMatrix *m, Bezier_Element *bt);
	virtual void  setControlPointsMP(Index::IndexedMPMatrix *m, Bezier_Element *bt);
	virtual void  setSomeControlPointsMP(Index::IndexedMPMatrix *m, Bezier_Element *bt);

	
	virtual void  fromBezierTriangle(Index::IndexedMatrix *m, Bezier_Element *bt);
	virtual void  fromBezierRectangle(Index::IndexedMatrix *m, Bezier_Element *bR);
	

	virtual float*  getControlPoint(Index::BezierIndex *idx);
	
	virtual double*  getControl_Point(Index::BezierIndex *idx);
	
	
	
	virtual void  setControlPoint(Index::BezierIndex *idx, float x, float y, float z);
	
	
	virtual int  getOrder();
	
	virtual int*  getDimensions();
	
	virtual int*  getDegrees();
		
	
	virtual void  name();
	
	virtual int  getN();
	
	virtual float*  getControlPoint(Index::MultiIdx *idx);
	
	virtual void  updControlPoints(int i, float x, float y, float z);
	virtual std::vector<float*>  wireFrame(int steps);
	virtual std::vector<float*>  wireFrameEdges(int steps);
	virtual std::vector<float*>  getControlPoints();
	virtual std::vector<float*>  controlNet();
	
	virtual void  init();
	
	
	Bezier_Element();
	virtual ~Bezier_Element();
};

#endif /*BEZIER_ELEMENT_H_*/
