#include "MySignalDealer.h"
#include <qmessagebox.h>

#include "../CAGD_elements/BezierTriangle.h"
#include "../CAGD_elements/BezierTetrahedron.h"
#include "../CAGD_elements/BezierCurve.h"
#include "../CAGD_elements/BezierRectangle.h"
#include "../CAGD_elements/BezierCube.h"
#include "../CAGD_elements/Bezier_Element.h"


#include "../CAGD_elements/BezierTriangle2.h"
#include "../CAGD_elements/BezierTetrahedron2.h"

#include "../CAGD_elements/BezierRectangle2.h"
#include "../CAGD_elements/BezierCube2.h"
#include "../CAGD_elements/BezierPrism.h"


void MySignalDealer::updateElements()
{
	QString *str = new QString();
	
    
	this->mainwin = mainwin;
	
	int i,id;
	
	
	this->dispatcher_pop->clear();
	this->modif_pop->clear();
	
    for(i=0;i<Platform::n_el;i++)
    {
	   str->sprintf("Element %d",i);
	   id = this->dispatcher_pop-> insertItem(*str, qApp, SLOT(setInteract_slot(int)) );
	   this->dispatcher_pop->setItemParameter (id, i ); 
    }
    for(i=0;i<Platform::n_el;i++)
        {
    	   str->sprintf("Element %d",i);
    	   id = this->modif_pop-> insertItem(*str, qApp, SLOT(setModif_slot(int)) );
    	   this->modif_pop->setItemParameter (id, i ); 
        }
   
	
}




void MySignalDealer::init(QWidget * mainwin)
{
	
	QPopupMenu *pop1, *pop2;
	QString *str = new QString();
	
this->mainwin = mainwin;
	
	// Make the top-level layout; a vertical box to contain all widgets
	       // and sub-layouts.
	       topLayout = new QVBoxLayout( mainwin, 5 );
	

	       // Create a menubar...
	       menubar = new QMenuBar( mainwin );
	       menubar->setSeparator( QMenuBar::InWindowsStyle );
	       
	       
	       popup = new QPopupMenu( mainwin );
	       popup->insertItem( "&Quit", qApp, SLOT(quit()) );
	       menubar->insertItem( "&File", popup );

	       
	       int i;
	       
	       
	       
	       popup = new QPopupMenu( mainwin );
	       pop1 = new QPopupMenu( mainwin );

	       	       
	       int id;
	       
	       
	       pop2 = new QPopupMenu( mainwin );
	       for(i=1;i<9;i++)
   	       {
   	    	   str->sprintf("Degree %d",i);
   	    	   id = pop2-> insertItem(*str, qApp, SLOT(addElement_slot(int)) );
   	    	   pop2->setItemParameter (id, 200+i ); 
   	       }
	       pop1->insertItem("Triangle",pop2);
	       
	       pop2 = new QPopupMenu( mainwin );
	       for(i=1;i<9;i++)
   	       {
   	    	   str->sprintf("Degree %d",i);
   	    	   id = pop2-> insertItem(*str, qApp, SLOT(addElement_slot(int)) );
   	    	   pop2->setItemParameter (id, 300+i ); 
   	       }
	       pop1->insertItem("Rectangle",pop2);
	       
       
	       pop2 = new QPopupMenu( mainwin );
	       for(i=1;i<9;i++)
	       {
	    	   str->sprintf("Degree %d",i);
	    	   id = pop2-> insertItem(*str, qApp, SLOT(addElement_slot(int)) );
	    	   pop2->setItemParameter (id, i ); 
	       }
	       pop1->insertItem("Tetrahedron",pop2);
	       
	       
	       pop2 = new QPopupMenu( mainwin );
	       for(i=1;i<9;i++)
   	       {
   	    	   str->sprintf("Degree %d",i);
   	    	   id = pop2-> insertItem(*str, qApp, SLOT(addElement_slot(int)) );
   	    	   pop2->setItemParameter (id, 100+i ); 
   	       }
	       pop1->insertItem("Cube",pop2);
   	       
	       pop2 = new QPopupMenu( mainwin );
   	       for(i=1;i<9;i++)
      	       {
      	    	   str->sprintf("Degree %d",i);
      	    	   id = pop2-> insertItem(*str, qApp, SLOT(addElement_slot(int)) );
      	    	   pop2->setItemParameter (id, 400+i ); 
      	       }
   	       pop1->insertItem("Prism",pop2);
      	       
	       
	       
	       
	       
	       
   	       menubar->insertItem( "Add Element", pop1 );
	       

   	       
   	       
   	       this->dispatcher_pop = new QPopupMenu(mainwin);
   	       this->modif_pop = new QPopupMenu(mainwin);
   	       	       
   	       
	       
	       popup = new QPopupMenu( mainwin );
	       popup->insertItem("Dispatcher",this->dispatcher_pop);
	       popup->insertItem("Modified",this->modif_pop);
	       popup->insertSeparator();
	       popup->insertItem("Connect",qApp, SLOT(validateConnection_slot()));
	       popup->insertItem("Disconnect",qApp, SLOT(disconnect_slot()));
	       
   	       	       
   	       menubar->insertItem( "Connect Elements", popup );
   	    	       
   	       
   	       
   	       
   	       
   	       
   	       
	       // ...and tell the layout about it.
	       topLayout->setMenuBar( menubar );

	   
	       // Make an hbox that will hold a row of buttons.
	           buttons = new QHBoxLayout( topLayout );
	           
	           this->loadWF_but= new QPushButton( mainwin );
	           QString s1;
               s1.sprintf( "loadWf");
               this->loadWF_but->setText( s1 );

               this->cleanWF_but= new QPushButton( mainwin );
   	           QString s2;
   	           s2.sprintf( "cleanWf");
   	           this->cleanWF_but->setText( s2 );
               
   	           this->loadNet_but= new QPushButton( mainwin );
	           QString s3;
               s3.sprintf( "loadNet");
               this->loadNet_but->setText( s3 );

               this->cleanNet_but= new QPushButton( mainwin );
   	           QString s4;
   	           s4.sprintf( "cleanNet");
   	           this->cleanNet_but->setText( s4 );
   	           
   	           this->loadEdges_but= new QPushButton( mainwin );
	           QString s5;
               s5.sprintf( "loadEdges");
               this->loadEdges_but->setText( s5 );

               this->cleanEdges_but= new QPushButton( mainwin );
   	           QString s6;
   	           s6.sprintf( "cleanEdges");
   	           this->cleanEdges_but->setText( s6 );
               
	               // Set horizontal stretch factor to 10 to let the buttons
	               // stretch horizontally. The buttons will not stretch
	               // vertically, since bigWidget below will take up vertical
	               // stretch.
   	           buttons->addWidget( this->loadWF_but, 10 );
   	           buttons->addWidget( this->loadNet_but, 10 );
   	           buttons->addWidget( this->loadEdges_but, 10 );
   	           buttons->addWidget( this->cleanEdges_but, 10 );
   	           buttons->addWidget( this->cleanWF_but, 10 );
   	           buttons->addWidget( this->cleanNet_but, 10 );
	               // (Actually, the result would have been the same with a
	               // stretch factor of 0; if no items in a layout have non-zero
	               // stretch, the space is divided equally between members.)

	           // Make another hbox that will hold a left-justified row of buttons.
	           buttons2 = new QHBoxLayout( topLayout );

	           QPushButton* but = new QPushButton( "Button five", mainwin );
	           buttons2->addWidget( but );

	           but = new QPushButton( "PS", mainwin );
	           buttons2->addWidget( but );

	           // Fill up the rest of the hbox with stretchable space, so that
	           // the buttons get their minimum width and are pushed to the left.
	           buttons2->addStretch( 10 );

	           // Make  a big widget that will grab all space in the middle.
	           bigWidget = new QWidget( mainwin );
	           bigWidget_r = new QWidget( mainwin );
	           //bigWidget->setText( "This widget will get all the remaining space" );
	           //bigWidget->setFrameStyle( QFrame::Panel | QFrame::Plain );

	           // Set vertical stretch factor to 10 to let the bigWidget stretch
	           // vertically. It will stretch horizontally because there are no
	           // widgets beside it to take up horizontal stretch.
	           //    topLayout->addWidget( bigWidget, 10 );
	           
	           
	           QBoxLayout* hLayout = new QHBoxLayout( topLayout, 5 );
	           hLayout->addWidget( bigWidget );
	           hLayout->addWidget( bigWidget_r );

	           // Make a grid that will hold a vertical table of QLabel/QLineEdit
	           // pairs next to a large QMultiLineEdit.

	           // Don't use hard-coded row/column numbers in QGridLayout, you'll
	           // regret it when you have to change the layout.
	           const int numRows = 3;
	           const int labelCol = 0;
	           const int linedCol = 1;
	           const int multiCol = 2;

	           // Let the grid-layout have a spacing of 10 pixels between
	           // widgets, overriding the default from topLayout.
	           QGridLayout *grid = new QGridLayout( topLayout, 0, 0, 10 );
	           int row;

	           for ( row = 0; row < numRows; row++ ) 
	           {
	               QLineEdit *ed = new QLineEdit( mainwin );
	               // The line edit goes in the second column
	               grid->addWidget( ed, row, linedCol );

	               // Make a label that is a buddy of the line edit
	               QString s;
	               s.sprintf( "Line &%d", row+1 );
	               QLabel *label = new QLabel( ed, s, mainwin );
	               // The label goes in the first column.
	               grid->addWidget( label, row, labelCol );
	           }

	           // The multiline edit will cover the entire vertical range of the
	           // grid (rows 0 to numRows) and stay in column 2.

	           med = new QMultiLineEdit( mainwin );
	           grid->addMultiCellWidget( med, 0, -1, multiCol, multiCol );

	           // The labels will take the space they need. Let the remaining
	           // horizontal space be shared so that the multiline edit gets
	           // twice as much as the line edit.
	           grid->setColStretch( linedCol, 10 );
	           grid->setColStretch( multiCol, 20 );
	   
	   
	           
	           // Add a widget at the bottom.
	                      
	                      
		        QLabel* sb = new QLabel( mainwin );
		        sb->setText( "Let's pretend this is a status bar" );
		        sb->setFrameStyle( QFrame::Panel | QFrame::Sunken );
		        // This widget will use all horizontal space, and have a fixed height.
		
		        // we should have made a subclass and implemented sizePolicy there...
		        sb->setFixedHeight( sb->sizeHint().height() );
		
		        //sb->setAlignment( AlignVCenter | AlignLeft );
		        topLayout->addWidget( sb );
		
		        topLayout->activate();
		        
		        
		        
		        
		        
		        MySignalDealer::connect(this->loadWF_but,SIGNAL(clicked()),this,SLOT(loadWF_slot()));
		        MySignalDealer::connect(this->loadNet_but,SIGNAL(clicked()),this,SLOT(loadNet_slot()));
		        MySignalDealer::connect(this->loadEdges_but,SIGNAL(clicked()),this,SLOT(loadEdges_slot()));
		        MySignalDealer::connect(this->cleanEdges_but,SIGNAL(clicked()),this,SLOT(cleanEdges_slot()));
		        MySignalDealer::connect(this->cleanWF_but,SIGNAL(clicked()),this,SLOT(cleanWF_slot()));
		        MySignalDealer::connect(this->cleanNet_but,SIGNAL(clicked()),this,SLOT(cleanNet_slot()));
		        MySignalDealer::connect(but,SIGNAL(clicked()),this,SLOT(print_slot()));
		        
	   

}

MySignalDealer::MySignalDealer(int argc, char **argv)
:QApplication(argc,argv)
{
}

MySignalDealer::~MySignalDealer()
{
}


void MySignalDealer::print_slot()
{
	Platform::Platform::dumpPS();
}


void MySignalDealer::loadWF_slot()
{
	Platform::Platform::showAllWF();
}

void MySignalDealer::loadNet_slot()
{
	Platform::Platform::showAllNet();
}

void MySignalDealer::loadEdges_slot()
{
	Platform::Platform::showAllEdges();
}

void MySignalDealer::cleanEdges_slot()
{
	Platform::Platform::hideAllEdges();
}

void MySignalDealer::cleanWF_slot()
{
	Platform::Platform::hideAllWF();
}

void MySignalDealer::cleanNet_slot()
{
	Platform::Platform::hideAllNet();
}



void MySignalDealer::addElement_slot(int el)
{
	Bezier_Element* E;
	
	if(((int)el/100)==0)
	{
		fprintf(stderr,"el = %d",el);
		  	
		 E = new BezierTetrahedron2(el%100);
		 ((BezierTetrahedron2*)E)->init(5);
		 Platform::Platform::addBezierElement(E,0);
	}
	if(((int)el/100)==1)
	{
		fprintf(stderr,"el = %d",el);
		  	
		 E = new BezierCube2(el%100,el%100,el%100,1);
		 ((BezierCube2*)E)->init(5);
		 Platform::Platform::addBezierElement(E,1);
	}
	if(((int)el/100)==2)
	{
		fprintf(stderr,"el = %d",el);
		  	
		 E = new BezierTriangle2(el%100);
		 ((BezierTriangle2*)E)->init(5);
		 Platform::Platform::addBezierElement(E,0);
	}
	if(((int)el/100)==3)
	{
		fprintf(stderr,"el = %d",el);
		  	
		 E = new BezierRectangle2(el%100,el%100,1);
		 ((BezierRectangle2*)E)->init(5);
		//E = new BezierPrism(el%100,el%100,1);
		 //((BezierPrism*)E)->init(5);
				  
		Platform::Platform::addBezierElement(E,1);
	}
	if(((int)el/100)==4)
	{
		fprintf(stderr,"el = %d",el);
		  	
		 //E = new BezierRectangle2(el%100,el%100,1);
		 //((BezierRectangle2*)E)->init(5);
		E = new BezierPrism(el%100,el%100,1);
		 ((BezierPrism*)E)->init(5);
				  
		Platform::Platform::addBezierElement(E,1);
	}
	
	this->MySignalDealer::updateElements();
	
}



void MySignalDealer::disconnect_slot()
{
	
	Platform::disconnect();
	
}


void MySignalDealer::validateConnection_slot()
{
	
	if(Platform::validateConnection()==0)
	{
	    QMessageBox::critical( 0, "Visual Bezier",
	        QString("The selected elements are not compatible. ") +
	        "\n Check each element's degree." );
	    
	    Platform::inter_idx=-1;
	    Platform::modif_idx=-1;
	}
	
}



void MySignalDealer::setInteract_slot(int idx)
{
	Platform::inter_idx = idx;
	
	fprintf(stderr," inter_idx = %d \n",idx);
}

void MySignalDealer::setModif_slot(int idx)
{
	Platform::modif_idx = idx;

	fprintf(stderr," modif_idx = %d \n",idx);
}




void MySignalDealer::dummyMsg()
{
	//Platform::Platform::updateAllWF();
	fprintf(stderr,"MySignalDealer:dummyMsg\n");
}
