#include "Platform.h"

#include "../CAGD_elements/BezierTriangle.h"
#include "../CAGD_elements/BezierRectangle.h"
#include "../CAGD_elements/BezierPoint.h"



int Platform::connected;

SoQtExaminerViewer *Platform::eviewer_l;
SoQtExaminerViewer *Platform::eviewer_r;

SoPerspectiveCamera *Platform::myCamera_l;
	  SoPerspectiveCamera * Platform::myCamera_r;

	SoSeparator *Platform::root_l;
	SoSeparator *Platform::root_r;

	Index::IndexedMatrix * Platform::matrix;
	Index::IndexedMPMatrix * Platform::mPmatrix;
	
	SoSeparator** Platform::cp_El;
	 SoSeparator*** Platform::cps;
	  SoSeparator** Platform::wfSEP;
	  SoSeparator** Platform::edgesSEP;
	  SoSeparator** Platform::sep_lin;
	  SoSeparator** Platform::sep_lin_bkp;
	  SoSeparator** Platform::netSEP;
	
	  SbVec3f* Platform::orig_pos;
	
	 Bezier_Element** Platform::be;
	 SoMaterial** Platform::mat;

	 SoMaterial* Platform::def_mat;
	 SoMaterial* Platform::net_mat;
	 
	 
	 int Platform::inter_idx;
	 int Platform::modif_idx;
	 
	 
	 int* Platform::n;
	 int* Platform::init;
	  int Platform::moved;
	  int Platform::n_el;
	  
	  int Platform::plotWF;
	  int Platform::plotEdges;
	  int Platform::plotNet;
	  
	  int  Platform::selected_be;



void Platform::resetNel()
{
	Platform::n_el = 0;
}

void Platform::addBezierElement(Bezier_Element *be,int pos)
{

	def_mat = new SoMaterial;
	if((Platform::n_el+1)%3==0)
		def_mat->diffuseColor.setValue(1,0,0);
	if((Platform::n_el+1)%3==1)
			def_mat->diffuseColor.setValue(0,1,0);
	if((Platform::n_el+1)%3==2)
			def_mat->diffuseColor.setValue(0,0,1);
		
	
	
	
	Platform::Platform::setBezierElement(Platform::n_el,be,Platform::def_mat);
	
	
	Platform::Platform::initCPS(Platform::n_el);
	Platform::Platform::updateBE(Platform::n_el,1);
	
	if(pos==0)
		Platform::root_l->addChild(sep_lin[Platform::n_el]);
	else
		Platform::root_r->addChild(sep_lin[Platform::n_el]);
			

	Platform::n_el++;
}





void Platform::disconnect()
{
	int oint,omod;
	
	oint = be[inter_idx]->getOrder();
	omod = be[modif_idx]->getOrder();
	
	Platform::connected=0;
	
	if((oint>1)&&(omod==1)) //tensorial 2 simplicial
	{
		
		
		Platform::root_l->removeChild(0);
		Platform::root_l->insertChild(Platform::myCamera_l,0);
		
		inter_idx = -1;
		modif_idx = -1;
		
		return;
	}
	else
		if((oint==1)&&(omod>1))
		{
			Platform::root_r->removeChild(0);
			Platform::root_r->insertChild(Platform::myCamera_r,0);
			
			inter_idx = -1;
			modif_idx = -1;	
			return;
		}
		
}


int Platform::validateConnection()
{
	int oint,omod;
	int totdeg_int,totdeg_mod;
	int *deg_int,*deg_mod;
	
	int i;
	
	int simpDim;
	
	oint = be[inter_idx]->getOrder();
	omod = be[modif_idx]->getOrder();
	
	deg_int = be[inter_idx]->getDegrees();
	deg_mod = be[modif_idx]->getDegrees();
		
	totdeg_int=0;
	totdeg_mod=0;
	
	
	for(i=0;i<oint;i++)
		totdeg_int =totdeg_int+ deg_int[i];
	
	for(i=0;i<omod;i++)
			totdeg_mod =totdeg_mod+ deg_mod[i];
	
	if((oint>1)&&(omod==1)) //tensorial 2 simplicial
	{
		if(totdeg_int!=totdeg_mod)
			return 0;
		Platform::matrix = MathFunction::Bernstein::Bernstein::buildMatrixTensorial2Simplicial(be[Platform::inter_idx]->getOrder(),be[Platform::inter_idx]->getDegrees());
		Platform::mPmatrix = MathFunction::Bernstein::Bernstein::buildMPMatrixTensorial2Simplicial(be[Platform::inter_idx]->getOrder(),be[Platform::inter_idx]->getDegrees());	
		
		Platform::root_l->removeChild(0);
		Platform::root_l->insertChild(Platform::myCamera_r,0);
	
		
		Platform::connected=1;
			
		
		return 1;
	}
	else
		if((oint==1)&&(omod>1))
		{
			for(i=0;i<omod;i++)
				if(deg_mod[i]!=deg_int[0])
					return 0;
			
			simpDim = be[inter_idx]->getDimensions()[0];
			
			if(simpDim!=omod)
				return 0;
			
			//simplicial->dim = tensorial->order
			Platform::matrix = MathFunction::Bernstein::Bernstein::buildMatrixSimplicial2Tensorial(simpDim,totdeg_int);
			Platform::mPmatrix = MathFunction::Bernstein::Bernstein::buildMPMatrixSimplicial2Tensorial(simpDim,totdeg_int);	
			mPmatrix->IndexedMPMatrix::print(stderr);
			Platform::root_r->removeChild(0);
			Platform::root_r->insertChild(Platform::myCamera_l,0);
			

			Platform::connected=1;
			
			return 1;
		}
		else
			if((oint==1)&&(omod==1))
			{
				if(deg_mod[0]!=deg_int[0])
					return 0;
				
				simpDim = be[inter_idx]->getDimensions()[0];
				//simplicial->dim = tensorial->order
				Platform::matrix = MathFunction::Bernstein::Bernstein::buildMatrixSimplicial2Simplicial(simpDim,deg_int[0],Domain::AffineTransformation::getExample());
				Platform::mPmatrix = MathFunction::Bernstein::Bernstein::buildMPMatrixSimplicial2Simplicial(simpDim,deg_int[0],Domain::AffineTransformation::getExample());
				Platform::connected=1;
							
				return 1;
							
			}
			else
				return 0;
	
	return 0;
	
}

   void Platform::initPlataform(int nel)
   {
	   Platform::n_el = nel;
	   int i;
	   
	   Platform::be = (Bezier_Element**)calloc(nel,sizeof(Bezier_Element*));
	   Platform::mat = (SoMaterial**)calloc(nel,sizeof(SoMaterial*));
	   Platform::wfSEP = (SoSeparator**)calloc(nel,sizeof(SoSeparator*));
	   Platform::edgesSEP = (SoSeparator**)calloc(nel,sizeof(SoSeparator*));
	   Platform::sep_lin = (SoSeparator**)calloc(nel,sizeof(SoSeparator*));
	   Platform::sep_lin_bkp = (SoSeparator**)calloc(nel,sizeof(SoSeparator*));
	   Platform::cp_El = (SoSeparator**)calloc(nel,sizeof(SoSeparator*));
	   Platform::netSEP = (SoSeparator**)calloc(nel,sizeof(SoSeparator*));
	   
	   Platform::cps = (SoSeparator***)calloc(nel,sizeof(SoSeparator**));
	   Platform::n = (int*)calloc(nel,sizeof(int));
	   
	   Platform::init = (int*)calloc(nel,sizeof(int));
	   
	   
	   Platform::orig_pos = (SbVec3f*)calloc(nel,sizeof(SbVec3f));
	   
	   
	   for(i=0;i<nel;i++)
	   {
		   sep_lin[i]= new SoSeparator;
		   sep_lin_bkp[i]= new SoSeparator;
			   
	   }
	   
	   Platform::plotNet=1;
	   Platform::plotEdges=1;
	   Platform::plotWF=1;
	   
	   
	   Platform::net_mat = new SoMaterial();
   	   Platform::net_mat->diffuseColor.setValue(1,0,0);
   	   
	   Platform::def_mat = new SoMaterial();
	   Platform::def_mat->diffuseColor.setValue(1,0,0);
	   
	   Platform::inter_idx = -1;
	   Platform::modif_idx = -1;
	   
	   Platform::selected_be = -1;
	   	   
	   

		Platform::connected=0;
   }



Platform::Platform()
{
}

Platform::~Platform()
{
}

void Platform::initAllCPS()
{
	int i;
	for(i=0;i<Platform::n_el;i++)
		Platform::Platform::initCPS(i);

}


void Platform::updateAllBE(int op)
{
	int i;
	for(i=0;i<Platform::n_el;i++)
		Platform::updateBE(i,op);
	
}

void Platform::initCPS(int idx)
{
	cps[idx] = (SoSeparator**) calloc(be[idx]->getN(), sizeof(SoSeparator*));
	n[idx] = be[idx]->getN();

}

void dragFinishCallback(void *, SoDragger *);
void dragStartCallback(void *, SoDragger *);
void dragMotionCallback(void *, SoDragger *);


void Platform::setBezierElement(int idx,Bezier_Element* be, SoMaterial* m)
{
	Platform::be[idx] = be;
	Platform::n[idx] = be->Bezier_Element::getN();
	Platform::mat[idx] = m;
}


void Platform::hideAllWF()
{
	if(Platform::plotWF==0)
		return;
	int i;
	for(i=0;i<Platform::n_el;i++)
		Platform::Platform::hideWF(i);
	
	Platform::plotWF=0;
}

void Platform::hideWF(int idx)
{

	sep_lin_bkp[idx]->addChild(wfSEP[idx]);
	sep_lin[idx]->removeChild(wfSEP[idx]);
	

}

void Platform::showAllWF()
{
	if(Platform::plotWF==1)
		return;
	int i;
	for(i=0;i<Platform::n_el;i++)
		Platform::showWF(i);
	
	Platform::plotWF=1; 	
	
}


void Platform::showAllEdges()
{
	if(Platform::plotEdges==1)
		return;
	int i;
	for(i=0;i<Platform::n_el;i++)
		Platform::showEdges(i);
	
	Platform::plotEdges=1; 	
	
}


void Platform::showEdges(int idx)
{	 		

	
	sep_lin[idx]->insertChild(edgesSEP[idx],0);
	sep_lin_bkp[idx]->removeChild(edgesSEP[idx]);
 		
}
void Platform::showWF(int idx)
{	 		

	
	sep_lin[idx]->insertChild(wfSEP[idx],0);
	sep_lin_bkp[idx]->removeChild(wfSEP[idx]);
 		
}

void Platform::showAllNet()
{
	int i;
	
	if(Platform::plotNet==1)
		return;
	
	
	for(i=0;i<Platform::n_el;i++)
		Platform::showNet(i);
	
	
	Platform::plotNet=1;
	
}


void Platform::hideAllNet()
{
	if(Platform::plotNet==0)
			return;
	
	int i;
	for(i=0;i<Platform::n_el;i++)
		Platform::hideNet(i);
	
	Platform::plotNet=0;
}

void Platform::hideAllEdges()
{
	if(Platform::plotEdges==0)
			return;
	
	int i;
	for(i=0;i<Platform::n_el;i++)
		Platform::hideEdges(i);
	
	Platform::plotEdges=0;
}

void Platform::hideEdges(int idx)
{
	
	
	sep_lin_bkp[idx]->addChild(edgesSEP[idx]);
		
	sep_lin[idx]->removeChild(edgesSEP[idx]);
	

}


void Platform::hideNet(int idx)
{
	
	
	sep_lin_bkp[idx]->addChild(netSEP[idx]);
	sep_lin_bkp[idx]->addChild(cp_El[idx]);
		
	sep_lin[idx]->removeChild(netSEP[idx]);
	sep_lin[idx]->removeChild(cp_El[idx]);	
	

}


void Platform::showNet(int idx)
{


	
	sep_lin[idx]->addChild(netSEP[idx]);

	sep_lin[idx]->addChild(cp_El[idx]);
	
	sep_lin_bkp[idx]->removeChild(netSEP[idx]);
	sep_lin_bkp[idx]->removeChild(cp_El[idx]);	
		

}


void Platform::updateBE(int idx,int op)
{
	 std::vector<float*> points = Platform::be[idx]->wireFrame(10);
	 std::vector<float*> edgePoints = Platform::be[idx]->wireFrameEdges(10);
	 
	 std::vector<float*>::iterator iter;
	 std::vector<float*> net = Platform::be[idx]->controlNet();
	 std::vector<float*> ctrlPts = Platform::be[idx]->getControlPoints();

	 	  
	 int seg_net=0;
	 for(iter=net.begin();iter!=net.end();iter++)
	 	 seg_net++;
	 
	 int segments=0;
	 for(iter=points.begin();iter!=points.end();iter++)
		 segments++;
	 
	 int segmentsEdges=0;
	 	 for(iter=edgePoints.begin();iter!=edgePoints.end();iter++)
	 		 segmentsEdges++;
	 
	 SoSeparator *newsep;
	 int i;
	 
	 
	 //	
	 	 
	if(op==1)
 	{
		if(wfSEP!=0x0)
			sep_lin[idx]->removeChild(wfSEP[idx]);
 		
		wfSEP[idx] = buildPL_vec(points,segments,2,mat[idx]);
 		
		sep_lin[idx]->addChild(wfSEP[idx]);
		
		
		if(edgesSEP!=0x0)
			sep_lin[idx]->removeChild(edgesSEP[idx]);
		
		edgesSEP[idx] = buildPL_vec(edgePoints,segmentsEdges,6,mat[idx]);
		sep_lin[idx]->addChild(edgesSEP[idx]);
		
 	}
 	 
 	 
	 
	 if(!init[idx])
	 {
		 //netSEP[idx] = buildPL_vec(net,seg_net,9,mat[idx]); 
		 netSEP[idx] = buildPL_vec(net,seg_net,9,Platform::net_mat);
	 	 
			 sep_lin[idx]->addChild(netSEP[idx]);
	 
		 
		 newsep = buildCP_vec(ctrlPts,n[idx], 0.3);
		 cp_El[idx] = newsep;
		 
		
		 for(i=0;i<n[idx];i++)
			 cps[idx][i] = (SoSeparator*) newsep->getChild(i);
	 
	 	
			 sep_lin[idx]->addChild(newsep);
		 
	 	init[idx] = 1;
	 }
	 else
	 {
		 //if(plotNet)
		 netSEP[idx] = updatePL_vec(net,seg_net,netSEP[idx]);
		 
		 //if(plotNet)
		 cps[idx] = updateCP_vec(ctrlPts,n[idx],cps[idx]);
	 }
	 
	 
	 
	 //if(!Platform::plotWF)
	//	 Platform::Platform::cleanWF(idx);
	 
	 BezierPoint::BezierPoint::cleanBPvector();
	 fprintf(stderr,"--> %d Bezierpoints allocated\n--> nextId=%d\n",BezierPoint::allocatedBPs,BezierPoint::nextId);
	 
}



void Platform::updateCP(int idx, SoSeparator* auxSEP, int op)
{
	int i;
		
		int j=0;
		float x,y,z;
		int ctrli=-1;
		
		
		
		for(i=0;i<n[idx];i++)
		{
			if( auxSEP == cps[idx][i] )
			{
				((SoTransform*)auxSEP->getChild(0))->translation.getValue().getValue(x,y,z);
				be[idx]->updControlPoints(i,x,y,z);
				
				if((Platform::inter_idx!=-1)&&(Platform::modif_idx!=-1)&&(Platform::inter_idx!=Platform::modif_idx))
					if(idx==Platform::inter_idx)
						{
							
							//be[Platform::modif_idx]->Bezier_Element::setControlPoints(matrix,be[Platform::inter_idx]);
						mPmatrix->IndexedMPMatrix::print(stderr);
						be[Platform::modif_idx]->Bezier_Element::setControlPointsMP(mPmatrix,be[Platform::inter_idx]);
						
					}
					
				ctrli=i;
				j=1;
			}
		}
		
		//updateBE(idx,op);
		updateAllBE(op);
		if(Platform::plotWF==0)
		{
			Platform::plotWF=1;
			Platform::Platform::hideAllWF();
		}
}





 void Platform::setMoved(int v)
{
	Platform::moved = v;
}

 int Platform::hasMoved()
{
	return moved;
}
 
void Platform::defineOrigPos(int idx,SbVec3f pos)
{
	Platform::orig_pos[idx] = pos;
}

SbVec3f Platform::getOrigPos(int idx)
{
	return Platform::orig_pos[idx];
}



int Platform::locateElement(SoSeparator* auxSEP)
{
	int i,j;
	int res = -1;
	
	for(i=0;i<Platform::n_el;i++)
		for(j=0;j<Platform::n[i];j++)
		{	
				if( auxSEP == cps[i][j] )
				{
					res = i;
				}
		}
	
	return res;
}


void Platform::cleanWF(int idx)
{
	wfSEP[idx]->removeAllChildren();
}


 
void dragStartCallback(void *auxSEP, SoDragger *dg_m)
{
	int idx = Platform::locateElement((SoSeparator*)auxSEP);
	
	Platform::cleanWF(idx);
	if(Platform::connected)
		Platform::cleanWF(Platform::modif_idx);
    	
    SoTransform* cp = (SoTransform*) ((SoSeparator*)auxSEP)->getChild(0);
        
    Platform::defineOrigPos(idx,cp->translation.getValue());
        
    Platform::setMoved(0);
}


void dragFinishCallback(void *auxSEP, SoDragger *dg_m)
{       
	int idx = Platform::locateElement((SoSeparator*)auxSEP);
	
       if(Platform::hasMoved())
    	   Platform::updateCP(idx,(SoSeparator*)auxSEP,1);
     
       Platform::setMoved(0);
}


void keyb(void *auxSEP, SoEventCallback *ev)
{
	const SoEvent * event = ev->getEvent();



    if (SO_KEY_PRESS_EVENT(event, N)) 
    {
    	if(Platform::plotWF)
    	{
			  //Platform::cleanAllWF();
			  ev->setHandled();
			  //Platform::plotWF=0;
    	}
	}
    if (SO_KEY_PRESS_EVENT(event, W)) 
        {
    	
    		if(Platform::plotWF==0)
    		{
	          //Platform::Platform::updateAllBE(1);
	    	  ev->setHandled();
	    	  Platform::plotWF=1;
    		}
    	  
    	}
    //else
    	//fprintf(stderr,"sss");
    		  
	
	
}

void dragMotionCallback(void *auxSEP, SoDragger *dg_m)
{
    SoTransform* cp = (SoTransform*) ((SoSeparator*)auxSEP)->getChild(0);
    SoDragPointDragger* dg = (SoDragPointDragger*) ((SoSeparator*)auxSEP)->getChild(1);
    
    int idx = Platform::locateElement((SoSeparator*)auxSEP);
    
  
    cp->translation.setValue(  Platform::Platform::getOrigPos(idx) + dg->translation.getValue() );
    
    dg->translation.setValue(0,0,0);
    
  
    Platform::updateCP(idx,(SoSeparator*)auxSEP,0);
    
    Platform::setMoved(1);

}






////////////////----------tools -------------

SoSeparator* Platform::buildCP_vec(std::vector<float*> pts, int n, float radius)
{
	std::vector<float*>::iterator iter;
	SoSeparator* sep_lin = new SoSeparator;
	SoSeparator* auxSEP;
	SbVec3f *tf, *cpp;
	SbVec3f v,w;	
	
	
	SoTransform *sot;
	//SoTransform *rot;
	
	SoSphere *sph;
	SoDragPointDragger *hdl;

		
	
	cpp = new SbVec3f[n];
	//int i=0;
	
	for(iter=pts.begin();iter!=pts.end();iter++)
	{
		sot = new SoTransform;
		sot->translation.setValue((*iter));
	 
		tf = new SbVec3f;
		tf->setValue((*iter));
		//cpp[i] = (*tf);
		//i++;
		
		auxSEP = new SoSeparator;
		
		auxSEP->addChild(sot);
		
		
		hdl = new SoDragPointDragger;
		
		
		auxSEP->addChild(hdl);
		
		
		
		hdl->addStartCallback(dragStartCallback,  auxSEP);
		hdl->addFinishCallback(dragFinishCallback, auxSEP);
		hdl->addMotionCallback(dragMotionCallback, auxSEP);	
		
		
		//////////////////////////////////////////////////
		// Add EventCallback so Balance Responds to Events
		SoEventCallback *myCallbackNode = new SoEventCallback;
		myCallbackNode->addEventCallback(SoKeyboardEvent::getClassTypeId(),
											keyb, auxSEP);
		
		auxSEP->addChild(myCallbackNode);
		//support->setPart("callbackList[0]", myCallbackNode);
		
		
		
		///////////////////////////////////////////////
		
		
		
		
		
		
		sph = new SoSphere;
		sph->radius.setValue(radius);
		
		
		auxSEP->addChild(sph);
		
		
		sep_lin->addChild(auxSEP);
	}
	
	 

         return sep_lin;
}

SoSeparator* Platform::buildPL_vec(std::vector<float*> lines, int segments, float linewidth, SoMaterial* m)
{
	std::vector<float*>::iterator iter;
	
	SbVec3f* axisPoints = new SbVec3f[2*segments];
	int i=0;
	
	 for(iter=lines.begin();iter!=lines.end();iter++)
	 {
		 
		 axisPoints[2*i].setValue((*iter)[0],(*iter)[1],(*iter)[2]);
		 //fprintf(stderr,"%g %g %g --- %g %g %g \n",(*iter)[0],(*iter)[1],(*iter)[2],
		//		 (*iter)[3],(*iter)[4],(*iter)[5]);
		 axisPoints[2*i +1].setValue((*iter)[3],(*iter)[4],(*iter)[5]);
		 
		 
		 i++;
	 }
	
         SoCoordinate3* majorTick = new SoCoordinate3;
         
         SoSeparator* sep_lin = new SoSeparator;
         
         SoDrawStyle* stl = new SoDrawStyle;
         stl->lineWidth = linewidth;
         sep_lin->insertChild(stl,0);

         majorTick->point.setValues(0,2*segments, axisPoints);

         int32_t* vertices = new int32_t [segments];
         for( int i = 0;i < segments ;i++ )
                 vertices[i] = 2;

         SoLineSet* lineset = new SoLineSet;
         lineset->numVertices.setValues(0,segments, vertices);

         //sep_lin->addChild();
         sep_lin->insertChild(m,1);
         sep_lin->insertChild(majorTick,2);
         sep_lin->insertChild(lineset,3);


         return sep_lin;
}

SoSeparator* Platform::updatePL_vec(std::vector<float*> lines, int segments, SoSeparator* sep_lin)
{
	std::vector<float*>::iterator iter;
	
	SbVec3f* axisPoints = new SbVec3f[2*segments];
	int i=0;
	
	 for(iter=lines.begin();iter!=lines.end();iter++)
	 {
		 
		 axisPoints[2*i].setValue((*iter)[0],(*iter)[1],(*iter)[2]);
		 axisPoints[2*i +1].setValue((*iter)[3],(*iter)[4],(*iter)[5]);
		 
		 
		 i++;
	 }
	
         SoCoordinate3* majorTick = (SoCoordinate3*)sep_lin->getChild(2);
     
         SoLineSet* lineset = (SoLineSet*)sep_lin->getChild(3);
                  
         //SoSeparator* sep_lin = new SoSeparator;

	 	
	 

         majorTick->point.setValues(0,2*segments, axisPoints);

         int32_t* vertices = new int32_t [segments];
         for( int i = 0;i < segments ;i++ )
                 vertices[i] = 2;

         lineset->numVertices.setValues(0,segments, vertices);

         //sep_lin->addChild();
         //sep_lin->addChild(majorTick);
         //sep_lin->addChild(lineset);


         return sep_lin;
}
SoSeparator** Platform::updateCP_vec(std::vector<float*> pts, int n, SoSeparator** auxSEP)
{
	std::vector<float*>::iterator iter;
	//SoSeparator* sep_lin = new SoSeparator;
	//SoSeparator* auxSEP;
	//SbVec3f *tf, *cpp;
	SbVec3f v,w;	
	
	
	SoTransform *sot;
	//SoTransform *rot;
	
	//SoSphere *sph;
	//SoDragPointDragger *hdl;

		
	
	//cpp = new SbVec3f[n];
	int i=0;
	
	for(iter=pts.begin();iter!=pts.end();iter++)
	{
		//auxSEP = (SoSeparator*) sep_lin->getChild(i);
		
		sot = (SoTransform*)auxSEP[i]->getChild(0);		
		sot->translation.setValue((*iter));
	 
		i++;
		
	}
	
	 

         return auxSEP;
}


void Platform::dumpPS()
{
	int printerDPI=300;
	
	const SbViewportRegion &vp = Platform::eviewer_l->getViewportRegion();
	const SbVec2s &imagePixSize = vp.getViewportSizePixels();
	SbVec2f imageInches;
	float pixPerInch;
	pixPerInch = SoOffscreenRenderer::getScreenPixelsPerInch();
	imageInches.setValue((float)imagePixSize[0] / pixPerInch,
	(float)imagePixSize[1] / pixPerInch);
	// The resolution to render the scene for the printer
	// is equal to the size of the image in inches times
	// the printer DPI;
	SbVec2s postScriptRes;
	postScriptRes.setValue((short)(imageInches[0])*printerDPI,
	(short)(imageInches[1])*printerDPI);
	// Create a viewport to render the scene into.
	SbViewportRegion myViewport;
	myViewport.setWindowSize(postScriptRes);
	myViewport.setPixelsPerInch((float)printerDPI);
	// Render the scene
	SoOffscreenRenderer *myRenderer =
	new SoOffscreenRenderer(myViewport);
	
	
	myRenderer->setBackgroundColor(SbColor(0.95,0.95,0.95));
		 
	
	if (!myRenderer->render(Platform::root_l)) {
	delete myRenderer;
	return;
	}
	
	
	// Generate PostScript and write it to the given file
	myRenderer->writeToPostScript(fopen("/tmp/dumpleft.ps","w"));
	delete myRenderer;
	
	
	
	const SbViewportRegion &vpp = Platform::eviewer_r->getViewportRegion();
	const SbVec2s &imagePixSizee = vpp.getViewportSizePixels();
	
	
	
	imageInches.setValue((float)imagePixSizee[0] / pixPerInch,
	(float)imagePixSize[1] / pixPerInch);
	// The resolution to render the scene for the printer
	// is equal to the size of the image in inches times
	// the printer DPI;
	
	postScriptRes.setValue((short)(imageInches[0])*printerDPI,
	(short)(imageInches[1])*printerDPI);
	// Create a viewport to render the scene into.
	
	myViewport.setWindowSize(postScriptRes);
	myViewport.setPixelsPerInch((float)printerDPI);
	// Render the scene
	myRenderer =
	new SoOffscreenRenderer(myViewport);
	
	myRenderer->setBackgroundColor(SbColor(0.95,0.95,0.95));
	 
	
	if (!myRenderer->render(Platform::root_r)) {
	delete myRenderer;
	return;
	}
	

     
	
	// Generate PostScript and write it to the given file
	myRenderer->writeToPostScript(fopen("/tmp/dumpright.ps","w"));
	delete myRenderer;
	
	
	return;
}
