#ifndef PLATFORM_H_
#define PLATFORM_H_

#include <Inventor/Qt/viewers/SoQtExaminerViewer.h>
#include <Inventor/events/SoEvent.h>
#include <Inventor/events/SoKeyboardEvent.h>
#include <Inventor/nodes/SoEventCallback.h>
#include <Inventor/Qt/SoQt.h>
#include <Inventor/Qt/viewers/SoQtExaminerViewer.h>
#include <Inventor/nodes/SoBaseColor.h>
#include <Inventor/nodes/SoSphere.h>
#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/nodes/SoDirectionalLight.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoPerspectiveCamera.h>
#include <Inventor/manips/SoTrackballManip.h>
#include <Inventor/manips/SoTransformBoxManip.h>
#include <Inventor/draggers/SoTranslate2Dragger.h>
#include <Inventor/nodes/SoCylinder.h>
#include <Inventor/nodes/SoLineSet.h>
#include <Inventor/nodes/SoTransform.h>
#include <Inventor/draggers/SoDragger.h>
#include <Inventor/nodes/SoDrawStyle.h>


#include <Inventor/SbViewportRegion.h>
#include<Inventor/SbVec2s.h>
#include <Inventor/SoOffscreenRenderer.h>

#include "../CAGD_elements/BezierTriangle.h"
#include <vector>
#include <Inventor/draggers/SoDragPointDragger.h>
#include <Inventor/nodes/SoCylinder.h>
#include "../CAGD_elements/BezierTetrahedron.h"
#include "../CAGD_elements/BezierCurve.h"
#include "../CAGD_elements/BezierRectangle.h"
#include "../CAGD_elements/BezierCube.h"
#include "../CAGD_elements/Bezier_Element.h"

#include "../../conversionV2/MathFunction/Bernstein.h"




class Platform
{
	


public:	
	
	
	static int *n;
	
	static  int moved;
	
	
	static SoQtExaminerViewer * eviewer_l;
	static SoQtExaminerViewer * eviewer_r;
	
	static SoSeparator *root_l;
	static SoSeparator *root_r;
	
	
	static 	Index::IndexedMatrix * matrix;
	static 	Index::IndexedMPMatrix * mPmatrix;
	
	static SbVec3f* orig_pos;
	static SoSeparator ***cps;
	static  SoSeparator **wfSEP;
	static SoSeparator** edgesSEP;
	static  SoSeparator **sep_lin;
	static SoSeparator** sep_lin_bkp;
	static  SoSeparator **cp_El;
	static  SoSeparator **netSEP;
	static int plotWF;
	static int plotEdges;
	static int plotNet;
		
	
	 static int  inter_idx;
	 static int  modif_idx;
	 static SoMaterial*  def_mat;
	 static SoMaterial*  net_mat;
	
	 
	 
	 
	 static SoPerspectiveCamera *myCamera_l;
	 static SoPerspectiveCamera *myCamera_r;
	 
	 
	 
	 static int  connected;
	static int *init;

	static int n_el;
	
	static Bezier_Element** be;
	static SoMaterial** mat;
	

	static int  selected_be;
	

	
	static void  disconnect();
	

	static void  addBezierElement(Bezier_Element *be, int pos);
	
	static int  validateConnection();
	
	static void  hideNet(int idx);
	static void  hideAllNet();
	
	static void  showNet(int idx);
	static void  showAllNet();
		
	
	static void  showWF(int idx);
	static void  showAllWF();
	
	
	static void  showAllEdges();
	static void  showEdges(int idx);
	static void  hideAllEdges();
	static void hideEdges(int idx);
	

	
	static void  hideAllWF();
	static void  hideWF(int idx);
		
	
	static void  updateAllBE(int op);
	
	static void  buildWF(int idx);
	
	static void  initAllCPS();
	
	
	static void  togleWireFrame();
	 static void  togleNet();
	
	static void  initPlataform(int nel);
	
	static int  locateElement(SoSeparator* sep);
	
	static  void  setBezierElement(int idx,Bezier_Element* be, SoMaterial* m);
	
	static void  setMoved(int v);
	static int  hasMoved();
	
	static void  defineOrigPos(int idx,SbVec3f pos);
	static SbVec3f  getOrigPos(int idx);
	
	static void  setN(int n);
	static int  getN();
	
	
	static void  resetNel();

	
	static void  initCPS(int idx);
	
	
	static void  dumpPS();
	
	
	static void  cleanWF(int idx);
	
	 static void  updateBE(int idx,int op);
	 static void  updateCP(int idx,SoSeparator* auxSEP, int op);
	
	
	
	static SoSeparator*  buildCP_vec(std::vector<float*> pts, int n, float radius);
	static SoSeparator*  buildPL_vec(std::vector<float*> lines, int segments, float linewidth, SoMaterial* m);
	static SoSeparator*  updatePL_vec(std::vector<float*> lines, int segments, SoSeparator* sep_lin);
	static SoSeparator**  updateCP_vec(std::vector<float*> pts, int n, SoSeparator** auxSEP);
	
	
	
	
	
	Platform();
	virtual ~Platform();
};

#endif /*PLATFORM_H_*/
