#ifndef AFFINETRANSFORMATION_H_
#define AFFINETRANSFORMATION_H_

#include "SimplexPoint.h"
#include "stdio.h"
#include "../Index/MatrixIdx.h"
#include "../Numbers/Float.h"

namespace Domain
{

class AffineTransformation
{
public:
	int origDim;
	int destDim;
	
	static FILE *datafp;
	
	SimplexPoint** v; // each element of this vector is a column of the transformation matrix
	
	AffineTransformation(int origDim,int destDim );
	
	double  powerMatrixIdx(Index::MatrixIdx *e);
	double  powerMatrixIdx2(Index::MatrixIdx *e);
	Float*  mppowerMatrixIdx(Index::MatrixIdx *e);
	
	static AffineTransformation*  getExample();
	static AffineTransformation*  getExample2();

	static AffineTransformation**  getExample3();
	
	static AffineTransformation*  getIdentity(int origDim,int destDim );
	static AffineTransformation*  getFromImage(SimplexPoint** img, int size);
	static AffineTransformation*  getFromColumns(SimplexPoint** cols, int ncols);
	
	void  print(FILE* datafp);
	void  print();
	
	SimplexPoint*  transform(SimplexPoint* u);
	
	
	
	virtual ~AffineTransformation();
};

}

#endif /*AFFINETRANSFORMATION_H_*/
