#include "../Index/MultiIdx.h"
#include "../Domain/SimplexPoint.h"
#include "math.h"
#include<vector>
#include<stdio.h>


namespace Domain
{


FILE* SimplexPoint::datafp; 

static SimplexPoint* sum(SimplexPoint** v, int n)
{
	SimplexPoint* p;
	return p;
}


SimplexPoint* SimplexPoint::clone()
{
	SimplexPoint* spx = new SimplexPoint( this->dim );
	int i;

	for(i=0;i<= this->dim;i++)
		spx->coord[i] = this->coord[i];

	return spx;
}

SimplexPoint* SimplexPoint::fromDoubleVector(double* v, int dim)
{
	int i;
	SimplexPoint* spx = new SimplexPoint(dim);

	for(i=0;i<= dim;i++)
		spx->coord[i]=v[i];

	return spx;
}

double SimplexPoint::dot(SimplexPoint* u)
{
	double res = 0;
	int i;
	
		
	for(i=0;i<=u->dim;i++)
		res = res+ ((u->coord[i])* (this->coord[i]));

	return res;
}


SimplexPoint::SimplexPoint(int dim)
{
	int i;
	
	// if no stream is set ... dump it 
	// to stderr
	if(SimplexPoint::datafp==NULL)
		SimplexPoint::datafp = stderr;
	
	this->dim = dim;
	
	this->coord = new double[dim+1];
	
	for(i=1;i< (dim+1);i++)
		this->coord[i]=0;
	
	this->coord[0]=1;
	
}

SimplexPoint::SimplexPoint(int dim, int value)
{
	int i;
	
	// if no stream is set ... dump it 
	// to stderr
	if(SimplexPoint::datafp==NULL)
		SimplexPoint::datafp = stderr;
	
	this->dim = dim;
	
	this->coord = new double[dim+1];
	
	for(i=0;i< (dim+1);i++)
		this->coord[i]=value;
	
	
}

SimplexPoint::~SimplexPoint()
{
}

int SimplexPoint::Ifactorial(int n)
{
	int res=1;
	int i;
	
	for(i=n;i>1;i--)
		res = res*i;
	
	return res;
}

void SimplexPoint::setCoord(int coord, double value)
{
	this->coord[coord] = value;
}







double SimplexPoint::powerMultiIdx(Index::MultiIdx *exp)
{
	int i;
	double res = 1;
	
	for(i=0; i <= this->dim; i++)
	{
		res = res * pow(this->coord[i], exp->idx[i]);
	}
	
	return res;
}




SimplexPoint* SimplexPoint::addSuffix(double p)
{
	SimplexPoint* newp;
	int i;
	
	newp = new SimplexPoint(this->dim+1);
	
	for(i=0; i<= this->dim;i++)
		newp->coord[i] = this->coord[i];
	
	newp->coord[this->dim+1]=p;
	
	return newp;
	
}

SimplexPoint* SimplexPoint::addPrefix(double p)
{
	SimplexPoint* newp;
	int i;
	
	newp = new SimplexPoint(this->dim+1);
	
	for(i=0; i<= this->dim;i++)
		newp->coord[i+1] = this->coord[i];
	
	newp->coord[0]=p;
	
	return newp;
	
}


std::vector<SimplexPoint*> SimplexPoint::addPrefix(double p, std::vector<SimplexPoint*> v,std::vector<SimplexPoint*> acum)
{
	std::vector<SimplexPoint*>::iterator iter;
	SimplexPoint* tmp;
	
	for(iter=v.begin();iter!= v.end();iter++)
	{
		//(*iter)->print();
		if(  ((*iter)->sum() + p) <= 1 )
		{
			tmp = (*iter)->addPrefix(p);
			acum.push_back( tmp );
			//tmp->print();
		}
	}	
	
	return acum;
}


void SimplexPoint::println()
{
	int i;
	fprintf(SimplexPoint::datafp,"(");
	for(i=0;i < dim+1 ; i++)
		fprintf(SimplexPoint::datafp," %g;",this->coord[i]);
	fprintf(SimplexPoint::datafp,")\n");
}

void SimplexPoint::println(FILE* fp)
{
	if(fp==NULL)
		return;
	
	int i;
	fprintf(fp,"(");
	for(i=0;i < dim+1 ; i++)
		fprintf(fp," %g;",this->coord[i]);
	fprintf(fp,")\n");
}

void SimplexPoint::print()
{
	int i;
	fprintf(SimplexPoint::datafp,"(");
	for(i=0;i < dim+1 ; i++)
		fprintf(SimplexPoint::datafp," %g;",this->coord[i]);
	fprintf(SimplexPoint::datafp,")");
}

void SimplexPoint::print(FILE* fp)
{
	if(fp==NULL)
		return;
	
	int i;
	fprintf(fp,"(");
	for(i=0;i < dim+1 ; i++)
		fprintf(fp," %g;",this->coord[i]);
	fprintf(fp,")");
}


void SimplexPoint::printPlot(double v)
{
	int i;
	for(i=0;i < dim ; i++)
		fprintf(SimplexPoint::datafp," %g ",this->coord[i]);
	
	fprintf(SimplexPoint::datafp,"%g \n",v);
}


double SimplexPoint::sum()
{
	int i;
	double r=0;
	
	for(i=0;i <= this->dim;i++)
		r = r + this->coord[i];
	
	return r;
	
}


SimplexPoint* SimplexPoint::fromDouble(double p)
{
	SimplexPoint* u = new SimplexPoint(0);
	u->coord[0] = p;
	
	return u;
}

std::vector<SimplexPoint*> SimplexPoint::domainPoints(int dim,int n)
{
	int i,j;
	std::vector<SimplexPoint*> v,acum;
	std::vector<SimplexPoint*>::iterator iter;	
	
	for(j=0;j <= n ;j++)
	{
		v.push_back(SimplexPoint::fromDouble(((double)j)/n));
	}
	
	//for(iter=v.begin();iter!= v.end();iter++)
	//	(*iter)->print();
	
	for(i=dim-1;  i>0 ;i--)
	{
		for(j=0; j <= n ;j++)
		{
			
			acum = SimplexPoint::addPrefix( ((double)j)/n,v,acum);
		}
		v = acum;
		acum.clear();
		
	}
	
	for(iter=v.begin();iter!= v.end();iter++)
		acum.push_back((*iter)->extendPoint2Simplex());
	
	return acum;
}


SimplexPoint* SimplexPoint::extendPoint2Simplex()
{
	return this->SimplexPoint::addPrefix(1 - this->sum());
}

SimplexPoint* SimplexPoint::TextendPoint2Simplex()
{
	return this->SimplexPoint::addSuffix(1 - this->sum());
}




}
