#ifndef SIMPLEXPOINT_H_
#define SIMPLEXPOINT_H_


#include "../Index/MultiIdx.h"
#include<math.h>
#include<vector>
#include<stdio.h>

namespace Domain
{




class SimplexPoint
{
public:
	int dim;
	double* coord;
	static FILE* datafp; 
	
public:
	 SimplexPoint(int dim);
	 SimplexPoint(int dim, int value);
	virtual ~SimplexPoint();
	

	static SimplexPoint* sum(SimplexPoint** v, int n);
	
	static SimplexPoint*  fromDoubleVector(double* v,int dim);

	double  dot(SimplexPoint* u);
	SimplexPoint*  clone();

	static int Ifactorial(int n);
	
	void  setCoord(int coord, double value);
	double  powerMultiIdx(Index::MultiIdx *exp);
	
	SimplexPoint*  addPrefix(double p);
	static std::vector<SimplexPoint*>  addPrefix(double p, std::vector<SimplexPoint*> v,std::vector<SimplexPoint*> acum);
	
	static std::vector<SimplexPoint*>  domainPoints(int dim,int n);
	
	static SimplexPoint*  fromDouble(double p);
	
	
	
	void  print();
	void  print(FILE* fp);
	void  println();
	void  println(FILE* fp);
	SimplexPoint*  extendPoint2Simplex();
	void  printPlot(double v);
	SimplexPoint*  addSuffix(double p);
	SimplexPoint*  TextendPoint2Simplex();

	
private:
	double  sum();
	
	
};


}

#endif /*SIMPLEXPOINT_H_*/
